/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.PrintStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class MapUtils {
    private static int debugIndent = 0;

    public static Object getObject(Map map, Object object) {
        if (map != null) {
            return map.get(object);
        }
        return null;
    }

    public static String getString(Map map, Object object) {
        Object v;
        if (map != null && (v = map.get(object)) != null) {
            return v.toString();
        }
        return null;
    }

    public static Boolean getBoolean(Map map, Object object) {
        Object v;
        if (map != null && (v = map.get(object)) != null) {
            if (v instanceof Boolean) {
                return (Boolean)v;
            }
            if (v instanceof String) {
                return new Boolean((String)v);
            }
            if (v instanceof Number) {
                Number number = (Number)v;
                return number.intValue() != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    public static Number getNumber(Map map, Object object) {
        Object v;
        if (map != null && (v = map.get(object)) != null) {
            if (v instanceof Number) {
                return (Number)v;
            }
            if (v instanceof String) {
                try {
                    String string = (String)v;
                    return NumberFormat.getInstance().parse(string);
                }
                catch (ParseException parseException) {
                    MapUtils.logInfo(parseException);
                }
            }
        }
        return null;
    }

    public static Byte getByte(Map map, Object object) {
        Number number = MapUtils.getNumber(map, object);
        if (number == null) {
            return null;
        }
        if (number instanceof Byte) {
            return (Byte)number;
        }
        return new Byte(number.byteValue());
    }

    public static Short getShort(Map map, Object object) {
        Number number = MapUtils.getNumber(map, object);
        if (number == null) {
            return null;
        }
        if (number instanceof Short) {
            return (Short)number;
        }
        return new Short(number.shortValue());
    }

    public static Integer getInteger(Map map, Object object) {
        Number number = MapUtils.getNumber(map, object);
        if (number == null) {
            return null;
        }
        if (number instanceof Integer) {
            return (Integer)number;
        }
        return new Integer(number.intValue());
    }

    public static Long getLong(Map map, Object object) {
        Number number = MapUtils.getNumber(map, object);
        if (number == null) {
            return null;
        }
        if (number instanceof Long) {
            return (Long)number;
        }
        return new Long(number.longValue());
    }

    public static Float getFloat(Map map, Object object) {
        Number number = MapUtils.getNumber(map, object);
        if (number == null) {
            return null;
        }
        if (number instanceof Float) {
            return (Float)number;
        }
        return new Float(number.floatValue());
    }

    public static Double getDouble(Map map, Object object) {
        Number number = MapUtils.getNumber(map, object);
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return (Double)number;
        }
        return new Double(number.doubleValue());
    }

    public static Map getMap(Map map, Object object) {
        Object v;
        if (map != null && (v = map.get(object)) != null && v instanceof Map) {
            return (Map)v;
        }
        return null;
    }

    public static Object getObject(Map map, Object object, Object object2) {
        Object v;
        if (map != null && (v = map.get(object)) != null) {
            return v;
        }
        return object2;
    }

    public static String getString(Map map, Object object, String string) {
        String string2 = MapUtils.getString(map, object);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public static Boolean getBoolean(Map map, Object object, Boolean bl) {
        Boolean bl2 = MapUtils.getBoolean(map, object);
        if (bl2 == null) {
            bl2 = bl;
        }
        return bl2;
    }

    public static Number getNumber(Map map, Object object, Number number) {
        Number number2 = MapUtils.getNumber(map, object);
        if (number2 == null) {
            number2 = number;
        }
        return number2;
    }

    public static Byte getByte(Map map, Object object, Byte by) {
        Byte by2 = MapUtils.getByte(map, object);
        if (by2 == null) {
            by2 = by;
        }
        return by2;
    }

    public static Short getShort(Map map, Object object, Short s) {
        Short s2 = MapUtils.getShort(map, object);
        if (s2 == null) {
            s2 = s;
        }
        return s2;
    }

    public static Integer getInteger(Map map, Object object, Integer n) {
        Integer n2 = MapUtils.getInteger(map, object);
        if (n2 == null) {
            n2 = n;
        }
        return n2;
    }

    public static Long getLong(Map map, Object object, Long l) {
        Long l2 = MapUtils.getLong(map, object);
        if (l2 == null) {
            l2 = l;
        }
        return l2;
    }

    public static Float getFloat(Map map, Object object, Float f) {
        Float f2 = MapUtils.getFloat(map, object);
        if (f2 == null) {
            f2 = f;
        }
        return f2;
    }

    public static Double getDouble(Map map, Object object, Double d) {
        Double d2 = MapUtils.getDouble(map, object);
        if (d2 == null) {
            d2 = d;
        }
        return d2;
    }

    public static Map getMap(Map map, Object object, Map map2) {
        Map map3 = MapUtils.getMap(map, object);
        if (map3 == null) {
            map3 = map2;
        }
        return map3;
    }

    public static Properties toProperties(Map map) {
        Properties properties = new Properties();
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                ((Hashtable)properties).put(k, v);
            }
        }
        return properties;
    }

    public static synchronized void verbosePrint(PrintStream printStream, Object object, Map map) {
        MapUtils.debugPrintIndent(printStream);
        printStream.println(object + " = ");
        MapUtils.debugPrintIndent(printStream);
        printStream.println("{");
        ++debugIndent;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof Map) {
                MapUtils.verbosePrint(printStream, string, (Map)v);
                continue;
            }
            MapUtils.debugPrintIndent(printStream);
            printStream.println(string + " = " + v);
        }
        --debugIndent;
        MapUtils.debugPrintIndent(printStream);
        printStream.println("}");
    }

    public static synchronized void debugPrint(PrintStream printStream, Object object, Map map) {
        MapUtils.debugPrintIndent(printStream);
        printStream.println(object + " = ");
        MapUtils.debugPrintIndent(printStream);
        printStream.println("{");
        ++debugIndent;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof Map) {
                MapUtils.verbosePrint(printStream, string, (Map)v);
                continue;
            }
            MapUtils.debugPrintIndent(printStream);
            String string2 = v != null ? v.getClass().getName() : null;
            printStream.println(string + " = " + v + " class: " + string2);
        }
        --debugIndent;
        MapUtils.debugPrintIndent(printStream);
        printStream.println("}");
    }

    protected static void debugPrintIndent(PrintStream printStream) {
        int n = 0;
        while (n < debugIndent) {
            printStream.print("    ");
            ++n;
        }
    }

    protected static void logInfo(Exception exception) {
        System.out.println("INFO: Exception: " + exception);
    }
}

