/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Iterator;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.ProxyIterator;

public class FilterIterator
extends ProxyIterator {
    private Predicate predicate;
    private Object nextObject;

    public FilterIterator() {
    }

    public FilterIterator(Iterator iterator) {
        super(iterator);
    }

    public FilterIterator(Iterator iterator, Predicate predicate) {
        super(iterator);
        this.predicate = predicate;
    }

    public boolean hasNext() {
        Iterator iterator = this.getIterator();
        Predicate predicate = this.getPredicate();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!predicate.evaluate(e)) continue;
            this.nextObject = e;
            return true;
        }
        return false;
    }

    public Object next() {
        return this.nextObject;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public void setPredicate(Predicate predicate) {
        this.predicate = predicate;
    }
}

