/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class jTPCC
extends JFrame
implements jTPCCConfig,
ActionListener,
WindowListener {
    private JTabbedPane jTabbedPane;
    private JPanel jPanelControl;
    private JPanel jPanelConfigSwitch;
    private JPanel jPanelTerminalOutputs;
    private JPanel jPanelOutputSwitch;
    private JButton jButtonNextTerminal;
    private JButton jButtonPreviousTerminal;
    private JOutputArea jOutputAreaControl;
    private JOutputArea jOutputAreaErrors;
    private JLabel jLabelInformation;
    private JLabel jPanelTerminalOutputsLabel;
    private ImageIcon imageIconDot;
    private int currentlyDisplayedTerminal;
    private JButton jButtonSelectDatabase;
    private JButton jButtonSelectTerminals;
    private JButton jButtonSelectControls;
    private JButton jButtonSelectWeights;
    private JPanel jPanelConfigDatabase;
    private JPanel jPanelConfigTerminals;
    private JPanel jPanelConfigControls;
    private JPanel jPanelConfigWeights;
    private Border jPanelConfigSwitchBorder;
    private JTextField jTextFieldDatabase;
    private JTextField jTextFieldUsername;
    private JTextField jTextFieldPassword;
    private JTextField jTextFieldDriver;
    private JTextField jTextFieldNumTerminals;
    private JTextField jTextFieldTransactionsPerTerminal;
    private JTextField jTextFieldNumWarehouses;
    private JTextField jTextFieldMinutes;
    private JButton jButtonCreateTerminals;
    private JButton jButtonStartTransactions;
    private JButton jButtonStopTransactions;
    private JTextField paymentWeight;
    private JTextField orderStatusWeight;
    private JTextField deliveryWeight;
    private JTextField stockLevelWeight;
    private JRadioButton jRadioButtonTime;
    private JRadioButton jRadioButtonNum;
    private JCheckBox jCheckBoxDebugMessages;
    private jTPCCTerminal[] terminals;
    private JOutputArea[] terminalOutputAreas;
    private String[] terminalNames;
    private boolean terminalsBlockingExit = false;
    private Random random;
    private long terminalsStarted = 0L;
    private long sessionCount = 0L;
    private long transactionCount;
    private long newOrderCounter;
    private long sessionStartTimestamp;
    private long sessionEndTimestamp;
    private long sessionEndTargetTime = -1L;
    private long fastNewOrderCounter;
    private boolean signalTerminalsRequestEndSent = false;
    private boolean databaseDriverLoaded = false;
    private FileOutputStream fileOutputStream;
    private PrintStream printStreamReport;
    private String sessionStart;
    private String sessionEnd;

    public static void main(String[] args) {
        new jTPCC();
    }

    public jTPCC() {
        super("BenchmarkSQL v2.2");
        Properties ini = new Properties();
        try {
            ini.load(new FileInputStream(System.getProperty("prop")));
        }
        catch (IOException e) {
            System.out.println("could not load properties file");
        }
        System.out.println("driver=" + ini.getProperty("driver"));
        System.out.println("conn=" + ini.getProperty("conn"));
        System.out.println("user=" + ini.getProperty("user"));
        System.out.println("password=******");
        this.random = new Random(System.currentTimeMillis());
        this.setDefaultCloseOperation(0);
        this.setSize(800, 680);
        this.setLocation(112, 30);
        this.setIconImage(new ImageIcon("images/icon.gif").getImage());
        this.addWindowListener(this);
        this.imageIconDot = new ImageIcon("images/dot.gif");
        this.jPanelControl = new JPanel();
        this.jPanelControl.setLayout(new BorderLayout());
        JPanel jPanelConfig = new JPanel();
        jPanelConfig.setLayout(new BorderLayout());
        this.jPanelControl.add((Component)jPanelConfig, "North");
        JPanel jPanelConfigSelect = new JPanel();
        jPanelConfigSelect.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Options ", 2, 2));
        GridLayout jPanelConfigSelectLayout = new GridLayout(4, 1);
        jPanelConfigSelectLayout.setVgap(10);
        jPanelConfigSelect.setLayout(jPanelConfigSelectLayout);
        this.jButtonSelectDatabase = new JButton("Database");
        this.jButtonSelectDatabase.addActionListener(this);
        jPanelConfigSelect.add(this.jButtonSelectDatabase);
        this.jButtonSelectTerminals = new JButton("Terminals");
        this.jButtonSelectTerminals.addActionListener(this);
        jPanelConfigSelect.add(this.jButtonSelectTerminals);
        this.jButtonSelectWeights = new JButton("Weights");
        this.jButtonSelectWeights.addActionListener(this);
        jPanelConfigSelect.add(this.jButtonSelectWeights);
        this.jButtonSelectControls = new JButton("Controls");
        this.jButtonSelectControls.addActionListener(this);
        jPanelConfigSelect.add(this.jButtonSelectControls);
        jPanelConfig.add((Component)jPanelConfigSelect, "West");
        this.jPanelConfigSwitch = new JPanel();
        jPanelConfig.add((Component)this.jPanelConfigSwitch, "Center");
        this.jPanelConfigSwitchBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 2, 2);
        this.jPanelConfigSwitch.setBorder(this.jPanelConfigSwitchBorder);
        this.jPanelConfigDatabase = new JPanel();
        this.jPanelConfigDatabase.setLayout(new GridLayout(3, 1));
        JPanel jPanelConfigDatabase3 = new JPanel();
        this.jPanelConfigDatabase.add(jPanelConfigDatabase3);
        jPanelConfigDatabase3.add(new JLabel("URL"));
        this.jTextFieldDatabase = new JTextField(ini.getProperty("conn", "jdbc:edb://localhost/edb"));
        this.jTextFieldDatabase.setPreferredSize(new Dimension(275, (int)this.jTextFieldDatabase.getPreferredSize().getHeight()));
        jPanelConfigDatabase3.add(this.jTextFieldDatabase);
        jPanelConfigDatabase3.add(new JLabel("      Driver"));
        this.jTextFieldDriver = new JTextField(ini.getProperty("driver", "com.edb.Driver"));
        this.jTextFieldDriver.setPreferredSize(new Dimension(200, (int)this.jTextFieldDriver.getPreferredSize().getHeight()));
        jPanelConfigDatabase3.add(this.jTextFieldDriver);
        this.jPanelConfigDatabase.add(new JPanel());
        JPanel jPanelConfigDatabase2 = new JPanel();
        this.jPanelConfigDatabase.add(jPanelConfigDatabase2);
        jPanelConfigDatabase2.add(new JLabel("Username"));
        this.jTextFieldUsername = new JTextField(ini.getProperty("user", "enterprisedb"));
        this.jTextFieldUsername.setPreferredSize(new Dimension(80, (int)this.jTextFieldUsername.getPreferredSize().getHeight()));
        jPanelConfigDatabase2.add(this.jTextFieldUsername);
        jPanelConfigDatabase2.add(new JLabel("      Password"));
        this.jTextFieldPassword = new JPasswordField(ini.getProperty("password", "password"));
        this.jTextFieldPassword.setPreferredSize(new Dimension(80, (int)this.jTextFieldPassword.getPreferredSize().getHeight()));
        jPanelConfigDatabase2.add(this.jTextFieldPassword);
        this.jPanelConfigTerminals = new JPanel();
        this.jPanelConfigTerminals.setLayout(new GridLayout(2, 1));
        JPanel jPanelConfigTerminals1 = new JPanel();
        this.jPanelConfigTerminals.add(jPanelConfigTerminals1);
        jPanelConfigTerminals1.add(new JLabel("Number of Terminals"));
        this.jTextFieldNumTerminals = new JTextField("1");
        this.jTextFieldNumTerminals.setPreferredSize(new Dimension(28, (int)this.jTextFieldNumTerminals.getPreferredSize().getHeight()));
        jPanelConfigTerminals1.add(this.jTextFieldNumTerminals);
        jPanelConfigTerminals1.add(new JLabel("       Warehouses"));
        this.jTextFieldNumWarehouses = new JTextField("1");
        this.jTextFieldNumWarehouses.setPreferredSize(new Dimension(28, (int)this.jTextFieldNumWarehouses.getPreferredSize().getHeight()));
        jPanelConfigTerminals1.add(this.jTextFieldNumWarehouses);
        jPanelConfigTerminals1.add(new JLabel("       Debug Messages"));
        this.jCheckBoxDebugMessages = new JCheckBox("", false);
        jPanelConfigTerminals1.add(this.jCheckBoxDebugMessages);
        JPanel jPanelConfigTerminals2 = new JPanel();
        this.jPanelConfigTerminals.add(jPanelConfigTerminals2);
        jPanelConfigTerminals2.add(new JLabel("Execute"));
        JPanel jPanelConfigTerminals21 = new JPanel();
        jPanelConfigTerminals21.setLayout(new GridLayout(2, 1));
        jPanelConfigTerminals2.add(jPanelConfigTerminals21);
        this.jTextFieldMinutes = new JTextField("1");
        this.jTextFieldMinutes.setPreferredSize(new Dimension(35, (int)this.jTextFieldMinutes.getPreferredSize().getHeight()));
        jPanelConfigTerminals21.add(this.jTextFieldMinutes);
        this.jTextFieldTransactionsPerTerminal = new JTextField("1");
        this.jTextFieldTransactionsPerTerminal.setPreferredSize(new Dimension(35, (int)this.jTextFieldTransactionsPerTerminal.getPreferredSize().getHeight()));
        jPanelConfigTerminals21.add(this.jTextFieldTransactionsPerTerminal);
        JPanel jPanelConfigTerminals22 = new JPanel();
        jPanelConfigTerminals22.setLayout(new GridLayout(2, 1));
        jPanelConfigTerminals2.add(jPanelConfigTerminals22);
        ButtonGroup buttonGroupTimeNum = new ButtonGroup();
        this.jRadioButtonTime = new JRadioButton("Minutes", true);
        buttonGroupTimeNum.add(this.jRadioButtonTime);
        jPanelConfigTerminals22.add(this.jRadioButtonTime);
        this.jRadioButtonNum = new JRadioButton("Transactions per terminal", false);
        buttonGroupTimeNum.add(this.jRadioButtonNum);
        jPanelConfigTerminals22.add(this.jRadioButtonNum);
        this.jPanelConfigWeights = new JPanel();
        this.jPanelConfigWeights.setLayout(new GridLayout(2, 1));
        this.jPanelConfigWeights.add(new JPanel());
        JPanel jPanelConfigWeights1 = new JPanel();
        this.jPanelConfigWeights.add(jPanelConfigWeights1);
        jPanelConfigWeights1.add(new JLabel("Payment %"));
        this.paymentWeight = new JTextField("43");
        this.paymentWeight.setPreferredSize(new Dimension(28, (int)this.paymentWeight.getPreferredSize().getHeight()));
        jPanelConfigWeights1.add(this.paymentWeight);
        jPanelConfigWeights1.add(new JLabel("       Order-Status %"));
        this.orderStatusWeight = new JTextField("4");
        this.orderStatusWeight.setPreferredSize(new Dimension(28, (int)this.orderStatusWeight.getPreferredSize().getHeight()));
        jPanelConfigWeights1.add(this.orderStatusWeight);
        jPanelConfigWeights1.add(new JLabel("       Delivery %"));
        this.deliveryWeight = new JTextField("4");
        this.deliveryWeight.setPreferredSize(new Dimension(28, (int)this.deliveryWeight.getPreferredSize().getHeight()));
        jPanelConfigWeights1.add(this.deliveryWeight);
        jPanelConfigWeights1.add(new JLabel("       Stock-Level %"));
        this.stockLevelWeight = new JTextField("4");
        this.stockLevelWeight.setPreferredSize(new Dimension(28, (int)this.stockLevelWeight.getPreferredSize().getHeight()));
        jPanelConfigWeights1.add(this.stockLevelWeight);
        this.jPanelConfigControls = new JPanel();
        this.jPanelConfigControls.setLayout(new GridLayout(2, 1));
        this.jPanelConfigControls.add(new JPanel());
        JPanel jPanelConfigControls1 = new JPanel();
        this.jPanelConfigControls.add(jPanelConfigControls1);
        this.jButtonCreateTerminals = new JButton("Create Terminals");
        this.jButtonCreateTerminals.setEnabled(true);
        this.jButtonCreateTerminals.addActionListener(this);
        jPanelConfigControls1.add(this.jButtonCreateTerminals);
        this.jButtonStartTransactions = new JButton("Start Transactions");
        this.jButtonStartTransactions.setEnabled(false);
        this.jButtonStartTransactions.addActionListener(this);
        jPanelConfigControls1.add(this.jButtonStartTransactions);
        this.jButtonStopTransactions = new JButton("Stop Transactions");
        this.jButtonStopTransactions.setEnabled(false);
        this.jButtonStopTransactions.addActionListener(this);
        jPanelConfigControls1.add(this.jButtonStopTransactions);
        this.setActiveConfigPanel(this.jPanelConfigDatabase, "Database");
        this.jPanelTerminalOutputs = new JPanel();
        this.jButtonPreviousTerminal = new JButton("< Previous");
        this.jButtonPreviousTerminal.addActionListener(this);
        this.jButtonNextTerminal = new JButton("Next >");
        this.jButtonNextTerminal.addActionListener(this);
        this.jPanelTerminalOutputs.setLayout(new BorderLayout());
        JPanel jPanelTerminalOutputs1 = new JPanel();
        this.jPanelTerminalOutputsLabel = new JLabel("    ");
        jPanelTerminalOutputs1.add(this.jButtonPreviousTerminal);
        jPanelTerminalOutputs1.add(this.jPanelTerminalOutputsLabel);
        jPanelTerminalOutputs1.add(this.jButtonNextTerminal);
        this.jPanelTerminalOutputs.add((Component)jPanelTerminalOutputs1, "North");
        this.jPanelOutputSwitch = new JPanel();
        this.jPanelOutputSwitch.setLayout(new BorderLayout());
        this.jPanelOutputSwitch.add(new JOutputArea());
        this.jPanelTerminalOutputs.add((Component)this.jPanelOutputSwitch, "Center");
        this.jOutputAreaErrors = new JOutputArea();
        this.jOutputAreaControl = new JOutputArea("+-------------------------------------------------------------+\n      BenchmarkSQL v2.2 (using JDBC Prepared Statements)\n+-------------------------------------------------------------+\n (c) 2003-2005, Raul Barbosa (SourceForge.Net 'jTPCC' project)\n (c) 2004-2005, Denis Lussier\n+-------------------------------------------------------------+\n\n");
        this.jPanelControl.add((Component)this.jOutputAreaControl, "Center");
        this.jLabelInformation = new JLabel("", 0);
        this.updateInformationLabel();
        this.jTabbedPane = new JTabbedPane();
        this.jTabbedPane.addTab("Control", this.imageIconDot, this.jPanelControl);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jTabbedPane, "Center");
        this.getContentPane().add((Component)this.jLabelInformation, "South");
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent e) {
        this.updateInformationLabel();
        if (e.getSource() == this.jButtonCreateTerminals) {
            this.removeAllTerminals();
            this.stopInputAreas();
            this.fastNewOrderCounter = 0L;
            try {
                String driver = this.jTextFieldDriver.getText();
                this.jOutputAreaControl.println("");
                this.printMessage("Loading database driver: '" + driver + "'...");
                Class.forName(driver);
                this.databaseDriverLoaded = true;
            }
            catch (Exception ex) {
                this.errorMessage("Unable to load the database driver!");
                this.databaseDriverLoaded = false;
                this.restartInputAreas();
            }
            if (this.databaseDriverLoaded) {
                try {
                    boolean debugMessages;
                    long executionTimeMillis;
                    int stockLevelWeightValue;
                    int deliveryWeightValue;
                    int orderStatusWeightValue;
                    int paymentWeightValue;
                    int numWarehouses;
                    int transactionsPerTerminal;
                    int numTerminals;
                    boolean limitIsTime;
                    block47: {
                        limitIsTime = this.jRadioButtonTime.isSelected();
                        numTerminals = -1;
                        transactionsPerTerminal = -1;
                        numWarehouses = -1;
                        paymentWeightValue = -1;
                        orderStatusWeightValue = -1;
                        deliveryWeightValue = -1;
                        stockLevelWeightValue = -1;
                        executionTimeMillis = -1L;
                        this.jOutputAreaControl.println("");
                        try {
                            numWarehouses = Integer.parseInt(this.jTextFieldNumWarehouses.getText());
                            if (numWarehouses <= 0) {
                                throw new NumberFormatException();
                            }
                        }
                        catch (NumberFormatException e1) {
                            this.errorMessage("Invalid number of warehouses!");
                            throw new Exception();
                        }
                        try {
                            numTerminals = Integer.parseInt(this.jTextFieldNumTerminals.getText());
                            if (numTerminals <= 0) throw new NumberFormatException();
                            if (numTerminals > 10 * numWarehouses) {
                                throw new NumberFormatException();
                            }
                        }
                        catch (NumberFormatException e1) {
                            this.errorMessage("Invalid number of terminals!");
                            throw new Exception();
                        }
                        boolean bl = debugMessages = this.jCheckBoxDebugMessages.getSelectedObjects() != null;
                        if (limitIsTime) {
                            try {
                                executionTimeMillis = Long.parseLong(this.jTextFieldMinutes.getText()) * 60000L;
                                if (executionTimeMillis <= 0L) {
                                    throw new NumberFormatException();
                                }
                                break block47;
                            }
                            catch (NumberFormatException e1) {
                                this.errorMessage("Invalid number of minutes!");
                                throw new Exception();
                            }
                        }
                        try {
                            transactionsPerTerminal = Integer.parseInt(this.jTextFieldTransactionsPerTerminal.getText());
                            if (transactionsPerTerminal <= 0) {
                                throw new NumberFormatException();
                            }
                        }
                        catch (NumberFormatException e1) {
                            this.errorMessage("Invalid number of transactions per terminal!");
                            throw new Exception();
                        }
                    }
                    try {
                        paymentWeightValue = Integer.parseInt(this.paymentWeight.getText());
                        orderStatusWeightValue = Integer.parseInt(this.orderStatusWeight.getText());
                        deliveryWeightValue = Integer.parseInt(this.deliveryWeight.getText());
                        stockLevelWeightValue = Integer.parseInt(this.stockLevelWeight.getText());
                        if (paymentWeightValue < 0) throw new NumberFormatException();
                        if (orderStatusWeightValue < 0) throw new NumberFormatException();
                        if (deliveryWeightValue < 0) throw new NumberFormatException();
                        if (stockLevelWeightValue < 0) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException e1) {
                        this.errorMessage("Invalid number in mix percentage!");
                        throw new Exception();
                    }
                    if (paymentWeightValue + orderStatusWeightValue + deliveryWeightValue + stockLevelWeightValue > 100) {
                        this.errorMessage("Sum of mix percentage parameters exceeds 100%!");
                        throw new Exception();
                    }
                    this.newOrderCounter = 0L;
                    this.printMessage("Session #" + ++this.sessionCount + " started!");
                    if (!limitIsTime) {
                        this.printMessage("Creating " + numTerminals + " terminal(s) with " + transactionsPerTerminal + " transaction(s) per terminal...");
                    } else {
                        this.printMessage("Creating " + numTerminals + " terminal(s) with " + executionTimeMillis / 60000L + " minute(s) of execution...");
                    }
                    this.printMessage("Transaction Weights: " + (100 - (paymentWeightValue + orderStatusWeightValue + deliveryWeightValue + stockLevelWeightValue)) + "% New-Order, " + paymentWeightValue + "% Payment, " + orderStatusWeightValue + "% Order-Status, " + deliveryWeightValue + "% Delivery, " + stockLevelWeightValue + "% Stock-Level");
                    String reportFileName = "reports/BenchmarkSQL_session_" + this.getFileNameSuffix() + ".txt";
                    this.fileOutputStream = new FileOutputStream(reportFileName);
                    this.printStreamReport = new PrintStream(this.fileOutputStream);
                    this.printStreamReport.println("Number of Terminals\t" + numTerminals);
                    this.printStreamReport.println("\nTerminal\tHome Warehouse");
                    this.printMessage("A complete report of the transactions will be saved to the file '" + reportFileName + "'");
                    this.terminals = new jTPCCTerminal[numTerminals];
                    this.terminalOutputAreas = new JOutputArea[numTerminals];
                    this.terminalNames = new String[numTerminals];
                    this.terminalsStarted = numTerminals;
                    try {
                        int i;
                        String database = this.jTextFieldDatabase.getText();
                        String username = this.jTextFieldUsername.getText();
                        String password = this.jTextFieldPassword.getText();
                        int[][] usedTerminals = new int[numWarehouses][10];
                        for (i = 0; i < numWarehouses; ++i) {
                            for (int j = 0; j < 10; ++j) {
                                usedTerminals[i][j] = 0;
                            }
                        }
                        this.jOutputAreaErrors.clear();
                        this.jTabbedPane.addTab("Errors", this.imageIconDot, this.jOutputAreaErrors);
                        for (i = 0; i < numTerminals; ++i) {
                            jTPCCTerminal terminal;
                            int terminalDistrictID;
                            int terminalWarehouseID;
                            while (usedTerminals[(terminalWarehouseID = (int)this.randomNumber(1L, numWarehouses)) - 1][(terminalDistrictID = (int)this.randomNumber(1L, 10L)) - 1] == 1) {
                            }
                            usedTerminals[terminalWarehouseID - 1][terminalDistrictID - 1] = 1;
                            String terminalName = "Term-" + (i >= 9 ? "" + (i + 1) : "0" + (i + 1));
                            Connection conn = null;
                            this.printMessage("Creating database connection for " + terminalName + "...");
                            conn = DriverManager.getConnection(database, username, password);
                            conn.setAutoCommit(false);
                            JOutputArea terminalOutputArea = new JOutputArea();
                            long maxChars = 150000 / numTerminals;
                            if (maxChars > 20000L) {
                                maxChars = 20000L;
                            }
                            if (maxChars < 2000L) {
                                maxChars = 2000L;
                            }
                            terminalOutputArea.setMaxChars(maxChars);
                            this.terminals[i] = terminal = new jTPCCTerminal(terminalName, terminalWarehouseID, terminalDistrictID, conn, transactionsPerTerminal, terminalOutputArea, this.jOutputAreaErrors, debugMessages, paymentWeightValue, orderStatusWeightValue, deliveryWeightValue, stockLevelWeightValue, numWarehouses, this);
                            this.terminalOutputAreas[i] = terminalOutputArea;
                            this.terminalNames[i] = terminalName;
                            this.printStreamReport.println(terminalName + "\t" + terminalWarehouseID);
                        }
                        this.setActiveTerminalOutput(0);
                        this.jTabbedPane.addTab("Terminals", this.imageIconDot, this.jPanelTerminalOutputs);
                        this.sessionEndTargetTime = executionTimeMillis;
                        this.signalTerminalsRequestEndSent = false;
                        this.printStreamReport.println("\nTransaction\tWeight\n% New-Order\t" + (100 - (paymentWeightValue + orderStatusWeightValue + deliveryWeightValue + stockLevelWeightValue)) + "\n% Payment\t" + paymentWeightValue + "\n% Order-Status\t" + orderStatusWeightValue + "\n% Delivery\t" + deliveryWeightValue + "\n% Stock-Level\t" + stockLevelWeightValue);
                        this.printStreamReport.println("\n\nTransaction Number\tTerminal\tType\tExecution Time (ms)\t\tComment");
                        this.printMessage("Created " + numTerminals + " terminal(s) successfully!");
                    }
                    catch (Exception e1) {
                        try {
                            this.printStreamReport.println("\nThis session ended with errors!");
                            this.printStreamReport.close();
                            this.fileOutputStream.close();
                        }
                        catch (IOException e2) {
                            this.errorMessage("An error occurred writing the report!");
                        }
                        this.errorMessage("An error occurred!");
                        StringWriter stringWriter = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(stringWriter);
                        e1.printStackTrace(printWriter);
                        printWriter.close();
                        this.jOutputAreaControl.println(stringWriter.toString());
                        throw new Exception();
                    }
                    this.jButtonStartTransactions.setEnabled(true);
                }
                catch (Exception ex) {
                    this.restartInputAreas();
                }
            }
        }
        if (e.getSource() == this.jButtonStartTransactions) {
            this.jButtonStartTransactions.setEnabled(false);
            this.sessionStart = this.getCurrentTime();
            this.sessionStartTimestamp = System.currentTimeMillis();
            if (this.sessionEndTargetTime != -1L) {
                this.sessionEndTargetTime += this.sessionStartTimestamp;
            }
            jTPCCTerminal[] jTPCCTerminalArray = this.terminals;
            // MONITORENTER : this.terminals
            this.printMessage("Starting all terminals...");
            this.transactionCount = 1L;
            for (int i = 0; i < this.terminals.length; ++i) {
                new Thread(this.terminals[i]).start();
            }
            // MONITOREXIT : jTPCCTerminalArray
            this.printMessage("All terminals started executing " + this.sessionStart);
            this.jButtonStopTransactions.setEnabled(true);
        }
        if (e.getSource() == this.jButtonStopTransactions) {
            this.signalTerminalsRequestEnd(false);
        }
        if (e.getSource() == this.jButtonSelectDatabase) {
            this.setActiveConfigPanel(this.jPanelConfigDatabase, "Database");
        }
        if (e.getSource() == this.jButtonSelectTerminals) {
            this.setActiveConfigPanel(this.jPanelConfigTerminals, "Terminals");
        }
        if (e.getSource() == this.jButtonSelectControls) {
            this.setActiveConfigPanel(this.jPanelConfigControls, "Controls");
        }
        if (e.getSource() == this.jButtonSelectWeights) {
            this.setActiveConfigPanel(this.jPanelConfigWeights, "Transaction Weights");
        }
        if (e.getSource() == this.jButtonNextTerminal) {
            this.setNextActiveTerminal();
        }
        if (e.getSource() == this.jButtonPreviousTerminal) {
            this.setPreviousActiveTerminal();
        }
        this.updateInformationLabel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalTerminalsRequestEnd(boolean timeTriggered) {
        this.jButtonStopTransactions.setEnabled(false);
        jTPCCTerminal[] jTPCCTerminalArray = this.terminals;
        synchronized (this.terminals) {
            if (!this.signalTerminalsRequestEndSent) {
                if (timeTriggered) {
                    this.printMessage("The time limit has been reached.");
                }
                this.printMessage("Signalling all terminals to stop...");
                this.signalTerminalsRequestEndSent = true;
                for (int i = 0; i < this.terminals.length; ++i) {
                    if (this.terminals[i] == null) continue;
                    this.terminals[i].stopRunningWhenPossible();
                }
                this.printMessage("Waiting for all active transactions to end...");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalTerminalEnded(jTPCCTerminal terminal, long countNewOrdersExecuted) {
        jTPCCTerminal[] jTPCCTerminalArray = this.terminals;
        synchronized (this.terminals) {
            boolean found = false;
            --this.terminalsStarted;
            for (int i = 0; i < this.terminals.length && !found; ++i) {
                if (this.terminals[i] != terminal) continue;
                this.terminals[i] = null;
                this.terminalNames[i] = "(" + this.terminalNames[i] + ")";
                if (i == this.currentlyDisplayedTerminal) {
                    this.jPanelTerminalOutputsLabel.setText("   " + this.terminalNames[i] + "   ");
                    this.jPanelTerminalOutputsLabel.repaint();
                }
                this.newOrderCounter += countNewOrdersExecuted;
                found = true;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (this.terminalsStarted == 0L) {
                this.jButtonStopTransactions.setEnabled(false);
                this.sessionEnd = this.getCurrentTime();
                this.sessionEndTimestamp = System.currentTimeMillis();
                this.sessionEndTargetTime = -1L;
                this.printMessage("All terminals finished executing " + this.sessionEnd);
                this.endReport();
                this.terminalsBlockingExit = false;
                if (this.jOutputAreaErrors.getText().length() != 0) {
                    this.jTabbedPane.setTitleAt(1, "** ERRORS **");
                    this.printMessage("There were errors on this session!");
                }
                this.printMessage("Session #" + this.sessionCount + " finished!");
                this.restartInputAreas();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalTerminalEndedTransaction(String terminalName, String transactionType, long executionTime, String comment, int newOrder) {
        if (comment == null) {
            comment = "None";
        }
        try {
            PrintStream printStream = this.printStreamReport;
            synchronized (printStream) {
                this.printStreamReport.println("" + this.transactionCount + "\t" + terminalName + "\t" + transactionType + "\t" + executionTime + "\t\t" + comment);
                ++this.transactionCount;
                this.fastNewOrderCounter += (long)newOrder;
            }
        }
        catch (Exception e) {
            this.errorMessage("An error occurred writing the report!");
        }
        if (this.sessionEndTargetTime != -1L && System.currentTimeMillis() > this.sessionEndTargetTime) {
            this.signalTerminalsRequestEnd(true);
        }
        this.updateInformationLabel();
    }

    private void endReport() {
        try {
            this.printStreamReport.println("\n\nMeasured tpmC\t=60000*" + this.newOrderCounter + "/" + (this.sessionEndTimestamp - this.sessionStartTimestamp));
            this.printStreamReport.println("\nSession Start\t" + this.sessionStart + "\nSession End\t" + this.sessionEnd);
            this.printStreamReport.println("Transaction Count\t" + (this.transactionCount - 1L));
            this.printStreamReport.close();
            this.fileOutputStream.close();
        }
        catch (IOException e) {
            this.errorMessage("An error occurred writing the report!");
        }
    }

    private void setActiveConfigPanel(JPanel panel, String title) {
        this.jPanelControl.invalidate();
        this.jPanelConfigSwitch.invalidate();
        this.jPanelConfigSwitch.removeAll();
        this.jPanelConfigSwitch.add(panel);
        ((TitledBorder)this.jPanelConfigSwitch.getBorder()).setTitle(" " + title + " ");
        this.jPanelControl.validate();
        this.jPanelConfigSwitch.validate();
        this.jPanelControl.repaint();
        this.jPanelConfigSwitch.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setActiveTerminalOutput(int terminalNumber) {
        if (this.terminals == null) return;
        jTPCCTerminal[] jTPCCTerminalArray = this.terminals;
        synchronized (this.terminals) {
            this.jPanelTerminalOutputs.invalidate();
            this.jPanelOutputSwitch.invalidate();
            this.jPanelOutputSwitch.removeAll();
            this.jPanelTerminalOutputsLabel.setText("   " + this.terminalNames[terminalNumber] + "   ");
            this.jPanelTerminalOutputsLabel.repaint();
            this.currentlyDisplayedTerminal = terminalNumber;
            this.jPanelOutputSwitch.add((Component)this.terminalOutputAreas[terminalNumber], "Center");
            this.jPanelTerminalOutputs.validate();
            this.jPanelOutputSwitch.validate();
            this.jPanelTerminalOutputs.repaint();
            this.jPanelOutputSwitch.repaint();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void setNextActiveTerminal() {
        int next = this.currentlyDisplayedTerminal + 1;
        if (next >= this.terminals.length) {
            next = 0;
        }
        this.setActiveTerminalOutput(next);
    }

    private void setPreviousActiveTerminal() {
        int previous = this.currentlyDisplayedTerminal - 1;
        if (previous < 0) {
            previous = this.terminals.length - 1;
        }
        this.setActiveTerminalOutput(previous);
    }

    private void printMessage(String message) {
        this.jOutputAreaControl.println("[BenchmarkSQL] " + message);
    }

    private void errorMessage(String message) {
        this.jOutputAreaControl.println("[ERROR] " + message);
    }

    private void exit() {
        if (!this.terminalsBlockingExit) {
            System.exit(0);
        } else {
            this.printMessage("Disable all terminals before quitting!");
        }
    }

    private void removeAllTerminals() {
        this.jTabbedPane.removeAll();
        this.jTabbedPane.addTab("Control", this.imageIconDot, this.jPanelControl);
        this.terminals = null;
        System.gc();
    }

    private void stopInputAreas() {
        this.terminalsBlockingExit = true;
        this.jButtonCreateTerminals.setEnabled(false);
        this.jTextFieldTransactionsPerTerminal.setEnabled(false);
        this.jTextFieldMinutes.setEnabled(false);
        this.jRadioButtonTime.setEnabled(false);
        this.jRadioButtonNum.setEnabled(false);
        this.jTextFieldNumTerminals.setEnabled(false);
        this.jTextFieldNumWarehouses.setEnabled(false);
        this.jCheckBoxDebugMessages.setEnabled(false);
        this.jTextFieldDatabase.setEnabled(false);
        this.jTextFieldUsername.setEnabled(false);
        this.jTextFieldPassword.setEnabled(false);
        this.jTextFieldDriver.setEnabled(false);
        this.paymentWeight.setEnabled(false);
        this.orderStatusWeight.setEnabled(false);
        this.deliveryWeight.setEnabled(false);
        this.stockLevelWeight.setEnabled(false);
        this.repaint();
    }

    private void restartInputAreas() {
        this.terminalsBlockingExit = false;
        this.jButtonCreateTerminals.setEnabled(true);
        this.jTextFieldTransactionsPerTerminal.setEnabled(true);
        this.jTextFieldMinutes.setEnabled(true);
        this.jRadioButtonTime.setEnabled(true);
        this.jRadioButtonNum.setEnabled(true);
        this.jTextFieldNumTerminals.setEnabled(true);
        this.jTextFieldNumWarehouses.setEnabled(true);
        this.jCheckBoxDebugMessages.setEnabled(true);
        this.jTextFieldDatabase.setEnabled(true);
        this.jTextFieldUsername.setEnabled(true);
        this.jTextFieldPassword.setEnabled(true);
        this.jTextFieldDriver.setEnabled(true);
        this.jButtonStopTransactions.setEnabled(false);
        this.paymentWeight.setEnabled(true);
        this.orderStatusWeight.setEnabled(true);
        this.deliveryWeight.setEnabled(true);
        this.stockLevelWeight.setEnabled(true);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInformationLabel() {
        String informativeText = "";
        if (this.fastNewOrderCounter != 0L) {
            double tpmC = (double)(6000000L * this.fastNewOrderCounter / (System.currentTimeMillis() - this.sessionStartTimestamp)) / 100.0;
            informativeText = "Measured tpmC: " + tpmC + "           ";
        }
        long freeMem = Runtime.getRuntime().freeMemory() / 0x100000L;
        long totalMem = Runtime.getRuntime().totalMemory() / 0x100000L;
        informativeText = informativeText + "Memory Usage: " + (totalMem - freeMem) + "MB / " + totalMem + "MB";
        JLabel jLabel = this.jLabelInformation;
        synchronized (jLabel) {
            this.jLabelInformation.setText(informativeText);
            this.jLabelInformation.repaint();
        }
    }

    private long randomNumber(long min, long max) {
        return (long)(this.random.nextDouble() * (double)(max - min + 1L) + (double)min);
    }

    private String getCurrentTime() {
        return dateFormat.format(new Date());
    }

    private String getFileNameSuffix() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return dateFormat.format(new Date());
    }

    public void windowClosing(WindowEvent e) {
        this.exit();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

