/*
 * Decompiled with CFR 0.152.
 */
package com.edb.core.v3;

import com.edb.Driver;
import com.edb.core.Field;
import com.edb.core.Notification;
import com.edb.core.PGBindException;
import com.edb.core.PGStream;
import com.edb.core.ParameterList;
import com.edb.core.Query;
import com.edb.core.QueryExecutor;
import com.edb.core.ResultCursor;
import com.edb.core.ResultHandler;
import com.edb.core.Utils;
import com.edb.core.v3.CompositeQuery;
import com.edb.core.v3.Portal;
import com.edb.core.v3.ProtocolConnectionImpl;
import com.edb.core.v3.SimpleParameterList;
import com.edb.core.v3.SimpleQuery;
import com.edb.core.v3.V3ParameterList;
import com.edb.core.v3.V3Query;
import com.edb.util.GT;
import com.edb.util.PSQLException;
import com.edb.util.PSQLState;
import com.edb.util.PSQLWarning;
import com.edb.util.ServerErrorMessage;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

public class QueryExecutorImpl
implements QueryExecutor {
    private SimpleParameterList parameters = null;
    private boolean isError = false;
    private int DIRECTION_SIZE = 2;
    private boolean isCallable = false;
    private static final int MAX_BUFFERED_QUERIES = 256;
    private final HashMap parsedQueryMap = new HashMap();
    private final ReferenceQueue parsedQueryCleanupQueue = new ReferenceQueue();
    private final HashMap openPortalMap = new HashMap();
    private final ReferenceQueue openPortalCleanupQueue = new ReferenceQueue();
    private Query currentQuery = null;
    private final ArrayList pendingParseQueue = new ArrayList();
    private final ArrayList pendingBindQueue = new ArrayList();
    private final ArrayList pendingExecuteQueue = new ArrayList();
    private long nextUniqueID = 1L;
    private final ProtocolConnectionImpl protoConnection;
    private final PGStream pgStream;
    private final boolean allowEncodingChanges;
    private final SimpleQuery beginTransactionQuery = new SimpleQuery(new String[]{"BEGIN"});
    private static final SimpleQuery EMPTY_QUERY = new SimpleQuery(new String[]{""});
    private boolean isEdbServer = false;
    private boolean isFunction = false;

    public QueryExecutorImpl(ProtocolConnectionImpl protoConnection, PGStream pgStream, Properties info) {
        this.protoConnection = protoConnection;
        this.pgStream = pgStream;
        this.allowEncodingChanges = info.getProperty("allowEncodingChanges") != null ? Boolean.valueOf(info.getProperty("allowEncodingChanges")) : false;
    }

    public Query createSimpleQuery(String sql) {
        return QueryExecutorImpl.parseQuery(sql, false);
    }

    public Query createParameterizedQuery(String sql) {
        return QueryExecutorImpl.parseQuery(sql, true);
    }

    private static Query parseQuery(String query, boolean withParameters) {
        ArrayList<String[]> statementList = new ArrayList<String[]>();
        ArrayList<String> fragmentList = new ArrayList<String>();
        boolean inQuotes = false;
        int fragmentStart = 0;
        boolean inSingleQuotes = false;
        boolean inDoubleQuotes = false;
        block7: for (int i = 0; i < query.length(); ++i) {
            char c = query.charAt(i);
            switch (c) {
                case '\\': {
                    if (!inSingleQuotes) continue block7;
                    ++i;
                    continue block7;
                }
                case '\'': {
                    inSingleQuotes = !inDoubleQuotes && !inSingleQuotes;
                    continue block7;
                }
                case '\"': {
                    inDoubleQuotes = !inSingleQuotes && !inDoubleQuotes;
                    continue block7;
                }
                case '?': {
                    if (!withParameters || inSingleQuotes || inDoubleQuotes) continue block7;
                    fragmentList.add(query.substring(fragmentStart, i));
                    fragmentStart = i + 1;
                    continue block7;
                }
                case ';': {
                    if (inSingleQuotes || inDoubleQuotes) continue block7;
                    fragmentList.add(query.substring(fragmentStart, i));
                    fragmentStart = i + 1;
                    if (fragmentList.size() > 1 || ((String)fragmentList.get(0)).trim().length() > 0) {
                        statementList.add(fragmentList.toArray(new String[fragmentList.size()]));
                    }
                    fragmentList.clear();
                    continue block7;
                }
            }
        }
        fragmentList.add(query.substring(fragmentStart));
        if (fragmentList.size() > 1 || ((String)fragmentList.get(0)).trim().length() > 0) {
            statementList.add(fragmentList.toArray(new String[fragmentList.size()]));
        }
        if (statementList.isEmpty()) {
            return EMPTY_QUERY;
        }
        if (statementList.size() == 1) {
            return new SimpleQuery((String[])statementList.get(0));
        }
        SimpleQuery[] subqueries = new SimpleQuery[statementList.size()];
        int[] offsets = new int[statementList.size()];
        int offset = 0;
        for (int i = 0; i < statementList.size(); ++i) {
            String[] fragments = (String[])statementList.get(i);
            offsets[i] = offset;
            subqueries[i] = new SimpleQuery(fragments);
            offset += fragments.length - 1;
        }
        return new CompositeQuery(subqueries, offsets);
    }

    public synchronized void execute(Query query, ParameterList parameters, ResultHandler handler, int maxRows, int fetchSize, int flags) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("simple execute , handler=" + handler + ", maxRows=" + maxRows + ", fetchSize=" + fetchSize + ", flags=" + flags);
        }
        if (parameters == null) {
            parameters = SimpleQuery.NO_PARAMETERS;
        }
        ((V3ParameterList)parameters).checkAllParametersSet();
        try {
            try {
                handler = this.sendQueryPreamble(handler, flags);
                this.sendQuery((V3Query)query, (V3ParameterList)parameters, maxRows, fetchSize, flags);
                this.sendSync();
                this.processResults(handler, flags);
            }
            catch (PGBindException se) {
                this.sendSync();
                this.processResults(handler, flags);
                handler.handleError(new PSQLException(GT.tr("Unable to bind parameter values for statement."), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)se.getIOException()));
            }
        }
        catch (IOException e) {
            this.protoConnection.close();
            handler.handleError(new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)e));
        }
        handler.handleCompletion();
    }

    public synchronized void execute(Query query, ParameterList parameters, ResultHandler handler, int maxRows, int fetchSize, int flags, boolean isCallable) throws SQLException {
        this.isCallable = isCallable;
        this.parameters = (SimpleParameterList)parameters;
        if (parameters != null) {
            ((SimpleParameterList)parameters).setIsCallable(isCallable);
        }
        if (Driver.logDebug) {
            Driver.debug("simple execute " + (isCallable ? "(Callable)" : "") + ", handler=" + handler + ", maxRows=" + maxRows + ", fetchSize=" + fetchSize + ", flags=" + flags);
        }
        if (parameters == null) {
            parameters = SimpleQuery.NO_PARAMETERS;
        }
        ((V3ParameterList)parameters).checkAllParametersSet();
        try {
            try {
                handler = this.sendQueryPreamble(handler, flags);
                this.sendQuery((V3Query)query, (V3ParameterList)parameters, maxRows, fetchSize, flags);
                this.sendSync();
                this.processResults(handler, flags);
            }
            catch (PGBindException se) {
                this.sendSync();
                this.processResults(handler, flags);
                handler.handleError(new PSQLException(GT.tr("Unable to bind parameter values for statement."), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)se.getIOException()));
            }
        }
        catch (IOException e) {
            this.protoConnection.close();
            handler.handleError(new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)e));
        }
        handler.handleCompletion();
    }

    public synchronized void execute(Query[] queries, ParameterList[] parameterLists, ResultHandler handler, int maxRows, int fetchSize, int flags) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("batch execute " + queries.length + " queries, handler=" + handler + ", maxRows=" + maxRows + ", fetchSize=" + fetchSize + ", flags=" + flags);
        }
        for (int i = 0; i < parameterLists.length; ++i) {
            if (parameterLists[i] == null) continue;
            ((V3ParameterList)parameterLists[i]).checkAllParametersSet();
        }
        try {
            int queryCount = 0;
            handler = this.sendQueryPreamble(handler, flags);
            ErrorTrackingResultHandler trackingHandler = new ErrorTrackingResultHandler(handler);
            for (int i = 0; i < queries.length; ++i) {
                if (++queryCount >= 256) {
                    this.sendSync();
                    this.processResults(trackingHandler, flags);
                    if (trackingHandler.hasErrors()) break;
                    queryCount = 0;
                }
                V3Query query = (V3Query)queries[i];
                V3ParameterList parameters = (V3ParameterList)parameterLists[i];
                if (parameters == null) {
                    parameters = SimpleQuery.NO_PARAMETERS;
                }
                this.sendQuery(query, parameters, maxRows, fetchSize, flags);
            }
            if (!trackingHandler.hasErrors()) {
                this.sendSync();
                this.processResults(handler, flags);
            }
        }
        catch (IOException e) {
            this.protoConnection.close();
            handler.handleError(new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)e));
        }
        handler.handleCompletion();
    }

    private ResultHandler sendQueryPreamble(final ResultHandler delegateHandler, int flags) throws IOException, SQLException {
        this.processDeadParsedQueries();
        this.processDeadPortals();
        if ((flags & 0x10) != 0 || this.protoConnection.getTransactionState() != 0) {
            return delegateHandler;
        }
        this.sendOneQuery(this.beginTransactionQuery, SimpleQuery.NO_PARAMETERS, 0, 0, 2);
        return new ResultHandler(){
            private boolean sawBegin = false;

            public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
                if (this.sawBegin) {
                    delegateHandler.handleResultRows(fromQuery, fields, tuples, cursor);
                }
            }

            public void handleCommandStatus(String status, int updateCount, long insertOID) {
                if (!this.sawBegin) {
                    this.sawBegin = true;
                    if (!status.equals("BEGIN")) {
                        this.handleError(new SQLException(GT.tr("Expected command status BEGIN, got {0}.", status)));
                    }
                } else {
                    delegateHandler.handleCommandStatus(status, updateCount, insertOID);
                }
            }

            public void handleWarning(SQLWarning warning) {
                delegateHandler.handleWarning(warning);
            }

            public void handleError(SQLException error) {
                delegateHandler.handleError(error);
            }

            public void handleCompletion() throws SQLException {
                delegateHandler.handleCompletion();
            }
        };
    }

    public synchronized byte[] fastpathCall(int fnid, ParameterList parameters, boolean suppressBegin) throws SQLException {
        if (this.protoConnection.getTransactionState() == 0 && !suppressBegin) {
            if (Driver.logDebug) {
                Driver.debug("Issuing BEGIN before fastpath call.");
            }
            ResultHandler handler = new ResultHandler(){
                private boolean sawBegin = false;
                private SQLException sqle = null;

                public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
                }

                public void handleCommandStatus(String status, int updateCount, long insertOID) {
                    if (!this.sawBegin) {
                        if (!status.equals("BEGIN")) {
                            this.handleError(new SQLException(GT.tr("Expected command status BEGIN, got {0}.", status)));
                        }
                        this.sawBegin = true;
                    } else {
                        this.handleError(new SQLException(GT.tr("Unexpected command status: {0}.", status)));
                    }
                }

                public void handleWarning(SQLWarning warning) {
                    this.handleError(warning);
                }

                public void handleError(SQLException error) {
                    if (this.sqle == null) {
                        this.sqle = error;
                    } else {
                        this.sqle.setNextException(error);
                    }
                }

                public void handleCompletion() throws SQLException {
                    if (this.sqle != null) {
                        throw this.sqle;
                    }
                }
            };
            try {
                this.sendOneQuery(this.beginTransactionQuery, SimpleQuery.NO_PARAMETERS, 0, 0, 2);
                this.sendSync();
                this.processResults(handler, 0);
            }
            catch (IOException ioe) {
                throw new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
            }
        }
        try {
            this.sendFastpathCall(fnid, (SimpleParameterList)parameters);
            return this.receiveFastpathResult();
        }
        catch (IOException ioe) {
            this.protoConnection.close();
            throw new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    public ParameterList createFastpathParameters(int count) {
        return new SimpleParameterList(count);
    }

    private void sendFastpathCall(int fnid, SimpleParameterList params) throws SQLException, IOException {
        int i;
        if (Driver.logDebug) {
            Driver.debug(" FE=> FunctionCall(" + fnid + ", " + params.getParameterCount() + " params)");
        }
        int paramCount = params.getParameterCount();
        int encodedSize = 0;
        for (i = 1; i <= paramCount; ++i) {
            if (params.isNull(i)) {
                encodedSize += 4;
                continue;
            }
            encodedSize += 4 + params.getV3Length(i);
        }
        this.pgStream.SendChar(70);
        this.pgStream.SendInteger4(10 + 2 * paramCount + 2 + encodedSize + 2);
        this.pgStream.SendInteger4(fnid);
        this.pgStream.SendInteger2(paramCount);
        for (i = 1; i <= paramCount; ++i) {
            this.pgStream.SendInteger2(params.isBinary(i) ? 1 : 0);
        }
        this.pgStream.SendInteger2(paramCount);
        for (i = 1; i <= paramCount; ++i) {
            if (params.isNull(i)) {
                this.pgStream.SendInteger4(-1);
                continue;
            }
            this.pgStream.SendInteger4(params.getV3Length(i));
            params.writeV3Value(i, this.pgStream);
        }
        this.pgStream.SendInteger2(1);
        this.pgStream.flush();
    }

    private byte[] receiveFastpathResult() throws IOException, SQLException {
        boolean endQuery = false;
        SQLException error = null;
        byte[] returnValue = null;
        block7: while (!endQuery) {
            int c = this.pgStream.ReceiveChar();
            switch (c) {
                case 65: {
                    this.receiveAsyncNotify();
                    continue block7;
                }
                case 69: {
                    SQLException newError = this.receiveErrorResponse();
                    if (error == null) {
                        error = newError;
                        continue block7;
                    }
                    error.setNextException(newError);
                    continue block7;
                }
                case 78: {
                    SQLWarning warning = this.receiveNoticeResponse();
                    this.protoConnection.addWarning(warning);
                    continue block7;
                }
                case 90: {
                    this.receiveRFQ();
                    endQuery = true;
                    continue block7;
                }
                case 86: {
                    int msgLen = this.pgStream.ReceiveIntegerR(4);
                    int valueLen = this.pgStream.ReceiveIntegerR(4);
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE FunctionCallResponse(" + valueLen + " bytes)");
                    }
                    if (valueLen == -1) continue block7;
                    byte[] buf = new byte[valueLen];
                    this.pgStream.Receive(buf, 0, valueLen);
                    returnValue = buf;
                    continue block7;
                }
            }
            throw new PSQLException(GT.tr("Unknown Response Type {0}.", new Character((char)c)), PSQLState.CONNECTION_FAILURE);
        }
        if (error != null) {
            throw error;
        }
        return returnValue;
    }

    private void sendQuery(V3Query query, V3ParameterList parameters, int maxRows, int fetchSize, int flags) throws IOException, SQLException {
        SimpleQuery[] subqueries = query.getSubqueries();
        SimpleParameterList[] subparams = parameters.getSubparams();
        if (subqueries == null) {
            this.sendOneQuery((SimpleQuery)query, (SimpleParameterList)parameters, maxRows, fetchSize, flags);
        } else {
            for (int i = 0; i < subqueries.length; ++i) {
                SimpleParameterList subparam = SimpleQuery.NO_PARAMETERS;
                if (subparams != null) {
                    subparam = subparams[i];
                }
                this.sendOneQuery(subqueries[i], subparam, maxRows, fetchSize, flags);
            }
        }
    }

    private void sendSync() throws IOException {
        if (Driver.logDebug) {
            Driver.debug(" FE=> Sync");
        }
        this.pgStream.SendChar(83);
        this.pgStream.SendInteger4(4);
        this.pgStream.flush();
    }

    private void sendParse(SimpleQuery query, SimpleParameterList params, boolean oneShot) throws IOException, SQLException {
        int i;
        params.fillNulls();
        if (this.isCallable && this.isEdbServer) {
            this.sendParseOut(query, params, oneShot);
            return;
        }
        int[] typeOIDs = params.getTypeOIDs();
        if (query.isPreparedFor(typeOIDs)) {
            return;
        }
        query.unprepare();
        if (query.getStatementName() != null) {
            return;
        }
        String statementName = null;
        if (!oneShot) {
            statementName = "S_" + this.nextUniqueID++;
            query.setStatementName(statementName);
            query.setStatementTypes((int[])typeOIDs.clone());
        }
        byte[] encodedStatementName = query.getEncodedStatementName();
        String[] fragments = query.getFragments();
        if (Driver.logDebug) {
            int i2;
            StringBuffer sbuf = new StringBuffer(" FE=> Parse(stmt=" + statementName + ",query=\"");
            for (i2 = 0; i2 < fragments.length; ++i2) {
                if (i2 > 0) {
                    sbuf.append("$" + i2);
                }
                sbuf.append(fragments[i2]);
            }
            sbuf.append("\",oids={");
            for (i2 = 1; i2 <= params.getParameterCount(); ++i2) {
                if (i2 != 1) {
                    sbuf.append(",");
                }
                sbuf.append("" + params.getTypeOID(i2));
            }
            sbuf.append("})");
            Driver.debug(sbuf.toString());
        }
        byte[][] parts = new byte[fragments.length * 2 - 1][];
        int j = 0;
        int encodedSize = 0;
        for (i = 0; i < fragments.length; ++i) {
            if (i != 0) {
                parts[j] = Utils.encodeUTF8("$" + i);
                encodedSize += parts[j].length;
                ++j;
            }
            parts[j] = Utils.encodeUTF8(fragments[i]);
            encodedSize += parts[j].length;
            ++j;
        }
        encodedSize = 4 + (encodedStatementName == null ? 0 : encodedStatementName.length) + 1 + encodedSize + 1 + 2 + 4 * params.getParameterCount();
        this.pgStream.SendChar(80);
        this.pgStream.SendInteger4(encodedSize);
        if (encodedStatementName != null) {
            this.pgStream.Send(encodedStatementName);
        }
        this.pgStream.SendChar(0);
        for (i = 0; i < parts.length; ++i) {
            this.pgStream.Send(parts[i]);
        }
        this.pgStream.SendChar(0);
        this.pgStream.SendInteger2(params.getParameterCount());
        for (i = 1; i <= params.getParameterCount(); ++i) {
            this.pgStream.SendInteger4(params.getTypeOID(i));
        }
        this.pendingParseQueue.add(query);
    }

    private void sendParseOut(SimpleQuery query, SimpleParameterList params, boolean oneShot) throws IOException, SQLException {
        int i;
        int[] typeOIDs = params.getTypeOIDs();
        if (query.isPreparedFor(typeOIDs)) {
            return;
        }
        query.unprepare();
        if (query.getStatementName() != null) {
            return;
        }
        String statementName = null;
        if (!oneShot) {
            statementName = "S_" + this.nextUniqueID++;
            query.setStatementName(statementName);
            query.setStatementTypes((int[])typeOIDs.clone());
        }
        byte[] encodedStatementName = query.getEncodedStatementName();
        String[] fragments = query.getFragments();
        if (Driver.logDebug) {
            int i2;
            StringBuffer sbuf = new StringBuffer(" FE=> ParseOut(stmt=" + statementName + ",query=\"");
            for (i2 = 0; i2 < fragments.length; ++i2) {
                if (i2 > 0) {
                    sbuf.append("$" + i2);
                }
                sbuf.append(fragments[i2]);
            }
            sbuf.append("\",oids={");
            for (i2 = 1; i2 <= params.getParameterCount(); ++i2) {
                if (i2 != 1) {
                    sbuf.append(",");
                }
                sbuf.append("" + params.getTypeOID(i2));
            }
            sbuf.append("}\",directions={");
            for (i2 = 1; i2 <= params.getParameterCount(); ++i2) {
                if (i2 != 1) {
                    sbuf.append(",");
                }
                sbuf.append("" + params.getParamDirection(i2));
            }
            sbuf.append("})");
            Driver.debug(sbuf.toString());
        }
        byte[][] parts = new byte[fragments.length * 2 - 1][];
        int j = 0;
        int encodedSize = 0;
        for (i = 0; i < fragments.length; ++i) {
            if (i != 0) {
                parts[j] = Utils.encodeUTF8("$" + i);
                encodedSize += parts[j].length;
                ++j;
            }
            parts[j] = Utils.encodeUTF8(fragments[i]);
            encodedSize += parts[j].length;
            ++j;
        }
        encodedSize = 4 + (encodedStatementName == null ? 0 : encodedStatementName.length) + 1 + encodedSize + 1 + 2 + 4 * params.getParameterCount();
        this.pgStream.SendChar(79);
        this.pgStream.SendInteger4(encodedSize += this.DIRECTION_SIZE * params.getParameterCount());
        if (encodedStatementName != null) {
            this.pgStream.Send(encodedStatementName);
        }
        this.pgStream.SendChar(0);
        for (i = 0; i < parts.length; ++i) {
            this.pgStream.Send(parts[i]);
        }
        this.pgStream.SendChar(0);
        this.pgStream.SendInteger2(params.getParameterCount());
        for (i = 1; i <= params.getParameterCount(); ++i) {
            this.pgStream.SendInteger4(params.getTypeOID(i));
        }
        for (i = 1; i <= params.getParameterCount(); ++i) {
            this.pgStream.SendInteger2(params.getParamDirection(i));
        }
        this.pendingParseQueue.add(query);
    }

    private void sendBind(SimpleQuery query, SimpleParameterList params, Portal portal) throws IOException {
        int i;
        byte[] encodedPortalName;
        String statementName = query.getStatementName();
        byte[] encodedStatementName = query.getEncodedStatementName();
        byte[] byArray = encodedPortalName = portal == null ? null : portal.getEncodedPortalName();
        if (Driver.logDebug) {
            StringBuffer sbuf = new StringBuffer(" FE=> Bind(stmt=" + statementName + ",portal=" + portal);
            for (int i2 = 1; i2 <= params.getParameterCount(); ++i2) {
                sbuf.append(",$" + i2 + "=<" + params.toString(i2) + ">");
            }
            sbuf.append(")");
            Driver.debug(sbuf.toString());
        }
        long encodedSize = 0L;
        for (i = 1; i <= params.getParameterCount(); ++i) {
            if (params.isNull(i)) {
                encodedSize += 4L;
                continue;
            }
            encodedSize += 4L + (long)params.getV3Length(i);
        }
        encodedSize = (long)(4 + (encodedPortalName == null ? 0 : encodedPortalName.length) + 1 + (encodedStatementName == null ? 0 : encodedStatementName.length) + 1 + 2 + params.getParameterCount() * 2 + 2) + encodedSize + 2L;
        if (encodedSize > 0x3FFFFFFFL) {
            throw new PGBindException(new IOException(GT.tr("Bind message length {0} too long.  This can be caused by very large or incorrect length specifications on InputStream parameters.", new Long(encodedSize))));
        }
        this.pgStream.SendChar(66);
        this.pgStream.SendInteger4((int)encodedSize);
        if (encodedPortalName != null) {
            this.pgStream.Send(encodedPortalName);
        }
        this.pgStream.SendChar(0);
        if (encodedStatementName != null) {
            this.pgStream.Send(encodedStatementName);
        }
        this.pgStream.SendChar(0);
        this.pgStream.SendInteger2(params.getParameterCount());
        for (i = 1; i <= params.getParameterCount(); ++i) {
            this.pgStream.SendInteger2(params.isBinary(i) ? 1 : 0);
        }
        this.pgStream.SendInteger2(params.getParameterCount());
        PGBindException bindException = null;
        for (int i3 = 1; i3 <= params.getParameterCount(); ++i3) {
            if (params.isNull(i3)) {
                this.pgStream.SendInteger4(-1);
                continue;
            }
            this.pgStream.SendInteger4(params.getV3Length(i3));
            try {
                params.writeV3Value(i3, this.pgStream);
                continue;
            }
            catch (PGBindException be) {
                bindException = be;
            }
        }
        this.pgStream.SendChar(0);
        this.pgStream.SendChar(0);
        this.pendingBindQueue.add(portal);
        if (bindException != null) {
            throw bindException;
        }
    }

    private void sendDescribe(Portal portal) throws IOException {
        if (Driver.logDebug) {
            Driver.debug(" FE=> Describe(portal=" + portal + ")");
        }
        byte[] encodedPortalName = portal == null ? null : portal.getEncodedPortalName();
        int encodedSize = 5 + (encodedPortalName == null ? 0 : encodedPortalName.length) + 1;
        this.pgStream.SendChar(68);
        this.pgStream.SendInteger4(encodedSize);
        this.pgStream.SendChar(80);
        if (encodedPortalName != null) {
            this.pgStream.Send(encodedPortalName);
        }
        this.pgStream.SendChar(0);
    }

    private void sendDescribeOut(Portal portal) throws IOException {
        if (Driver.logDebug) {
            Driver.debug(" FE=> DescribeOut(portal=" + portal + ")");
        }
        byte[] encodedPortalName = portal == null ? null : portal.getEncodedPortalName();
        int encodedSize = 5 + (encodedPortalName == null ? 0 : encodedPortalName.length) + 1;
        this.pgStream.SendChar(117);
        this.pgStream.SendInteger4(encodedSize);
        this.pgStream.SendChar(80);
        if (encodedPortalName != null) {
            this.pgStream.Send(encodedPortalName);
        }
        this.pgStream.SendChar(0);
    }

    private void sendExecute(Query query, Portal portal, int limit) throws IOException {
        if (Driver.logDebug) {
            Driver.debug(" FE=> Execute(portal=" + portal + ",limit=" + limit + ")");
        }
        byte[] encodedPortalName = portal == null ? null : portal.getEncodedPortalName();
        int encodedSize = encodedPortalName == null ? 0 : encodedPortalName.length;
        this.pgStream.SendChar(69);
        this.pgStream.SendInteger4(5 + encodedSize + 4);
        if (encodedPortalName != null) {
            this.pgStream.Send(encodedPortalName);
        }
        this.pgStream.SendChar(0);
        this.pgStream.SendInteger4(limit);
        this.pendingExecuteQueue.add(new Object[]{query, portal});
    }

    private void sendExecuteOut(Query query, Portal portal) throws IOException {
        if (Driver.logDebug) {
            Driver.debug(" FE=> ExecuteOut(portal=" + portal + ")");
        }
        byte[] encodedPortalName = portal == null ? null : portal.getEncodedPortalName();
        int encodedSize = encodedPortalName == null ? 0 : encodedPortalName.length;
        this.pgStream.SendChar(118);
        this.pgStream.SendInteger4(5 + encodedSize);
        if (encodedPortalName != null) {
            this.pgStream.Send(encodedPortalName);
        }
        this.pgStream.SendChar(0);
        this.pendingExecuteQueue.add(new Object[]{query, portal});
    }

    private void sendClosePortal(String portalName) throws IOException {
        if (Driver.logDebug) {
            Driver.debug(" FE=> ClosePortal(" + portalName + ")");
        }
        byte[] encodedPortalName = portalName == null ? null : Utils.encodeUTF8(portalName);
        int encodedSize = encodedPortalName == null ? 0 : encodedPortalName.length;
        this.pgStream.SendChar(67);
        this.pgStream.SendInteger4(6 + encodedSize);
        this.pgStream.SendChar(80);
        if (encodedPortalName != null) {
            this.pgStream.Send(encodedPortalName);
        }
        this.pgStream.SendChar(0);
    }

    private void sendCloseStatement(String statementName) throws IOException {
        if (Driver.logDebug) {
            Driver.debug(" FE=> CloseStatement(" + statementName + ")");
        }
        byte[] encodedStatementName = Utils.encodeUTF8(statementName);
        this.pgStream.SendChar(67);
        this.pgStream.SendInteger4(5 + encodedStatementName.length + 1);
        this.pgStream.SendChar(83);
        this.pgStream.Send(encodedStatementName);
        this.pgStream.SendChar(0);
    }

    private void sendOneQuery(SimpleQuery query, SimpleParameterList params, int maxRows, int fetchSize, int flags) throws IOException, SQLException {
        boolean oneShot;
        boolean noResults = (flags & 4) != 0;
        boolean noMeta = (flags & 2) != 0;
        boolean usePortal = (flags & 8) != 0 && !noResults && !noMeta && fetchSize > 0;
        boolean bl = oneShot = (flags & 1) != 0 && !usePortal;
        int rows = noResults ? 1 : (!usePortal ? maxRows : (maxRows != 0 && fetchSize > maxRows ? maxRows : fetchSize));
        this.sendParse(query, params, oneShot);
        Portal portal = null;
        if (usePortal) {
            String portalName = "C_" + this.nextUniqueID++;
            portal = new Portal(query, portalName);
        }
        this.sendBind(query, params, portal);
        if (!noMeta) {
            this.sendDescribe(portal);
        }
        if (this.isCallable && this.isEdbServer) {
            this.sendDescribeOut(portal);
        }
        this.sendExecute(query, portal, rows);
        if (this.isCallable && this.isEdbServer) {
            this.sendExecuteOut(query, portal);
        }
    }

    private void registerParsedQuery(SimpleQuery query) {
        String statementName = query.getStatementName();
        if (statementName == null) {
            return;
        }
        PhantomReference<SimpleQuery> cleanupRef = new PhantomReference<SimpleQuery>(query, this.parsedQueryCleanupQueue);
        this.parsedQueryMap.put(cleanupRef, statementName);
        query.setCleanupRef(cleanupRef);
    }

    private void processDeadParsedQueries() throws IOException {
        PhantomReference deadQuery;
        while ((deadQuery = (PhantomReference)this.parsedQueryCleanupQueue.poll()) != null) {
            String statementName = (String)this.parsedQueryMap.remove(deadQuery);
            this.sendCloseStatement(statementName);
            deadQuery.clear();
        }
    }

    private void registerOpenPortal(Portal portal) {
        if (portal == null) {
            return;
        }
        String portalName = portal.getPortalName();
        PhantomReference<Portal> cleanupRef = new PhantomReference<Portal>(portal, this.openPortalCleanupQueue);
        this.openPortalMap.put(cleanupRef, portalName);
        portal.setCleanupRef(cleanupRef);
    }

    private void processDeadPortals() throws IOException {
        PhantomReference deadPortal;
        while ((deadPortal = (PhantomReference)this.openPortalCleanupQueue.poll()) != null) {
            String portalName = (String)this.openPortalMap.remove(deadPortal);
            this.sendClosePortal(portalName);
            deadPortal.clear();
        }
    }

    protected void processResults(ResultHandler handler, int flags) throws IOException {
        boolean noResults = (flags & 4) != 0;
        Field[] fields = null;
        Vector<byte[][]> tuples = null;
        Field[] paramFields = null;
        Vector<byte[][]> paramTuples = null;
        boolean endQuery = false;
        int parseIndex = 0;
        int bindIndex = 0;
        int executeIndex = 0;
        block19: while (!endQuery) {
            int c = this.pgStream.ReceiveChar();
            switch (c) {
                case 65: {
                    this.receiveAsyncNotify();
                    continue block19;
                }
                case 49: {
                    this.pgStream.ReceiveIntegerR(4);
                    SimpleQuery parsedQuery = (SimpleQuery)this.pendingParseQueue.get(parseIndex++);
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE ParseComplete [" + parsedQuery.getStatementName() + "]");
                    }
                    this.registerParsedQuery(parsedQuery);
                    continue block19;
                }
                case 50: {
                    this.pgStream.ReceiveIntegerR(4);
                    Portal boundPortal = (Portal)this.pendingBindQueue.get(bindIndex++);
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE BindComplete [" + boundPortal + "]");
                    }
                    this.registerOpenPortal(boundPortal);
                    continue block19;
                }
                case 51: {
                    this.pgStream.ReceiveIntegerR(4);
                    if (!Driver.logDebug) continue block19;
                    Driver.debug(" <=BE CloseComplete");
                    continue block19;
                }
                case 110: {
                    this.pgStream.ReceiveIntegerR(4);
                    if (!Driver.logDebug) continue block19;
                    Driver.debug(" <=BE NoData");
                    continue block19;
                }
                case 115: {
                    this.pgStream.ReceiveIntegerR(4);
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE PortalSuspended");
                    }
                    Object[] executeData = (Object[])this.pendingExecuteQueue.get(executeIndex++);
                    Query currentQuery = (Query)executeData[0];
                    Portal currentPortal = (Portal)executeData[1];
                    handler.handleResultRows(currentQuery, fields, tuples, currentPortal);
                    continue block19;
                }
                case 67: {
                    String status = this.receiveCommandStatus();
                    Object[] executeData = (Object[])this.pendingExecuteQueue.get(executeIndex++);
                    this.currentQuery = (Query)executeData[0];
                    Portal currentPortal = (Portal)executeData[1];
                    if (!(fields == null && tuples == null || this.isCallable)) {
                        handler.handleResultRows(this.currentQuery, fields, tuples, null);
                    } else if (!this.isCallable) {
                        this.interpretCommandStatus(status, handler);
                    }
                    if (currentPortal == null) continue block19;
                    currentPortal.close();
                    continue block19;
                }
                case 68: {
                    byte[][] tuple = this.pgStream.ReceiveTupleV3();
                    if (!noResults) {
                        if (tuples == null) {
                            tuples = new Vector();
                        }
                        tuples.addElement(tuple);
                    }
                    if (!Driver.logDebug) continue block19;
                    Driver.debug(" <=BE DataRow");
                    continue block19;
                }
                case 118: {
                    byte[][] tuple = this.pgStream.ReceiveTupleV3();
                    if (!noResults) {
                        if (paramTuples == null) {
                            paramTuples = new Vector();
                        }
                        paramTuples.addElement(tuple);
                    }
                    if (!Driver.logDebug) continue block19;
                    Driver.debug(" <=BE ParamData");
                    continue block19;
                }
                case 69: {
                    SQLException error = this.receiveErrorResponse();
                    this.isError = true;
                    handler.handleError(error);
                    continue block19;
                }
                case 73: {
                    this.pgStream.ReceiveIntegerR(4);
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE EmptyQuery");
                    }
                    Object[] executeData = (Object[])this.pendingExecuteQueue.get(executeIndex++);
                    Query currentQuery = (Query)executeData[0];
                    Portal currentPortal = (Portal)executeData[1];
                    handler.handleCommandStatus("EMPTY", 0, 0L);
                    if (currentPortal == null) continue block19;
                    currentPortal.close();
                    continue block19;
                }
                case 78: {
                    SQLWarning warning = this.receiveNoticeResponse();
                    handler.handleWarning(warning);
                    continue block19;
                }
                case 83: {
                    int l_len = this.pgStream.ReceiveIntegerR(4);
                    String name = this.pgStream.ReceiveString();
                    String value = this.pgStream.ReceiveString();
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE ParameterStatus(" + name + " = " + value + ")");
                    }
                    if (name.equals("client_encoding") && !value.equalsIgnoreCase("UNICODE") && !this.allowEncodingChanges) {
                        this.protoConnection.close();
                        handler.handleError(new PSQLException(GT.tr("The server's client_encoding parameter was changed to {0}. The JDBC driver requires client_encoding to be UNICODE for correct operation.", value), PSQLState.CONNECTION_FAILURE));
                        endQuery = true;
                    }
                    if (!name.equals("DateStyle") || value.startsWith("ISO,")) continue block19;
                    this.protoConnection.close();
                    handler.handleError(new PSQLException(GT.tr("The server's DateStyle parameter was changed to {0}. The JDBC driver requires DateStyle to begin with ISO for correct operation.", value), PSQLState.CONNECTION_FAILURE));
                    endQuery = true;
                    continue block19;
                }
                case 84: {
                    fields = this.receiveFields();
                    tuples = new Vector<byte[][]>();
                    continue block19;
                }
                case 117: {
                    paramFields = this.receiveFieldsWithIndex();
                    paramTuples = new Vector<byte[][]>();
                    continue block19;
                }
                case 90: {
                    this.receiveRFQ();
                    endQuery = true;
                    while (parseIndex < this.pendingParseQueue.size()) {
                        SimpleQuery failedQuery = (SimpleQuery)this.pendingParseQueue.get(parseIndex++);
                        failedQuery.unprepare();
                    }
                    this.pendingParseQueue.clear();
                    this.pendingBindQueue.clear();
                    this.pendingExecuteQueue.clear();
                    continue block19;
                }
                case 71: 
                case 72: 
                case 99: 
                case 100: {
                    int l_len = this.pgStream.ReceiveIntegerR(4);
                    this.pgStream.Receive(l_len);
                    handler.handleError(new PSQLException(GT.tr("The driver currently does not support COPY operations."), PSQLState.NOT_IMPLEMENTED));
                    continue block19;
                }
            }
            throw new IOException("Unexpected packet type: " + c);
        }
        if (this.isError) {
            return;
        }
        if (this.isEdbServer && this.isCallable) {
            int offset = 0;
            if (this.isFunction) {
                offset = 1;
                if (fields == null || tuples == null) {
                    handler.handleError(new PSQLException(GT.tr("The function did not return a value however a return value was expected"), PSQLState.NO_DATA));
                    offset = 0;
                }
            }
            if (this.isCallable && this.isEdbServer && this.parameters.getParameterCount() > 0) {
                int outCount = this.parameters.getOutCount();
                if (this.isFunction) {
                    --outCount;
                }
                if ((paramFields == null || paramTuples == null) && outCount > 0) {
                    handler.handleError(new PSQLException(GT.tr("The function did not return any OUT/INOUT value"), PSQLState.NO_DATA));
                    return;
                }
                Object tmpTuple = null;
                Field tmpField = null;
                byte[] tmpRet = null;
                if (offset > 0) {
                    tmpField = fields[0];
                    tmpTuple = (byte[][])tuples.elementAt(0);
                    tmpRet = tmpTuple[0];
                }
                fields = new Field[this.parameters.getParameterCount() + offset];
                tmpTuple = new byte[this.parameters.getParameterCount() + offset][];
                if (offset > 0) {
                    fields[0] = tmpField;
                    tmpTuple[0] = tmpRet;
                }
                Object params = new byte[][]{};
                if (paramTuples != null && paramTuples.size() > 0) {
                    params = (byte[][])paramTuples.elementAt(0);
                }
                if (paramFields != null) {
                    for (int a = 0; a < paramFields.length; ++a) {
                        Field f = paramFields[a];
                        int ret_index = f.getColumnIndex() + offset;
                        if (fields.length <= ret_index) {
                            handler.handleError(new PSQLException(GT.tr("Invalid IN/OUT return index returned"), PSQLState.NO_DATA));
                            continue;
                        }
                        fields[ret_index] = f;
                        tmpTuple[ret_index] = params[a];
                    }
                }
                if (tuples == null) {
                    tuples = new Vector();
                }
                if (tuples.size() == 0) {
                    tuples.addElement((byte[][])tmpTuple);
                } else {
                    tuples.set(0, (byte[][])tmpTuple);
                }
                if (fields != null || tuples != null) {
                    handler.handleResultRows(this.currentQuery, fields, tuples, null);
                }
            }
        }
    }

    public synchronized void fetch(ResultCursor cursor, ResultHandler handler, int fetchSize) throws SQLException {
        final Portal portal = (Portal)cursor;
        final ResultHandler delegateHandler = handler;
        handler = new ResultHandler(){

            public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
                delegateHandler.handleResultRows(fromQuery, fields, tuples, cursor);
            }

            public void handleCommandStatus(String status, int updateCount, long insertOID) {
                this.handleResultRows(portal.getQuery(), null, new Vector(), null);
            }

            public void handleWarning(SQLWarning warning) {
                delegateHandler.handleWarning(warning);
            }

            public void handleError(SQLException error) {
                delegateHandler.handleError(error);
            }

            public void handleCompletion() throws SQLException {
                delegateHandler.handleCompletion();
            }
        };
        try {
            this.processDeadParsedQueries();
            this.processDeadPortals();
            this.sendExecute(portal.getQuery(), portal, fetchSize);
            this.sendSync();
            this.processResults(handler, 0);
        }
        catch (IOException e) {
            this.protoConnection.close();
            handler.handleError(new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)e));
        }
        handler.handleCompletion();
    }

    private Field[] receiveFields() throws IOException {
        int l_msgSize = this.pgStream.ReceiveIntegerR(4);
        int size = this.pgStream.ReceiveIntegerR(2);
        Field[] fields = new Field[size];
        if (Driver.logDebug) {
            Driver.debug(" <=BE RowDescription(" + size + ")");
        }
        for (int i = 0; i < fields.length; ++i) {
            String columnLabel = this.pgStream.ReceiveString();
            int tableOid = this.pgStream.ReceiveIntegerR(4);
            short positionInTable = (short)this.pgStream.ReceiveIntegerR(2);
            int typeOid = this.pgStream.ReceiveIntegerR(4);
            int typeLength = this.pgStream.ReceiveIntegerR(2);
            int typeModifier = this.pgStream.ReceiveIntegerR(4);
            int formatType = this.pgStream.ReceiveIntegerR(2);
            fields[i] = new Field(columnLabel, null, typeOid, typeLength, typeModifier, tableOid, positionInTable);
            fields[i].setFormat(formatType);
        }
        return fields;
    }

    private Field[] receiveFieldsWithIndex() throws IOException {
        int l_msgSize = this.pgStream.ReceiveIntegerR(4);
        int size = this.pgStream.ReceiveIntegerR(2);
        Field[] fields = new Field[size];
        if (Driver.logDebug) {
            Driver.debug(" <=BE OutDescription(" + size + ")");
        }
        for (int i = 0; i < fields.length; ++i) {
            String columnLabel = this.pgStream.ReceiveString();
            int ret_index = this.pgStream.ReceiveIntegerR(2);
            int tableOid = 0;
            int positionInTable = 0;
            int typeOid = this.pgStream.ReceiveIntegerR(4);
            int typeLength = this.pgStream.ReceiveIntegerR(2);
            int typeModifier = this.pgStream.ReceiveIntegerR(4);
            int formatType = this.pgStream.ReceiveIntegerR(2);
            fields[i] = new Field(columnLabel, null, typeOid, typeLength, typeModifier, tableOid, positionInTable);
            fields[i].setFormat(formatType);
            fields[i].setColumnIndex(ret_index);
        }
        return fields;
    }

    private void receiveAsyncNotify() throws IOException {
        int msglen = this.pgStream.ReceiveIntegerR(4);
        int pid = this.pgStream.ReceiveIntegerR(4);
        String msg = this.pgStream.ReceiveString();
        String param = this.pgStream.ReceiveString();
        this.protoConnection.addNotification(new Notification(msg, pid, param));
        if (Driver.logDebug) {
            Driver.debug(" <=BE AsyncNotify(" + pid + "," + msg + "," + param + ")");
        }
    }

    private SQLException receiveErrorResponse() throws IOException {
        int elen = this.pgStream.ReceiveIntegerR(4);
        String totalMessage = this.pgStream.ReceiveString(elen - 4);
        ServerErrorMessage errorMsg = new ServerErrorMessage(totalMessage);
        if (Driver.logDebug) {
            Driver.debug(" <=BE ErrorMessage(" + errorMsg.toString() + ")");
        }
        return new SQLException(errorMsg.toString(), errorMsg.getSQLState());
    }

    private SQLWarning receiveNoticeResponse() throws IOException {
        int nlen = this.pgStream.ReceiveIntegerR(4);
        ServerErrorMessage warnMsg = new ServerErrorMessage(this.pgStream.ReceiveString(nlen - 4));
        if (Driver.logDebug) {
            Driver.debug(" <=BE NoticeResponse(" + warnMsg.toString() + ")");
        }
        return new PSQLWarning(warnMsg);
    }

    private String receiveCommandStatus() throws IOException {
        int l_len = this.pgStream.ReceiveIntegerR(4);
        String status = this.pgStream.ReceiveString(l_len - 5);
        this.pgStream.Receive(1);
        if (Driver.logDebug) {
            Driver.debug(" <=BE CommandStatus(" + status + ")");
        }
        return status;
    }

    private void interpretCommandStatus(String status, ResultHandler handler) {
        int update_count = 0;
        long insert_oid = 0L;
        if (status.startsWith("INSERT") || status.startsWith("UPDATE") || status.startsWith("DELETE") || status.startsWith("MOVE")) {
            try {
                update_count = Integer.parseInt(status.substring(1 + status.lastIndexOf(32)));
                if (status.startsWith("INSERT")) {
                    insert_oid = Long.parseLong(status.substring(1 + status.indexOf(32), status.lastIndexOf(32)));
                }
            }
            catch (NumberFormatException nfe) {
                handler.handleError(new PSQLException(GT.tr("Unable to interpret the update count in command completion tag: {0}.", status), PSQLState.CONNECTION_FAILURE));
                return;
            }
        }
        handler.handleCommandStatus(status, update_count, insert_oid);
    }

    private void receiveRFQ() throws IOException {
        if (this.pgStream.ReceiveIntegerR(4) != 5) {
            throw new IOException("unexpected length of ReadyForQuery message");
        }
        char tStatus = (char)this.pgStream.ReceiveChar();
        if (Driver.logDebug) {
            Driver.debug(" <=BE ReadyForQuery(" + tStatus + ")");
        }
        switch (tStatus) {
            case 'I': {
                this.protoConnection.setTransactionState(0);
                break;
            }
            case 'T': {
                this.protoConnection.setTransactionState(1);
                break;
            }
            case 'E': {
                this.protoConnection.setTransactionState(2);
                break;
            }
            default: {
                throw new IOException("unexpected transaction state in ReadyForQuery message: " + tStatus);
            }
        }
    }

    public void setEdbServer(boolean isEdbServer) {
        this.isEdbServer = isEdbServer;
    }

    public void setFunction(boolean isFunction) {
        this.isFunction = isFunction;
    }

    private static class ErrorTrackingResultHandler
    implements ResultHandler {
        private final ResultHandler delegateHandler;
        private boolean sawError = false;

        ErrorTrackingResultHandler(ResultHandler delegateHandler) {
            this.delegateHandler = delegateHandler;
        }

        public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
            this.delegateHandler.handleResultRows(fromQuery, fields, tuples, cursor);
        }

        public void handleCommandStatus(String status, int updateCount, long insertOID) {
            this.delegateHandler.handleCommandStatus(status, updateCount, insertOID);
        }

        public void handleWarning(SQLWarning warning) {
            this.delegateHandler.handleWarning(warning);
        }

        public void handleError(SQLException error) {
            this.sawError = true;
            this.delegateHandler.handleError(error);
        }

        public void handleCompletion() throws SQLException {
            this.delegateHandler.handleCompletion();
        }

        boolean hasErrors() {
            return this.sawError;
        }
    }
}

