/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import javax.sql.PooledConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OracleConnectionCacheEntry;
import oracle.jdbc.pool.OracleConnectionCacheEventListener;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleDatabaseInstance;
import oracle.jdbc.pool.OracleFailoverWorkerThread;
import oracle.jdbc.pool.OracleGravitateConnectionCacheThread;
import oracle.jdbc.pool.OracleImplicitConnectionCacheThread;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.pool.OracleRuntimeLoadBalancingEventHandlerThread;
import oracle.jdbc.xa.client.OracleXADataSource;

class OracleImplicitConnectionCache {
    protected OracleDataSource cacheEnabledDS = null;
    protected String cacheName = null;
    protected OracleConnectionPoolDataSource connectionPoolDS = null;
    protected boolean fastConnectionFailoverEnabled = false;
    protected String defaultUser = null;
    protected String defaultPassword = null;
    protected static final int DEFAULT_MIN_LIMIT = 0;
    protected static final int DEFAULT_MAX_LIMIT = Integer.MAX_VALUE;
    protected static final int DEFAULT_INITIAL_LIMIT = 0;
    protected static final int DEFAULT_MAX_STATEMENTS_LIMIT = 0;
    protected static final int DEFAULT_INACTIVITY_TIMEOUT = 0;
    protected static final int DEFAULT_TIMETOLIVE_TIMEOUT = 0;
    protected static final int DEFAULT_ABANDONED_CONN_TIMEOUT = 0;
    protected static final int DEFAULT_CONNECTION_WAIT_TIMEOUT = 0;
    protected static final String DEFAULT_ATTRIBUTE_WEIGHT = "0";
    protected static final int DEFAULT_LOWER_THRESHOLD_LIMIT = 20;
    protected static final int DEFAULT_PROPERTY_CHECK_INTERVAL = 900;
    protected static final int CLOSE_AND_REMOVE_ALL_CONNECTIONS = 1;
    protected static final int CLOSE_AND_REMOVE_FAILOVER_CONNECTIONS = 2;
    protected static final int PROCESS_INACTIVITY_TIMEOUT = 4;
    protected static final int CLOSE_AND_REMOVE_N_CONNECTIONS = 8;
    protected static final int DISABLE_STATEMENT_CACHING = 16;
    protected static final int RESET_STATEMENT_CACHE_SIZE = 18;
    protected static final int CLOSE_AND_REMOVE_RLB_CONNECTIONS = 24;
    private static final String ATTRKEY_DELIM = "0xffff";
    protected int cacheMinLimit = 0;
    protected int cacheMaxLimit = Integer.MAX_VALUE;
    protected int cacheInitialLimit = 0;
    protected int cacheMaxStatementsLimit = 0;
    protected Properties cacheAttributeWeights = null;
    protected int cacheInactivityTimeout = 0;
    protected int cacheTimeToLiveTimeout = 0;
    protected int cacheAbandonedConnectionTimeout = 0;
    protected int cacheLowerThresholdLimit = 20;
    protected int cachePropertyCheckInterval = 900;
    protected boolean cacheClosestConnectionMatch = false;
    protected boolean cacheValidateConnection = false;
    protected int cacheConnectionWaitTimeout = 0;
    static final String MIN_LIMIT_KEY = "MinLimit";
    static final String MAX_LIMIT_KEY = "MaxLimit";
    static final String INITIAL_LIMIT_KEY = "InitialLimit";
    static final String MAX_STATEMENTS_LIMIT_KEY = "MaxStatementsLimit";
    static final String ATTRIBUTE_WEIGHTS_KEY = "AttributeWeights";
    static final String INACTIVITY_TIMEOUT_KEY = "InactivityTimeout";
    static final String TIME_TO_LIVE_TIMEOUT_KEY = "TimeToLiveTimeout";
    static final String ABANDONED_CONNECTION_TIMEOUT_KEY = "AbandonedConnectionTimeout";
    static final String LOWER_THRESHOLD_LIMIT_KEY = "LowerThresholdLimit";
    static final String PROPERTY_CHECK_INTERVAL_KEY = "PropertyCheckInterval";
    static final String VALIDATE_CONNECTION_KEY = "ValidateConnection";
    static final String CLOSEST_CONNECTION_MATCH_KEY = "ClosestConnectionMatch";
    static final String CONNECTION_WAIT_TIMEOUT_KEY = "ConnectionWaitTimeout";
    static final int INSTANCE_GOOD = 1;
    static final int INSTANCE_UNKNOWN = 2;
    static final int INSTANCE_VIOLATING = 3;
    static final int INSTANCE_NO_DATA = 4;
    static final int INSTANCE_BLOCKED = 5;
    static final int RLB_NUMBER_OF_HITS_PER_INSTANCE = 1000;
    int dbInstancePercentTotal = 0;
    boolean useGoodGroup = false;
    LinkedList instancesToRetireList = null;
    OracleDatabaseInstance instanceToRetire = null;
    int retireConnectionsCount = 0;
    int countTotal = 0;
    protected OracleConnectionCacheManager cacheManager = null;
    protected boolean disableConnectionRequest = false;
    protected OracleImplicitConnectionCacheThread timeoutThread = null;
    protected OracleRuntimeLoadBalancingEventHandlerThread runtimeLoadBalancingThread = null;
    protected OracleGravitateConnectionCacheThread gravitateCacheThread = null;
    protected int connectionsToRemove = 0;
    private HashMap userMap = null;
    Vector checkedOutConnectionList = null;
    LinkedList databaseInstancesList = null;
    int cacheSize = 0;
    protected static final String EVENT_DELIMITER = " ";
    protected boolean isEntireServiceDownProcessed = false;
    protected int defaultUserPreFailureSize = 0;
    protected String dataSourceServiceName = null;
    protected OracleFailoverWorkerThread failoverWorkerThread = null;
    protected Random rand = null;
    protected int downEventCount = 0;
    protected int upEventCount = 0;
    protected int pendingCreationRequests = 0;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:18:55_PDT_2005";

    OracleImplicitConnectionCache(OracleDataSource oracleDataSource, Properties properties) throws SQLException {
        this.cacheEnabledDS = oracleDataSource;
        this.initializeConnectionCache();
        this.setConnectionCacheProperties(properties);
        this.defaultUserPrePopulateCache(this.cacheInitialLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultUserPrePopulateCache(int n) throws SQLException {
        if (n > 0) {
            String string = this.defaultUser;
            String string2 = this.defaultPassword;
            this.validateUser(string, string2);
            OraclePooledConnection oraclePooledConnection = null;
            for (int i = 0; i < n; ++i) {
                if (this.getTotalCachedConnections() >= this.cacheMaxLimit || (oraclePooledConnection = this.makeCacheConnection(string, string2)) == null) continue;
                OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
                synchronized (oracleImplicitConnectionCache) {
                    --this.cacheSize;
                }
                this.storeCacheConnection(string, null, oraclePooledConnection);
            }
        }
    }

    protected void initializeConnectionCache() throws SQLException {
        this.userMap = new HashMap();
        this.checkedOutConnectionList = new Vector();
        if (this.cacheManager == null) {
            this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
        }
        this.defaultUser = this.cacheEnabledDS.getUser();
        this.defaultPassword = this.cacheEnabledDS.getPassword();
        if (this.connectionPoolDS == null) {
            this.connectionPoolDS = this.cacheEnabledDS instanceof OracleXADataSource ? new OracleXADataSource() : new OracleConnectionPoolDataSource();
            this.cacheEnabledDS.copy(this.connectionPoolDS);
        }
        if (this.fastConnectionFailoverEnabled = this.cacheEnabledDS.getFastConnectionFailoverEnabled()) {
            this.rand = new Random(0L);
            ++this.cacheManager.failoverEnabledCacheCount;
        }
    }

    private void validateUser(String string, String string2) throws SQLException {
        if (string == null || string2 == null) {
            DatabaseError.throwSqlException(79);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getConnection(String string, String string2, Properties properties) throws SQLException {
        Connection connection;
        block20: {
            OraclePooledConnection oraclePooledConnection = null;
            connection = null;
            try {
                if (this.disableConnectionRequest) {
                    DatabaseError.throwSqlException(142);
                }
                this.validateUser(string, string2);
                if (!string.startsWith("\"")) {
                    string = string.toLowerCase();
                }
                if (this.getNumberOfCheckedOutConnections() < this.cacheMaxLimit) {
                    oraclePooledConnection = this.getCacheConnection(string, string2, properties);
                }
                if (oraclePooledConnection == null) {
                    this.processConnectionCacheCallback();
                    if (this.cacheSize > 0) {
                        oraclePooledConnection = this.getCacheConnection(string, string2, properties);
                    }
                    if (oraclePooledConnection == null && this.cacheConnectionWaitTimeout > 0) {
                        long l = (long)this.cacheConnectionWaitTimeout * 1000L;
                        long l2 = System.currentTimeMillis();
                        long l3 = 0L;
                        do {
                            this.processConnectionWaitTimeout(l);
                            if (this.cacheSize > 0) {
                                oraclePooledConnection = this.getCacheConnection(string, string2, properties);
                            }
                            l3 = System.currentTimeMillis();
                            l2 = l3;
                        } while (oraclePooledConnection == null && (l -= System.currentTimeMillis() - l2) > 0L);
                    }
                }
                if (oraclePooledConnection == null || oraclePooledConnection.physicalConn == null || (connection = oraclePooledConnection.getConnection()) == null) break block20;
                if (this.cacheValidateConnection && this.testDatabaseConnection((OracleConnection)connection) != 0) {
                    ((OracleConnection)connection).close(4096);
                    DatabaseError.throwSqlException(143);
                }
                if (this.cacheAbandonedConnectionTimeout > 0) {
                    ((OracleConnection)connection).setAbandonedTimeoutEnabled(true);
                }
                if (this.cacheTimeToLiveTimeout > 0) {
                    ((OracleConnection)connection).setStartTime(System.currentTimeMillis());
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
                synchronized (oracleImplicitConnectionCache) {
                    --this.cacheSize;
                    this.checkedOutConnectionList.addElement(oraclePooledConnection);
                }
            }
            catch (SQLException sQLException) {
                OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
                synchronized (oracleImplicitConnectionCache) {
                    if (oraclePooledConnection != null) {
                        --this.cacheSize;
                        this.abortConnection(oraclePooledConnection);
                    }
                }
                throw sQLException;
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OraclePooledConnection getCacheConnection(String string, String string2, Properties properties) throws SQLException {
        OraclePooledConnection oraclePooledConnection = this.retrieveCacheConnection(string, string2, properties);
        boolean bl = false;
        if (oraclePooledConnection == null) {
            OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
            synchronized (oracleImplicitConnectionCache) {
                if (this.getTotalCachedConnections() + this.pendingCreationRequests < this.cacheMaxLimit) {
                    ++this.pendingCreationRequests;
                    bl = true;
                }
            }
        }
        if (bl) {
            OracleImplicitConnectionCache oracleImplicitConnectionCache;
            try {
                oraclePooledConnection = this.makeCacheConnection(string, string2);
                Object var9_8 = null;
                oracleImplicitConnectionCache = this;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                OracleImplicitConnectionCache oracleImplicitConnectionCache2 = this;
                synchronized (oracleImplicitConnectionCache2) {
                    --this.pendingCreationRequests;
                }
                throw throwable;
            }
            synchronized (oracleImplicitConnectionCache) {
                --this.pendingCreationRequests;
            }
            if (properties != null && !properties.isEmpty()) {
                this.setUnMatchedAttributes(properties, oraclePooledConnection);
            }
        }
        return oraclePooledConnection;
    }

    protected int getTotalCachedConnections() {
        return this.cacheSize + this.getNumberOfCheckedOutConnections();
    }

    protected int getNumberOfCheckedOutConnections() {
        return this.checkedOutConnectionList.size();
    }

    private synchronized OraclePooledConnection retrieveCacheConnection(String string, String string2, Properties properties) throws SQLException {
        OraclePooledConnection oraclePooledConnection = null;
        OracleConnectionCacheEntry oracleConnectionCacheEntry = (OracleConnectionCacheEntry)this.userMap.get(string + string2.toUpperCase());
        if (oracleConnectionCacheEntry != null) {
            if (properties == null || properties != null && properties.isEmpty()) {
                if (oracleConnectionCacheEntry.userConnList != null) {
                    oraclePooledConnection = this.retrieveFromConnectionList(oracleConnectionCacheEntry.userConnList);
                }
            } else if (oracleConnectionCacheEntry.attrConnMap != null) {
                String string3 = this.buildAttrKey(properties);
                Vector vector = (Vector)oracleConnectionCacheEntry.attrConnMap.get(string3);
                if (vector != null) {
                    oraclePooledConnection = this.retrieveFromConnectionList(vector);
                }
                if (oraclePooledConnection == null && this.cacheClosestConnectionMatch) {
                    oraclePooledConnection = this.retrieveClosestConnectionMatch(oracleConnectionCacheEntry.attrConnMap, properties);
                }
                if (oraclePooledConnection == null && oracleConnectionCacheEntry.userConnList != null) {
                    oraclePooledConnection = this.retrieveFromConnectionList(oracleConnectionCacheEntry.userConnList);
                }
            }
        }
        if (oraclePooledConnection != null && properties != null && !properties.isEmpty()) {
            this.setUnMatchedAttributes(properties, oraclePooledConnection);
        }
        return oraclePooledConnection;
    }

    private OraclePooledConnection retrieveClosestConnectionMatch(HashMap hashMap, Properties properties) throws SQLException {
        OraclePooledConnection oraclePooledConnection = null;
        OraclePooledConnection oraclePooledConnection2 = null;
        int n = properties.size();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (this.cacheAttributeWeights != null) {
            n2 = this.getAttributesWeightCount(properties, null);
        }
        if (hashMap != null && !hashMap.isEmpty()) {
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Vector vector = (Vector)entry.getValue();
                Object[] objectArray = vector.toArray();
                int n7 = vector.size();
                for (int i = 0; i < n7; ++i) {
                    oraclePooledConnection = (OraclePooledConnection)objectArray[i];
                    if (oraclePooledConnection.cachedConnectionAttributes == null || oraclePooledConnection.cachedConnectionAttributes.isEmpty() || oraclePooledConnection.cachedConnectionAttributes.size() > n) continue;
                    if (n2 > 0) {
                        n4 = this.getAttributesWeightCount(properties, oraclePooledConnection.cachedConnectionAttributes);
                        if (n4 <= n3) continue;
                        oraclePooledConnection2 = oraclePooledConnection;
                        n3 = n4;
                        continue;
                    }
                    n6 = this.getAttributesMatchCount(properties, oraclePooledConnection.cachedConnectionAttributes);
                    if (n6 <= n5) continue;
                    oraclePooledConnection2 = oraclePooledConnection;
                    n5 = n6;
                }
            }
        }
        return oraclePooledConnection2;
    }

    private int getAttributesMatchCount(Properties properties, Properties properties2) throws SQLException {
        int n = 0;
        Map.Entry<Object, Object> entry = null;
        Object object = null;
        Object object2 = null;
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            object = entry.getKey();
            object2 = entry.getValue();
            if (!properties2.containsKey(object) || !object2.equals(properties2.get(object))) continue;
            ++n;
        }
        return n;
    }

    private int getAttributesWeightCount(Properties properties, Properties properties2) throws SQLException {
        Map.Entry<Object, Object> entry = null;
        Object object = null;
        Object object2 = null;
        int n = 0;
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            object = entry.getKey();
            object2 = entry.getValue();
            if (properties2 == null) {
                if (!this.cacheAttributeWeights.containsKey(object)) continue;
                n += Integer.parseInt((String)this.cacheAttributeWeights.get(object));
                continue;
            }
            if (!properties2.containsKey(object) || !object2.equals(properties2.get(object))) continue;
            if (this.cacheAttributeWeights.containsKey(object)) {
                n += Integer.parseInt((String)this.cacheAttributeWeights.get(object));
                continue;
            }
            ++n;
        }
        return n;
    }

    private void setUnMatchedAttributes(Properties properties, OraclePooledConnection oraclePooledConnection) throws SQLException {
        if (oraclePooledConnection.unMatchedCachedConnAttr == null) {
            oraclePooledConnection.unMatchedCachedConnAttr = new Properties();
        } else {
            oraclePooledConnection.unMatchedCachedConnAttr.clear();
        }
        if (!this.cacheClosestConnectionMatch) {
            oraclePooledConnection.unMatchedCachedConnAttr.putAll((Map<?, ?>)properties);
        } else {
            Properties properties2 = oraclePooledConnection.cachedConnectionAttributes;
            Map.Entry<Object, Object> entry = null;
            Object object = null;
            Object object2 = null;
            Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                object = entry.getKey();
                object2 = entry.getValue();
                if (properties2.containsKey(object) || object2.equals(properties2.get(object))) continue;
                oraclePooledConnection.unMatchedCachedConnAttr.put(object, object2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OraclePooledConnection retrieveFromConnectionList(Vector vector) throws SQLException {
        if (vector.isEmpty()) {
            return null;
        }
        OraclePooledConnection oraclePooledConnection = null;
        if (this.fastConnectionFailoverEnabled) {
            if (this.useGoodGroup && this.databaseInstancesList != null && this.databaseInstancesList.size() > 0) {
                LinkedList linkedList = this.databaseInstancesList;
                synchronized (linkedList) {
                    int n = this.databaseInstancesList.size();
                    OracleDatabaseInstance oracleDatabaseInstance = null;
                    int n2 = 0;
                    boolean[] blArray = new boolean[n];
                    int n3 = this.dbInstancePercentTotal;
                    block3: for (int i = 0; i < n; ++i) {
                        int n4 = 0;
                        n2 = n3 <= 1 ? 0 : this.rand.nextInt(n3 - 1);
                        for (int j = 0; j < n; ++j) {
                            oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(j);
                            if (blArray[j] || oracleDatabaseInstance.flag > 3 || n2 > (n4 += oracleDatabaseInstance.percent)) continue;
                            if (i == 0) {
                                ++oracleDatabaseInstance.attemptedConnRequestCount;
                            }
                            if ((oraclePooledConnection = this.selectConnectionFromList(vector, oracleDatabaseInstance)) != null) break block3;
                            n3 -= oracleDatabaseInstance.percent;
                            blArray[j] = true;
                            continue block3;
                        }
                    }
                }
            }
            int n = vector.size();
            int n5 = this.rand.nextInt(n);
            OraclePooledConnection oraclePooledConnection2 = null;
            for (int i = 0; i < n; ++i) {
                oraclePooledConnection2 = (OraclePooledConnection)vector.get((n5++ + n) % n);
                if (oraclePooledConnection2.connectionMarkedDown) continue;
                oraclePooledConnection = oraclePooledConnection2;
                vector.remove(oraclePooledConnection);
                break;
            }
        } else {
            oraclePooledConnection = (OraclePooledConnection)vector.remove(0);
        }
        return oraclePooledConnection;
    }

    private OraclePooledConnection selectConnectionFromList(Vector vector, OracleDatabaseInstance oracleDatabaseInstance) {
        OraclePooledConnection oraclePooledConnection = null;
        OraclePooledConnection oraclePooledConnection2 = null;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            oraclePooledConnection2 = (OraclePooledConnection)vector.get(i);
            if (oraclePooledConnection2.connectionMarkedDown || oraclePooledConnection2.dataSourceDbUniqNameKey != oracleDatabaseInstance.databaseUniqName || oraclePooledConnection2.dataSourceInstanceNameKey != oracleDatabaseInstance.instanceName) continue;
            oraclePooledConnection = oraclePooledConnection2;
            vector.remove(oraclePooledConnection);
            break;
        }
        return oraclePooledConnection;
    }

    private void removeCacheConnection(OraclePooledConnection oraclePooledConnection) throws SQLException {
        boolean bl = false;
        String string = oraclePooledConnection.pcUser;
        OracleConnectionCacheEntry oracleConnectionCacheEntry = oraclePooledConnection.removeFromImplictCache(this.userMap);
        if (oracleConnectionCacheEntry != null) {
            String string2;
            Vector vector;
            Properties properties = oraclePooledConnection.cachedConnectionAttributes;
            if (properties == null || properties != null && properties.isEmpty()) {
                if (oracleConnectionCacheEntry.userConnList != null) {
                    bl = oracleConnectionCacheEntry.userConnList.removeElement(oraclePooledConnection);
                }
            } else if (oracleConnectionCacheEntry.attrConnMap != null && (vector = (Vector)oracleConnectionCacheEntry.attrConnMap.get(string2 = this.buildAttrKey(properties))) != null) {
                if (oraclePooledConnection.unMatchedCachedConnAttr != null) {
                    oraclePooledConnection.unMatchedCachedConnAttr.clear();
                    oraclePooledConnection.unMatchedCachedConnAttr = null;
                }
                if (oraclePooledConnection.cachedConnectionAttributes != null) {
                    oraclePooledConnection.cachedConnectionAttributes.clear();
                    oraclePooledConnection.cachedConnectionAttributes = null;
                }
                properties = null;
                bl = vector.removeElement(oraclePooledConnection);
            }
        }
        if (bl) {
            --this.cacheSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doForEveryCachedConnection(int n) throws SQLException {
        int n2 = 0;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
        synchronized (oracleImplicitConnectionCache) {
            if (this.userMap != null && !this.userMap.isEmpty()) {
                Iterator iterator = this.userMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    OraclePooledConnection oraclePooledConnection;
                    Object object;
                    Object object2;
                    Map.Entry entry = iterator.next();
                    OracleConnectionCacheEntry oracleConnectionCacheEntry = (OracleConnectionCacheEntry)entry.getValue();
                    if (oracleConnectionCacheEntry.userConnList != null && !oracleConnectionCacheEntry.userConnList.isEmpty()) {
                        object2 = oracleConnectionCacheEntry.userConnList;
                        object = ((Vector)object2).toArray();
                        for (int i = 0; i < ((Object[])object).length; ++i) {
                            oraclePooledConnection = (OraclePooledConnection)object[i];
                            if (oraclePooledConnection == null || !this.performPooledConnectionTask(oraclePooledConnection, n)) continue;
                            ++n2;
                        }
                    }
                    if (oracleConnectionCacheEntry.attrConnMap == null || oracleConnectionCacheEntry.attrConnMap.isEmpty()) continue;
                    object2 = oracleConnectionCacheEntry.attrConnMap.entrySet().iterator();
                    while (object2.hasNext()) {
                        object = (Map.Entry)object2.next();
                        Vector vector = (Vector)object.getValue();
                        Object[] objectArray = vector.toArray();
                        for (int i = 0; i < objectArray.length; ++i) {
                            oraclePooledConnection = (OraclePooledConnection)objectArray[i];
                            if (oraclePooledConnection == null || !this.performPooledConnectionTask(oraclePooledConnection, n)) continue;
                            ++n2;
                        }
                    }
                    if (n != 1) continue;
                    oracleConnectionCacheEntry.attrConnMap.clear();
                }
                if (n == 1) {
                    this.userMap.clear();
                    this.cacheSize = 0;
                }
            }
        }
        if (n2 > 0) {
            this.defaultUserPrePopulateCache(n2);
        }
    }

    private boolean performPooledConnectionTask(OraclePooledConnection oraclePooledConnection, int n) throws SQLException {
        boolean bl = false;
        switch (n) {
            case 2: {
                if (!oraclePooledConnection.connectionMarkedDown) break;
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                break;
            }
            case 8: {
                if (this.connectionsToRemove <= 0) break;
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                --this.connectionsToRemove;
                break;
            }
            case 24: {
                if (this.retireConnectionsCount <= 0 || this.instanceToRetire.databaseUniqName != oraclePooledConnection.dataSourceDbUniqNameKey || this.instanceToRetire.instanceName != oraclePooledConnection.dataSourceInstanceNameKey) break;
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                --this.retireConnectionsCount;
                if (this.getTotalCachedConnections() >= this.cacheMinLimit) break;
                bl = true;
                break;
            }
            case 4096: {
                Connection connection = oraclePooledConnection.getLogicalHandle();
                if (connection == null || this.testDatabaseConnection((OracleConnection)connection) == 0) break;
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                bl = true;
                break;
            }
            case 8192: {
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                bl = true;
                break;
            }
            case 1: {
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                break;
            }
            case 4: {
                this.processInactivityTimeout(oraclePooledConnection);
                break;
            }
            case 16: {
                this.setStatementCaching(oraclePooledConnection, this.cacheMaxStatementsLimit, false);
                break;
            }
            case 18: {
                this.setStatementCaching(oraclePooledConnection, this.cacheMaxStatementsLimit, true);
                break;
            }
        }
        return bl;
    }

    protected synchronized void doForEveryCheckedOutConnection(int n) throws SQLException {
        int n2 = this.checkedOutConnectionList.size();
        if (n == 1) {
            for (int i = 0; i < n2; ++i) {
                this.closeCheckedOutConnection((OraclePooledConnection)this.checkedOutConnectionList.get(i), false);
            }
            this.checkedOutConnectionList.removeAllElements();
        } else if (n == 24) {
            for (int i = 0; i < n2 && this.retireConnectionsCount > 0; ++i) {
                OraclePooledConnection oraclePooledConnection = (OraclePooledConnection)this.checkedOutConnectionList.get(i);
                if (this.instanceToRetire.databaseUniqName != oraclePooledConnection.dataSourceDbUniqNameKey || this.instanceToRetire.instanceName != oraclePooledConnection.dataSourceInstanceNameKey) continue;
                oraclePooledConnection.closeOption = 4096;
                this.retireConnectionsCount -= 2;
            }
        }
    }

    protected void closeCheckedOutConnection(OraclePooledConnection oraclePooledConnection, boolean bl) throws SQLException {
        if (oraclePooledConnection != null) {
            OracleConnection oracleConnection = (OracleConnection)oraclePooledConnection.getLogicalHandle();
            try {
                if (!oracleConnection.getAutoCommit() && !oraclePooledConnection.isHostDown) {
                    oracleConnection.rollback();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (bl) {
                try {
                    oracleConnection.close();
                }
                catch (SQLException sQLException) {}
            } else {
                this.actualPooledConnectionClose(oraclePooledConnection);
            }
        }
    }

    private synchronized void storeCacheConnection(String string, Properties properties, OraclePooledConnection oraclePooledConnection) throws SQLException {
        OracleConnectionCacheEntry oracleConnectionCacheEntry;
        boolean bl = false;
        if (oraclePooledConnection == null || oraclePooledConnection.physicalConn == null) {
            return;
        }
        if (this.cacheInactivityTimeout > 0) {
            oraclePooledConnection.setLastAccessedTime(System.currentTimeMillis());
        }
        if (oraclePooledConnection.unMatchedCachedConnAttr != null) {
            oraclePooledConnection.unMatchedCachedConnAttr.clear();
            oraclePooledConnection.unMatchedCachedConnAttr = null;
        }
        if (!string.startsWith("\"")) {
            string = string.toLowerCase();
        }
        if ((oracleConnectionCacheEntry = oraclePooledConnection.removeFromImplictCache(this.userMap)) != null) {
            if (properties == null || properties != null && properties.isEmpty()) {
                if (oracleConnectionCacheEntry.userConnList == null) {
                    oracleConnectionCacheEntry.userConnList = new Vector();
                }
                bl = oracleConnectionCacheEntry.userConnList.add(oraclePooledConnection);
            } else {
                String string2;
                Vector<OraclePooledConnection> vector;
                oraclePooledConnection.cachedConnectionAttributes = properties;
                if (oracleConnectionCacheEntry.attrConnMap == null) {
                    oracleConnectionCacheEntry.attrConnMap = new HashMap();
                }
                if ((vector = (Vector<OraclePooledConnection>)oracleConnectionCacheEntry.attrConnMap.get(string2 = this.buildAttrKey(properties))) != null) {
                    bl = vector.add(oraclePooledConnection);
                } else {
                    vector = new Vector<OraclePooledConnection>();
                    bl = vector.add(oraclePooledConnection);
                    oracleConnectionCacheEntry.attrConnMap.put(string2, vector);
                }
            }
        } else {
            oracleConnectionCacheEntry = new OracleConnectionCacheEntry();
            oraclePooledConnection.addToImplicitCache(this.userMap, oracleConnectionCacheEntry);
            if (properties == null || properties != null && properties.isEmpty()) {
                Vector<OraclePooledConnection> vector = new Vector<OraclePooledConnection>();
                bl = vector.add(oraclePooledConnection);
                oracleConnectionCacheEntry.userConnList = vector;
            } else {
                String string3 = this.buildAttrKey(properties);
                oraclePooledConnection.cachedConnectionAttributes = properties;
                HashMap hashMap = new HashMap();
                Vector<OraclePooledConnection> vector = new Vector<OraclePooledConnection>();
                bl = vector.add(oraclePooledConnection);
                hashMap.put(string3, vector);
                oracleConnectionCacheEntry.attrConnMap = hashMap;
            }
        }
        if (bl) {
            ++this.cacheSize;
        }
        if (this.cacheConnectionWaitTimeout > 0) {
            this.notifyAll();
        }
    }

    private String buildAttrKey(Properties properties) throws SQLException {
        int n;
        int n2 = properties.keySet().size();
        Object[] objectArray = properties.keySet().toArray();
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        while (bl) {
            bl = false;
            for (n = 0; n < n2 - 1; ++n) {
                if (((String)objectArray[n]).compareTo((String)objectArray[n + 1]) <= 0) continue;
                bl = true;
                Object object = objectArray[n];
                objectArray[n] = objectArray[n + 1];
                objectArray[n + 1] = object;
            }
        }
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(objectArray[n] + ATTRKEY_DELIM + properties.get(objectArray[n]));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OraclePooledConnection makeCacheConnection(String string, String string2) throws SQLException {
        OraclePooledConnection oraclePooledConnection = (OraclePooledConnection)this.connectionPoolDS.getPooledConnection(string, string2);
        if (oraclePooledConnection != null) {
            if (this.cacheMaxStatementsLimit > 0) {
                this.setStatementCaching(oraclePooledConnection, this.cacheMaxStatementsLimit, true);
            }
            oraclePooledConnection.registerImplicitCacheConnectionEventListener(new OracleConnectionCacheEventListener(this));
            oraclePooledConnection.cachedConnectionAttributes = new Properties();
            if (this.fastConnectionFailoverEnabled) {
                this.initFailoverParameters(oraclePooledConnection);
            }
            OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
            synchronized (oracleImplicitConnectionCache) {
                ++this.cacheSize;
                if (this.fastConnectionFailoverEnabled && this.runtimeLoadBalancingThread == null) {
                    this.runtimeLoadBalancingThread = new OracleRuntimeLoadBalancingEventHandlerThread(this.dataSourceServiceName);
                    this.cacheManager.checkAndStartThread(this.runtimeLoadBalancingThread);
                }
            }
        }
        return oraclePooledConnection;
    }

    private void setStatementCaching(OraclePooledConnection oraclePooledConnection, int n, boolean bl) throws SQLException {
        if (n > 0) {
            oraclePooledConnection.setStatementCacheSize(n);
        }
        oraclePooledConnection.setImplicitCachingEnabled(bl);
        oraclePooledConnection.setExplicitCachingEnabled(bl);
    }

    protected synchronized void reusePooledConnection(PooledConnection pooledConnection) throws SQLException {
        OraclePooledConnection oraclePooledConnection = (OraclePooledConnection)pooledConnection;
        if (oraclePooledConnection != null && oraclePooledConnection.physicalConn != null) {
            this.storeCacheConnection(oraclePooledConnection.pcUser, oraclePooledConnection.cachedConnectionAttributes, oraclePooledConnection);
            this.checkedOutConnectionList.removeElement(oraclePooledConnection);
        }
    }

    protected void closePooledConnection(PooledConnection pooledConnection) throws SQLException {
        if (pooledConnection != null) {
            this.actualPooledConnectionClose((OraclePooledConnection)pooledConnection);
            if (((OraclePooledConnection)pooledConnection).closeOption == 4096) {
                this.checkedOutConnectionList.removeElement(pooledConnection);
            }
            pooledConnection = null;
            if (this.getTotalCachedConnections() < this.cacheMinLimit) {
                this.defaultUserPrePopulateCache(1);
            }
        }
    }

    protected void refreshCacheConnections(int n) throws SQLException {
        this.doForEveryCachedConnection(n);
    }

    protected synchronized void reinitializeCacheConnections(Properties properties) throws SQLException {
        this.defaultUser = this.cacheEnabledDS.getUser();
        this.defaultPassword = this.cacheEnabledDS.getPassword();
        this.fastConnectionFailoverEnabled = this.cacheEnabledDS.getFastConnectionFailoverEnabled();
        this.cleanupTimeoutThread();
        this.doForEveryCheckedOutConnection(1);
        int n = this.cacheInitialLimit;
        int n2 = this.cacheMaxLimit;
        int n3 = this.cacheMaxStatementsLimit;
        this.setConnectionCacheProperties(properties);
        if (this.cacheInitialLimit > n) {
            int n4 = this.cacheInitialLimit - n;
            this.defaultUserPrePopulateCache(n4);
        }
        if (n2 != Integer.MAX_VALUE && this.cacheMaxLimit < n2 && this.cacheSize > this.cacheMaxLimit) {
            this.connectionsToRemove = this.cacheSize - this.cacheMaxLimit;
            this.doForEveryCachedConnection(8);
            this.connectionsToRemove = 0;
        }
        if (this.cacheMaxStatementsLimit != n3) {
            if (this.cacheMaxStatementsLimit == 0) {
                this.doForEveryCachedConnection(16);
            } else {
                this.doForEveryCachedConnection(18);
            }
        }
    }

    protected synchronized void setConnectionCacheProperties(Properties properties) throws SQLException {
        try {
            if (properties != null) {
                Properties properties2;
                String string = null;
                string = properties.getProperty(MIN_LIMIT_KEY);
                if (string != null && (this.cacheMinLimit = Integer.parseInt(string)) < 0) {
                    this.cacheMinLimit = 0;
                }
                if ((string = properties.getProperty(MAX_LIMIT_KEY)) != null && (this.cacheMaxLimit = Integer.parseInt(string)) < 0) {
                    this.cacheMaxLimit = Integer.MAX_VALUE;
                }
                if (this.cacheMaxLimit < this.cacheMinLimit) {
                    this.cacheMinLimit = this.cacheMaxLimit;
                }
                if ((string = properties.getProperty(INITIAL_LIMIT_KEY)) != null && (this.cacheInitialLimit = Integer.parseInt(string)) < 0) {
                    this.cacheInitialLimit = 0;
                }
                if (this.cacheInitialLimit > this.cacheMaxLimit) {
                    this.cacheInitialLimit = this.cacheMaxLimit;
                }
                if ((string = properties.getProperty(MAX_STATEMENTS_LIMIT_KEY)) != null && (this.cacheMaxStatementsLimit = Integer.parseInt(string)) < 0) {
                    this.cacheMaxStatementsLimit = 0;
                }
                if ((properties2 = (Properties)properties.get(ATTRIBUTE_WEIGHTS_KEY)) != null) {
                    Map.Entry<Object, Object> entry = null;
                    int n = 0;
                    Object object = null;
                    Iterator<Map.Entry<Object, Object>> iterator = properties2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        entry = iterator.next();
                        object = entry.getKey();
                        string = (String)properties2.get(object);
                        if (string == null || (n = Integer.parseInt(string)) >= 0) continue;
                        properties2.put(object, DEFAULT_ATTRIBUTE_WEIGHT);
                    }
                    if (this.cacheAttributeWeights == null) {
                        this.cacheAttributeWeights = new Properties();
                    }
                    this.cacheAttributeWeights.putAll((Map<?, ?>)properties2);
                }
                if ((string = properties.getProperty(INACTIVITY_TIMEOUT_KEY)) != null && (this.cacheInactivityTimeout = Integer.parseInt(string)) < 0) {
                    this.cacheInactivityTimeout = 0;
                }
                if ((string = properties.getProperty(TIME_TO_LIVE_TIMEOUT_KEY)) != null && (this.cacheTimeToLiveTimeout = Integer.parseInt(string)) < 0) {
                    this.cacheTimeToLiveTimeout = 0;
                }
                if ((string = properties.getProperty(ABANDONED_CONNECTION_TIMEOUT_KEY)) != null && (this.cacheAbandonedConnectionTimeout = Integer.parseInt(string)) < 0) {
                    this.cacheAbandonedConnectionTimeout = 0;
                }
                if ((string = properties.getProperty(LOWER_THRESHOLD_LIMIT_KEY)) != null) {
                    this.cacheLowerThresholdLimit = Integer.parseInt(string);
                    if (this.cacheLowerThresholdLimit < 0 || this.cacheLowerThresholdLimit > 100) {
                        this.cacheLowerThresholdLimit = 20;
                    }
                }
                if ((string = properties.getProperty(PROPERTY_CHECK_INTERVAL_KEY)) != null && (this.cachePropertyCheckInterval = Integer.parseInt(string)) < 0) {
                    this.cachePropertyCheckInterval = 900;
                }
                if ((string = properties.getProperty(VALIDATE_CONNECTION_KEY)) != null) {
                    this.cacheValidateConnection = Boolean.valueOf(string);
                }
                if ((string = properties.getProperty(CLOSEST_CONNECTION_MATCH_KEY)) != null) {
                    this.cacheClosestConnectionMatch = Boolean.valueOf(string);
                }
                if ((string = properties.getProperty(CONNECTION_WAIT_TIMEOUT_KEY)) != null && (this.cacheConnectionWaitTimeout = Integer.parseInt(string)) < 0) {
                    this.cacheConnectionWaitTimeout = 0;
                }
            } else {
                this.cacheMinLimit = 0;
                this.cacheMaxLimit = Integer.MAX_VALUE;
                this.cacheInitialLimit = 0;
                this.cacheMaxStatementsLimit = 0;
                this.cacheAttributeWeights = null;
                this.cacheInactivityTimeout = 0;
                this.cacheTimeToLiveTimeout = 0;
                this.cacheAbandonedConnectionTimeout = 0;
                this.cacheLowerThresholdLimit = 20;
                this.cachePropertyCheckInterval = 900;
                this.cacheClosestConnectionMatch = false;
                this.cacheValidateConnection = false;
                this.cacheConnectionWaitTimeout = 0;
            }
            if (this.cacheInactivityTimeout > 0 || this.cacheTimeToLiveTimeout > 0 || this.cacheAbandonedConnectionTimeout > 0) {
                if (this.timeoutThread == null) {
                    this.timeoutThread = new OracleImplicitConnectionCacheThread(this);
                }
                this.cacheManager.checkAndStartThread(this.timeoutThread);
            }
        }
        catch (NumberFormatException numberFormatException) {
            DatabaseError.throwSqlException(139);
        }
    }

    protected Properties getConnectionCacheProperties() throws SQLException {
        Properties properties = new Properties();
        properties.setProperty(MIN_LIMIT_KEY, String.valueOf(this.cacheMinLimit));
        properties.setProperty(MAX_LIMIT_KEY, String.valueOf(this.cacheMaxLimit));
        properties.setProperty(INITIAL_LIMIT_KEY, String.valueOf(this.cacheInitialLimit));
        properties.setProperty(MAX_STATEMENTS_LIMIT_KEY, String.valueOf(this.cacheMaxStatementsLimit));
        if (this.cacheAttributeWeights != null) {
            properties.put(ATTRIBUTE_WEIGHTS_KEY, this.cacheAttributeWeights);
        } else {
            properties.setProperty(ATTRIBUTE_WEIGHTS_KEY, "NULL");
        }
        properties.setProperty(INACTIVITY_TIMEOUT_KEY, String.valueOf(this.cacheInactivityTimeout));
        properties.setProperty(TIME_TO_LIVE_TIMEOUT_KEY, String.valueOf(this.cacheTimeToLiveTimeout));
        properties.setProperty(ABANDONED_CONNECTION_TIMEOUT_KEY, String.valueOf(this.cacheAbandonedConnectionTimeout));
        properties.setProperty(LOWER_THRESHOLD_LIMIT_KEY, String.valueOf(this.cacheLowerThresholdLimit));
        properties.setProperty(PROPERTY_CHECK_INTERVAL_KEY, String.valueOf(this.cachePropertyCheckInterval));
        properties.setProperty(CONNECTION_WAIT_TIMEOUT_KEY, String.valueOf(this.cacheConnectionWaitTimeout));
        properties.setProperty(VALIDATE_CONNECTION_KEY, String.valueOf(this.cacheValidateConnection));
        properties.setProperty(CLOSEST_CONNECTION_MATCH_KEY, String.valueOf(this.cacheClosestConnectionMatch));
        return properties;
    }

    protected int testDatabaseConnection(OracleConnection oracleConnection) throws SQLException {
        return oracleConnection.pingDatabase(0);
    }

    protected synchronized void closeConnectionCache() throws SQLException {
        this.cleanupTimeoutThread();
        this.purgeCacheConnections(true);
        this.connectionPoolDS = null;
        this.cacheEnabledDS = null;
        this.checkedOutConnectionList = null;
        this.userMap = null;
        this.cacheManager = null;
    }

    protected synchronized void disableConnectionCache() throws SQLException {
        this.disableConnectionRequest = true;
    }

    protected synchronized void enableConnectionCache() throws SQLException {
        this.disableConnectionRequest = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initFailoverParameters(OraclePooledConnection oraclePooledConnection) throws SQLException {
        String string = null;
        String string2 = null;
        String string3 = null;
        Properties properties = ((OracleConnection)oraclePooledConnection.getPhysicalHandle()).getServerSessionInfo();
        string3 = properties.getProperty("INSTANCE_NAME");
        if (string3 != null) {
            string = oraclePooledConnection.dataSourceInstanceNameKey = string3.trim().intern();
        }
        if ((string3 = properties.getProperty("SERVER_HOST")) != null) {
            oraclePooledConnection.dataSourceHostNameKey = string3.trim().intern();
        }
        if ((string3 = properties.getProperty("SERVICE_NAME")) != null) {
            this.dataSourceServiceName = string3.trim();
        }
        if ((string3 = properties.getProperty("DATABASE_NAME")) != null) {
            string2 = oraclePooledConnection.dataSourceDbUniqNameKey = string3.trim().intern();
        }
        if (this.databaseInstancesList == null) {
            this.databaseInstancesList = new LinkedList();
        }
        int n = this.databaseInstancesList.size();
        LinkedList linkedList = this.databaseInstancesList;
        synchronized (linkedList) {
            OracleDatabaseInstance oracleDatabaseInstance = null;
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i);
                if (oracleDatabaseInstance.databaseUniqName != string2 || oracleDatabaseInstance.instanceName != string) continue;
                ++oracleDatabaseInstance.numberOfConnectionsCount;
                bl = true;
                break;
            }
            if (!bl) {
                OracleDatabaseInstance oracleDatabaseInstance2 = new OracleDatabaseInstance(string2, string);
                ++oracleDatabaseInstance2.numberOfConnectionsCount;
                this.databaseInstancesList.add(oracleDatabaseInstance2);
            }
        }
    }

    protected void processFailoverEvent(int n, String string, String string2, String string3, String string4, int n2) {
        if (n == 256) {
            if (string4.equalsIgnoreCase("down") || string4.equalsIgnoreCase("not_restarting") || string4.equalsIgnoreCase("restart_failed")) {
                ++this.downEventCount;
                this.markDownLostConnections(true, false, string, string2, string3, string4);
                this.cleanupFailoverConnections(true, false, string, string2, string3, string4);
            } else if (string4.equalsIgnoreCase("up")) {
                if (this.downEventCount > 0) {
                    ++this.upEventCount;
                }
                try {
                    this.processUpEvent(n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.isEntireServiceDownProcessed = false;
            }
        } else if (n == 512 && string4.equalsIgnoreCase("nodedown")) {
            this.markDownLostConnections(false, true, string, string2, string3, string4);
            this.cleanupFailoverConnections(false, true, string, string2, string3, string4);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized void processUpEvent(int n) throws SQLException {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getTotalCachedConnections();
        boolean bl = false;
        if (n <= 1) {
            n = 2;
        }
        if ((n2 = this.downEventCount == 0 && this.upEventCount == 0 && this.getNumberOfDefaultUserConnections() > 0 ? (int)((double)this.cacheSize * 0.25) : this.defaultUserPreFailureSize) <= 0) {
            if (this.getNumberOfDefaultUserConnections() <= 0) return;
            n3 = (int)((double)this.cacheSize * 0.25);
            bl = true;
        } else {
            n3 = n2 / n;
            if (n3 + n4 > this.cacheMaxLimit) {
                bl = true;
            }
        }
        if (n3 > 0) {
            this.loadBalanceConnections(n3, bl);
        }
        if (this.downEventCount != this.upEventCount) return;
        this.defaultUserPreFailureSize = 0;
        this.downEventCount = 0;
        this.upEventCount = 0;
    }

    private void loadBalanceConnections(int n, boolean bl) throws SQLException {
        if (bl) {
            this.connectionsToRemove = n;
            this.doForEveryCachedConnection(8);
            this.connectionsToRemove = 0;
        }
        if (n <= 10) {
            try {
                this.defaultUserPrePopulateCache(n);
            }
            catch (Exception exception) {}
        } else {
            int n2 = (int)((double)n * 0.25);
            for (int i = 0; i < 4; ++i) {
                try {
                    this.defaultUserPrePopulateCache(n2);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private int getNumberOfDefaultUserConnections() {
        OracleConnectionCacheEntry oracleConnectionCacheEntry;
        int n = 0;
        if (this.userMap != null && !this.userMap.isEmpty() && (oracleConnectionCacheEntry = (OracleConnectionCacheEntry)this.userMap.get(this.defaultUser + this.defaultPassword.toUpperCase())) != null && oracleConnectionCacheEntry.userConnList != null && !oracleConnectionCacheEntry.userConnList.isEmpty()) {
            n = oracleConnectionCacheEntry.userConnList.size();
        }
        return n;
    }

    synchronized void markDownLostConnections(boolean bl, boolean bl2, String string, String string2, String string3, String string4) {
        if (!this.isEntireServiceDownProcessed) {
            if (this.userMap != null && !this.userMap.isEmpty()) {
                Iterator iterator = this.userMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Object object;
                    Object object2;
                    OracleConnectionCacheEntry oracleConnectionCacheEntry;
                    boolean bl3 = false;
                    Map.Entry entry = iterator.next();
                    if (this.defaultUser != null && this.defaultUser.equalsIgnoreCase((String)entry.getKey())) {
                        bl3 = true;
                    }
                    if ((oracleConnectionCacheEntry = (OracleConnectionCacheEntry)entry.getValue()) != null && oracleConnectionCacheEntry.userConnList != null && !oracleConnectionCacheEntry.userConnList.isEmpty()) {
                        boolean bl4 = false;
                        object2 = oracleConnectionCacheEntry.userConnList.iterator();
                        while (object2.hasNext()) {
                            object = (OraclePooledConnection)object2.next();
                            if (bl) {
                                bl4 = this.markDownConnectionsForServiceEvent(string, string2, (OraclePooledConnection)object);
                            } else if (bl2) {
                                bl4 = this.markDownConnectionsForHostEvent(string3, (OraclePooledConnection)object);
                            }
                            if (!bl4 || !bl3) continue;
                            ++this.defaultUserPreFailureSize;
                        }
                    }
                    if (oracleConnectionCacheEntry == null || oracleConnectionCacheEntry.attrConnMap == null || oracleConnectionCacheEntry.attrConnMap.isEmpty()) continue;
                    Iterator iterator2 = oracleConnectionCacheEntry.attrConnMap.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        object2 = iterator2.next();
                        object = ((Vector)object2.getValue()).iterator();
                        while (object.hasNext()) {
                            OraclePooledConnection oraclePooledConnection = (OraclePooledConnection)object.next();
                            if (bl) {
                                this.markDownConnectionsForServiceEvent(string, string2, oraclePooledConnection);
                                continue;
                            }
                            if (!bl2) continue;
                            this.markDownConnectionsForHostEvent(string3, oraclePooledConnection);
                        }
                    }
                }
            }
            if (string == null) {
                this.isEntireServiceDownProcessed = true;
            }
        }
    }

    private boolean markDownConnectionsForServiceEvent(String string, String string2, OraclePooledConnection oraclePooledConnection) {
        boolean bl = false;
        if (string == null || string2 == oraclePooledConnection.dataSourceDbUniqNameKey && string == oraclePooledConnection.dataSourceInstanceNameKey) {
            oraclePooledConnection.connectionMarkedDown = true;
            bl = true;
        }
        return bl;
    }

    private boolean markDownConnectionsForHostEvent(String string, OraclePooledConnection oraclePooledConnection) {
        boolean bl = false;
        if (string == oraclePooledConnection.dataSourceHostNameKey) {
            oraclePooledConnection.connectionMarkedDown = true;
            oraclePooledConnection.isHostDown = true;
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void cleanupFailoverConnections(boolean bl, boolean bl2, String string, String string2, String string3, String string4) {
        int n;
        OraclePooledConnection oraclePooledConnection = null;
        Object[] objectArray = this.checkedOutConnectionList.toArray();
        int n2 = this.checkedOutConnectionList.size();
        OraclePooledConnection[] oraclePooledConnectionArray = new OraclePooledConnection[n2];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            try {
                oraclePooledConnection = (OraclePooledConnection)objectArray[n];
                if ((!bl || string != null && string != oraclePooledConnection.dataSourceInstanceNameKey || string2 != oraclePooledConnection.dataSourceDbUniqNameKey) && (!bl2 || string3 != oraclePooledConnection.dataSourceHostNameKey)) continue;
                if (this.defaultUser != null && this.defaultUser.equalsIgnoreCase(oraclePooledConnection.pcUser) && oraclePooledConnection.cachedConnectionAttributes != null && oraclePooledConnection.cachedConnectionAttributes.isEmpty()) {
                    ++this.defaultUserPreFailureSize;
                }
                this.checkedOutConnectionList.removeElement(oraclePooledConnection);
                this.abortConnection(oraclePooledConnection);
                oraclePooledConnection.isHostDown = true;
                oraclePooledConnectionArray[n3++] = oraclePooledConnection;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (n = 0; n < n3; ++n) {
            try {
                this.closeCheckedOutConnection(oraclePooledConnectionArray[n], false);
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.checkedOutConnectionList.size() < n2 && this.cacheConnectionWaitTimeout > 0) {
            this.notifyAll();
        }
        try {
            this.doForEveryCachedConnection(2);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.databaseInstancesList != null && (n2 = this.databaseInstancesList.size()) > 0) {
            LinkedList linkedList = this.databaseInstancesList;
            synchronized (linkedList) {
                OracleDatabaseInstance oracleDatabaseInstance = null;
                objectArray = this.databaseInstancesList.toArray();
                for (int i = 0; i < n2; ++i) {
                    oracleDatabaseInstance = (OracleDatabaseInstance)objectArray[i];
                    if (oracleDatabaseInstance.databaseUniqName != string2 || oracleDatabaseInstance.instanceName != string) continue;
                    if (oracleDatabaseInstance.flag <= 3) {
                        this.dbInstancePercentTotal -= oracleDatabaseInstance.percent;
                    }
                    this.databaseInstancesList.remove(oracleDatabaseInstance);
                }
            }
        }
    }

    void zapRLBInfo() {
        this.databaseInstancesList.clear();
    }

    protected synchronized void closeAndRemovePooledConnection(OraclePooledConnection oraclePooledConnection) throws SQLException {
        if (oraclePooledConnection != null) {
            if (oraclePooledConnection.isHostDown) {
                this.abortConnection(oraclePooledConnection);
            }
            this.actualPooledConnectionClose(oraclePooledConnection);
            this.removeCacheConnection(oraclePooledConnection);
        }
    }

    private void abortConnection(OraclePooledConnection oraclePooledConnection) {
        try {
            ((OracleConnection)oraclePooledConnection.getPhysicalHandle()).abort();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualPooledConnectionClose(OraclePooledConnection oraclePooledConnection) throws SQLException {
        int n = 0;
        if (this.databaseInstancesList != null && (n = this.databaseInstancesList.size()) > 0) {
            LinkedList linkedList = this.databaseInstancesList;
            synchronized (linkedList) {
                OracleDatabaseInstance oracleDatabaseInstance = null;
                for (int i = 0; i < n; ++i) {
                    oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i);
                    if (oracleDatabaseInstance.databaseUniqName != oraclePooledConnection.dataSourceDbUniqNameKey || oracleDatabaseInstance.instanceName != oraclePooledConnection.dataSourceInstanceNameKey) continue;
                    if (oracleDatabaseInstance.numberOfConnectionsCount <= 0) break;
                    --oracleDatabaseInstance.numberOfConnectionsCount;
                    break;
                }
            }
        }
        try {
            oraclePooledConnection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected int getCacheTimeToLiveTimeout() {
        return this.cacheTimeToLiveTimeout;
    }

    protected int getCacheInactivityTimeout() {
        return this.cacheInactivityTimeout;
    }

    protected int getCachePropertyCheckInterval() {
        return this.cachePropertyCheckInterval;
    }

    protected int getCacheAbandonedTimeout() {
        return this.cacheAbandonedConnectionTimeout;
    }

    private synchronized void processConnectionCacheCallback() throws SQLException {
        float f = (float)this.cacheMaxLimit / 100.0f;
        int n = (int)((float)this.cacheLowerThresholdLimit * f);
        this.releaseBasedOnPriority(1024, n);
        if (this.cacheSize < n) {
            this.releaseBasedOnPriority(512, n);
        }
    }

    private void releaseBasedOnPriority(int n, int n2) throws SQLException {
        Object[] objectArray = this.checkedOutConnectionList.toArray();
        for (int i = 0; i < objectArray.length && this.cacheSize < n2; ++i) {
            OracleConnectionCacheCallback oracleConnectionCacheCallback;
            OraclePooledConnection oraclePooledConnection = (OraclePooledConnection)objectArray[i];
            OracleConnection oracleConnection = null;
            if (oraclePooledConnection != null) {
                oracleConnection = (OracleConnection)oraclePooledConnection.getLogicalHandle();
            }
            if (oracleConnection == null || (oracleConnectionCacheCallback = oracleConnection.getConnectionCacheCallbackObj()) == null || oracleConnection.getConnectionCacheCallbackFlag() != 2 && oracleConnection.getConnectionCacheCallbackFlag() != 4 || n != oracleConnection.getConnectionReleasePriority()) continue;
            Object object = oracleConnection.getConnectionCacheCallbackPrivObj();
            oracleConnectionCacheCallback.releaseConnection(oracleConnection, object);
        }
    }

    private synchronized void processConnectionWaitTimeout(long l) throws SQLException {
        try {
            this.wait(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void processInactivityTimeout(OraclePooledConnection oraclePooledConnection) throws SQLException {
        long l = oraclePooledConnection.getLastAccessedTime();
        long l2 = System.currentTimeMillis();
        if (this.getTotalCachedConnections() > this.cacheMinLimit && l2 - l > (long)(this.cacheInactivityTimeout * 1000)) {
            this.closeAndRemovePooledConnection(oraclePooledConnection);
        }
    }

    private void cleanupTimeoutThread() throws SQLException {
        if (this.timeoutThread != null) {
            this.timeoutThread.timeToLive = false;
            if (this.timeoutThread.isSleeping) {
                this.timeoutThread.interrupt();
            }
            this.timeoutThread = null;
        }
    }

    protected void purgeCacheConnections(boolean bl) {
        try {
            if (bl) {
                this.doForEveryCheckedOutConnection(1);
            }
            this.doForEveryCachedConnection(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDatabaseInstance(String string, String string2, int n, int n2) {
        if (this.databaseInstancesList == null) {
            this.databaseInstancesList = new LinkedList();
        }
        LinkedList linkedList = this.databaseInstancesList;
        synchronized (linkedList) {
            int n3 = this.databaseInstancesList.size();
            boolean bl = false;
            for (int i = 0; i < n3; ++i) {
                OracleDatabaseInstance oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i);
                if (oracleDatabaseInstance.databaseUniqName != string || oracleDatabaseInstance.instanceName != string2) continue;
                oracleDatabaseInstance.percent = n;
                oracleDatabaseInstance.flag = n2;
                bl = true;
                break;
            }
            if (!bl) {
                OracleDatabaseInstance oracleDatabaseInstance = new OracleDatabaseInstance(string, string2);
                oracleDatabaseInstance.percent = n;
                oracleDatabaseInstance.flag = n2;
                this.databaseInstancesList.add(oracleDatabaseInstance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDatabaseInstances() throws SQLException {
        OracleDatabaseInstance oracleDatabaseInstance = null;
        LinkedList<OracleDatabaseInstance> linkedList = new LinkedList<OracleDatabaseInstance>();
        if (this.databaseInstancesList != null) {
            LinkedList linkedList2 = this.databaseInstancesList;
            synchronized (linkedList2) {
                int n;
                int n2 = 0;
                boolean bl = false;
                this.useGoodGroup = false;
                int n3 = this.databaseInstancesList.size();
                for (n = 0; n < n3; ++n) {
                    oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(n);
                    if (oracleDatabaseInstance.flag > 3) continue;
                    n2 += oracleDatabaseInstance.percent;
                }
                if (n2 > 0) {
                    this.dbInstancePercentTotal = n2;
                    this.useGoodGroup = true;
                }
                if (n3 > 1) {
                    for (n = 0; n < n3; ++n) {
                        oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(n);
                        this.countTotal += oracleDatabaseInstance.attemptedConnRequestCount;
                    }
                    if (this.countTotal > n3 * 1000) {
                        for (n = 0; n < n3; ++n) {
                            oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(n);
                            float f = (float)oracleDatabaseInstance.attemptedConnRequestCount / (float)this.countTotal;
                            float f2 = (float)oracleDatabaseInstance.numberOfConnectionsCount / (float)this.getTotalCachedConnections();
                            if (!(f2 > f * 2.0f)) continue;
                            if ((int)((double)oracleDatabaseInstance.numberOfConnectionsCount * 0.25) >= 1) {
                                linkedList.add(oracleDatabaseInstance);
                            }
                            bl = true;
                        }
                        if (bl) {
                            for (n = 0; n < n3; ++n) {
                                oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(n);
                                oracleDatabaseInstance.attemptedConnRequestCount = 0;
                            }
                            bl = false;
                        }
                    }
                }
            }
            if (linkedList.size() > 0) {
                this.instancesToRetireList = linkedList;
                if (this.gravitateCacheThread != null) {
                    try {
                        this.gravitateCacheThread.interrupt();
                        this.gravitateCacheThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.gravitateCacheThread = null;
                }
                this.gravitateCacheThread = new OracleGravitateConnectionCacheThread(this);
                this.cacheManager.checkAndStartThread(this.gravitateCacheThread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gravitateCache() {
        if (this.instancesToRetireList != null) {
            LinkedList linkedList = this.instancesToRetireList;
            synchronized (linkedList) {
                int n = this.instancesToRetireList.size();
                for (int i = 0; i < n; ++i) {
                    this.instanceToRetire = (OracleDatabaseInstance)this.instancesToRetireList.get(i);
                    this.retireConnectionsCount = (int)((double)this.instanceToRetire.numberOfConnectionsCount * 0.25);
                    try {
                        this.doForEveryCachedConnection(24);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    if (this.retireConnectionsCount <= 0) continue;
                    try {
                        this.doForEveryCheckedOutConnection(24);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        }
        this.retireConnectionsCount = 0;
        this.instanceToRetire = null;
        this.instancesToRetireList = null;
        this.countTotal = 0;
    }

    protected void cleanupRLBThreads() {
        if (this.gravitateCacheThread != null) {
            try {
                this.gravitateCacheThread.interrupt();
                this.gravitateCacheThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.gravitateCacheThread = null;
        }
        if (this.runtimeLoadBalancingThread != null) {
            try {
                this.runtimeLoadBalancingThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.runtimeLoadBalancingThread = null;
        }
    }
}

