/* $Id: trigger.h,v 1.5 2005/05/12 19:29:35 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/src/tfire.h,v 1.2 2004/12/16 11:27:24 flaw
 * imp/src/tfire.h,v 1.1 2004/10/10 10:34:01 flaw
 *//*
 * Trigger pull interface, inherits from ProceduralCall: call/pl.h
 */
#ifndef PyPg_call_trigger_H
#define PyPg_call_trigger_H 0
#ifdef __cplusplus
extern "C" {
#endif

#define PyPgTriggerPull_HEAD \
	PyPgProceduralCall_HEAD \
	PyObj tp_oid; \
	PyObj tp_old; \
	PyObj tp_new; \
	TriggerEvent tp_event;

typedef struct PyPgTriggerPull {
	PyPgTriggerPull_HEAD
} * PyPgTriggerPull;

extern PyTypeObject PyPgTriggerPull_Type;
PyObj PyPgTriggerPull_Initialize(PyObject *, FunctionCallInfo);

#define PyPgTriggerPull_NEW() \
	(PyObject *) PyPgTriggerPull_Type.tp_alloc(&PyPgTriggerPull_Type, 0)
#define PyPgTriggerPull_New(FCI) \
	PyPgTriggerPull_Initialize(PyPgTriggerPull_NEW(), FCI)

#define PyPgTriggerPull(SELF)	((PyPgTriggerPull) SELF)

#define PyPgTriggerPull_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPgTriggerPull_Type))
#define PyPgTriggerPull_CheckExact(SELF) \
	((SELF)->ob_type == &PyPgTriggerPull_Type)

#define PyPgTriggerPull_FetchOid(SELF) \
	(PyPgTriggerPull(SELF)->tp_oid)
#define PyPgTriggerPull_FetchOld(SELF) \
	(PyPgTriggerPull(SELF)->tp_old)
#define PyPgTriggerPull_FetchNew(SELF) \
	(PyPgTriggerPull(SELF)->tp_new)
#define PyPgTriggerPull_FetchEvent(SELF) \
	(PyPgTriggerPull(SELF)->tp_event)

#define PyPgTriggerPull_FixOid(SELF, OB) \
	(PyPgTriggerPull_FetchOid(SELF) = OB)
#define PyPgTriggerPull_FixOld(SELF, OB) \
	(PyPgTriggerPull_FetchOld(SELF) = OB)
#define PyPgTriggerPull_FixNew(SELF, OB) \
	(PyPgTriggerPull_FetchNew(SELF) = OB)
#define PyPgTriggerPull_FixEvent(SELF, OB) \
	(PyPgTriggerPull_FetchEvent(SELF) = OB)

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_call_trigger_H */
/*
 * vim: ts=3:sw=3:noet:
 */
