/* $Id: query.h,v 1.6 2005/08/17 05:05:59 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/src/query.h,v 1.1.1.1 2004/12/16 00:32:18 flaw
 * imp/src/query.h,v 1.4 2004/10/17 07:18:02 flaw
 * if/src/query.h,v 1.2 2004/08/06 07:56:32 flaw
 *//*
 * Postgres Query Interface
 */
#ifndef PyPg_query_H
#define PyPg_query_H 0
#ifdef __cplusplus
extern "C" {
#endif

typedef struct PyPgQuery {
	PyObject_HEAD
	PyObj q_str;
	PyObj q_argtypes;
	Node *q_rpt;

	TransactionId q_xid;
	SubTransactionId q_sxid;
	CommandId q_cid;

	MemoryContext q_context;
	List *q_queryl;
	List *q_planl;

	Oid q_lastoid;
} * PyPgQuery;

extern PyTypeObject PyPgQuery_Type;
PyObj PyPgQuery_Initialize(PyObj, PyObj);

#define PyPgQuery_NEW() ((PyObj) PyPgQuery_Type.tp_alloc(&PyPgQuery_Type, 0))
#define PyPgQuery_New(STR) PyPgQuery_Initialize(PyPgQuery_NEW(), STR)

#define PyPgQuery(SELF) ((PyPgQuery) SELF)

#define PyPgQuery_FetchString(SELF) (PyPgQuery(SELF)->q_str)
#define PyPgQuery_FetchArgTypes(SELF) (PyPgQuery(SELF)->q_argtypes)
#define PyPgQuery_FetchRawParseTree(SELF) (PyPgQuery(SELF)->q_rpt)
#define PyPgQuery_FetchMemoryContext(SELF) (PyPgQuery(SELF)->q_context)
#define PyPgQuery_FetchQueryList(SELF) (PyPgQuery(SELF)->q_queryl)
#define PyPgQuery_FetchPlanList(SELF) (PyPgQuery(SELF)->q_planl)
#define PyPgQuery_FetchLastOid(SELF) (PyPgQuery(SELF)->q_lastoid)
#define PyPgQuery_FetchTransactionId(SELF) (PyPgQuery(SELF)->q_xid)
#define PyPgQuery_FetchSubTransactionId(SELF) (PyPgQuery(SELF)->q_sxid)
#define PyPgQuery_FetchCommandId(SELF) (PyPgQuery(SELF)->q_cid)

#define PyPgQuery_FixString(SELF, STR) (PyPgQuery(SELF)->q_str = STR)
#define PyPgQuery_FixArgTypes(SELF, ATS) (PyPgQuery(SELF)->q_argtypes = ATS)
#define PyPgQuery_FixRawParseTree(SELF, RPT) (PyPgQuery(SELF)->q_rpt = RPT)
#define PyPgQuery_FixMemoryContext(SELF, CX) (PyPgQuery(SELF)->q_context = CX)
#define PyPgQuery_FixQueryList(SELF, QL) (PyPgQuery(SELF)->q_queryl = QL)
#define PyPgQuery_FixPlanList(SELF, PL) (PyPgQuery(SELF)->q_planl = PL)
#define PyPgQuery_FixLastOid(SELF, LO) (PyPgQuery(SELF)->q_lastoid = LO)
#define PyPgQuery_FixTransactionId(SELF, XID) \
	(PyPgQuery_FetchTransactionId(SELF) = XID)
#define PyPgQuery_FixSubTransactionId(SELF, SXID) \
	(PyPgQuery_FetchSubTransactionId(SELF) = SXID)
#define PyPgQuery_FixCommandId(SELF, CID) PyPgQuery(SELF)->q_cid = CID

#define PyPgQuery_IsPrepared(SELF) \
	(PyPgQuery_FetchMemoryContext(SELF) != NULL)

#define PyPgQuery_IsCurrent(SELF) \
	TransactionIdIsCurrentTransactionId(PyPgQuery_FetchTransactionId(SELF))

#define PyPgQuery_FetchSTRING(SELF) \
	PyString_AS_STRING(PyPgQuery_FetchString(SELF))

#define PyPgQuery_SwitchContext(SELF) \
	MemoryContextSwitchTo(PyPgQuery_FetchMemoryContext(SELF))
#define PyPgQuery_ResetContext(SELF) \
	MemoryContextReset(PyPgQuery_FetchMemoryContext(SELF))

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_query_H */
/*
 * vim: ts=3:sw=3:noet:
 */
