/* $Id: tupledesc.h,v 1.5 2005/05/12 19:29:35 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/src/tupd.h,v 1.1.1.1 2004/12/16 00:32:18 flaw
 * imp/src/tupd.h,v 1.1.1.1 2004/10/04 01:52:56 flaw
 * if/src/tupd.h,v 1.22 2004/09/28 15:43:58 flaw
 *//*
 * Python Postgres Tuple Descriptor declaration
 */
#ifndef PyPg_tupledesc_H
#define PyPg_tupledesc_H 0
#ifdef __cplusplus
extern "C" {
#endif

#define PyPgTupleDesc_HEAD \
	PyObject_HEAD				\
	TupleDesc td_desc;

typedef struct PyPgTupleDesc {
	PyPgTupleDesc_HEAD
} * PyPgTupleDesc;

extern PyTypeObject PyPgTupleDesc_Type;
PyObj PyPgTupleDesc_Initialize(PyObj, TupleDesc);

#define PyPgTupleDesc_NEW() \
	((PyObj) PyPgTupleDesc_Type.tp_alloc(&PyPgTupleDesc_Type, 0))
#define PyPgTupleDesc_New(TD) \
	(PyPgTupleDesc_Initialize(PyPgTupleDesc_NEW(), TD))

AttrNumber AttrNumber_FromTupleDescAndNameStr(TupleDesc, char *);
AttrNumber AttrNumber_FromTupleDescAndPyObject(TupleDesc, PyObj);
PyObj TupleDesc_Keys(TupleDesc);
bool TupleDesc_HasKey(TupleDesc, const char *);
HeapTuple PyPgTupleDesc_AttTuple(PyObj, long);
AttrNumber PyPgTupleDesc_AttOffset(PyObj, PyObj);
PyObj PyPgTupleDesc_FromRelationId(Oid);

#define PyPgTupleDesc(SELF) ((PyPgTupleDesc) SELF)

#define PyPgTupleDesc_Check(SELF) \
	(PyObject_TypeCheck(SELF, &PyPgTupleDesc_Type))
#define PyPgTupleDesc_CheckExact(SELF) \
	(SELF->ob_type == &PyPgTupleDesc_Type)

#define PyPgTupleDesc_FixTupleDesc(SELF, TD) \
	(PyPgTupleDesc(SELF)->td_desc = TD)
#define PyPgTupleDesc_FetchTupleDesc(SELF) \
	(PyPgTupleDesc(SELF)->td_desc)

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_tupledesc_H */
/*
 * vim: ts=3:sw=3:noet:
 */
