/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "dbmastermanagerref.h"

	/**
 	 * Constructor
   */		
	DBMasterManagerRef::DBMasterManagerRef()
	{
		m_poDBMasterMgr = 0;	// set to null pointer
	} // end constructor
	
	/**
	 * Destructor
	 */
	DBMasterManagerRef::~DBMasterManagerRef()
	{
		// nothing to do, don't destroy Master manager it may be referenced by someone else!
	} // end destructor
	
	/**
 	 * Used to set the database Master manager.
 	 * @param poDBMasterMgr	a pointer to the database Master manager
   */			    	
	void DBMasterManagerRef::setDBMasterManager(DBMasterManager * poDBMasterMgr)
	{
		m_poDBMasterMgr = poDBMasterMgr;
	} // end setDBMasterManager
	
	/**
	 * Used to get the database Master manager.
	 * @return a pointer to the database Master manager
	 */
	DBMasterManager * DBMasterManagerRef::getDBMasterManager()
	{
		return m_poDBMasterMgr;
	} // end getDBMasterManager


