/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DBTYPE_H
#define DBTYPE_H

#include <string>

/**
 * This class is used to represent a database type.
 */
class DBType
{

protected:
	long m_lTypeOid;
	string m_strTypeName;
				
public:
	
	/**
 	 * Constructor
   */		
	DBType();

	/**
 	 * Copy Constructor
 	 * Implemented for STL.
   */		
	DBType(const DBType & roDBType);

	/**
 	 * Assignment operator
 	 * Implemented for STL.
   */		
	DBType & operator=(const DBType & roDBType);
			
	/**
 	 * Destructor
   */		
	~DBType();
	
	/**
	 * This function will clear out variables in this object, so that it can be used again.
	 */
	void clear();
	
	/**
 	 * Used to set the type name.
   */			    	
	void setTypeName(const string &rstrTypeName);

	/**
 	 * Used to retrieve the type name.
   */			    			
	const string & getTypeName() const;

	/**
 	 * Used to set the type oid.
   */			    	
	void setTypeOid(long lTypeOid);

	/**
 	 * Used to retrieve the type oid.
   */			    			
	long getTypeOid() const;
	
		
};

#endif

