/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "xmlparseexception.h"

	/**
 	 * Constructor
 	 *
 	 * @param	rstrFileName	used to indicate the file name that was parsed
 	 * @param	rstrXmlText	used to indicate what the exception was 	 	
 	 * @param	rstrDescription	used to indicate what the exception was
 	 * @param	rstrClassName		the class that the exception was initially thrown from
 	 * @param	rstrMethodName		the method that the exception was initially thrown from
   */		
	XmlParseException::XmlParseException(const string & rstrFileName, const string & rstrXmlText,
			const string &rstrDescription, const string &rstrClassName, const string &rstrMethodName)
		: VPSystemException(rstrDescription, rstrClassName, rstrMethodName)
	{
		m_strFileName = rstrFileName;
		m_strXmlText = rstrXmlText;	
	} // end constructor
			
	/**
 	 * Copy Constructor
 	 *
 	 * @param	roException			another exception to copy
   */		
	XmlParseException::XmlParseException(const XmlParseException &roException)
		: VPSystemException(roException)
	{
		m_strFileName = roException.m_strFileName;
		m_strXmlText = roException.m_strXmlText;			
	} // end copy constructor

	/**
 	 * Assignment operator
 	 *
 	 * @param	roException			another exception to assign from
   */		
	XmlParseException & XmlParseException::operator=(const XmlParseException &roException)
	{
		VPSystemException::operator=(roException);
		m_strFileName = roException.m_strFileName;
		m_strXmlText = roException.m_strXmlText;			
		return (*this);		
	} // end operator=
				
	/**
	 * This function is used to retrieve the file name
	 * @return	the file name
	 */
	const string & XmlParseException::getFileName() const
	{
		return m_strFileName;
	} // end getFileName			

	/**
	 * This function is used to retrieve the xml text
	 * @return	the xml text
	 */
	const string & XmlParseException::getXmlText() const
	{
		return m_strXmlText;
	} // end getXmlText			
