/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "droptableform.h"
#include "../common/infodialogs.h"
#include "tablelistviewitem.h"
#include "tableitempopup.h"
#include "../../utils/debugger.h"
#include <qlabel.h>
			
	/**
 	 * Constructor
   */		
  DropTableForm::DropTableForm(QWidget* pqoParent, const DBConnection & roDBConn, const string & rstrTableName)
  	: UicDropTableForm(pqoParent)
	{
		m_oDBConn = roDBConn;		// copies all connection properties			
		m_strTableName = rstrTableName;
		// set the question
		QString qstrQuestion = "Are you sure you want to drop the table '";
		qstrQuestion += m_strTableName.c_str();
		qstrQuestion += "'?";
		m_pqlblQuestion->setText(qstrQuestion);
	} // end constructor

  /**
   * Destructor
   */
  DropTableForm::~DropTableForm()
  {
		string strMethodName = "DropTableForm::~DropTableForm";
		Debugger::entered(strMethodName);
		Debugger::exited(strMethodName);
  } // end destructor
		
	/**
	 * This method is used to drop a table.
	 */
	void DropTableForm::dropTableSchema()
	{
  	// setup new database connection
		// do connection
		try
		{
			m_oDBConn.connect();
		} // end try to connect
		catch (DBConnectionException e)
		{
			// report error to user
			InfoDialogs::infoDBConnectionException(this, e);
			return;			
		} // end catch exception
				
		m_oDBTableMgr.setDBConnection(&m_oDBConn);	
		
		// drop table
		try
		{
			m_oDBTableMgr.dropTableSchema(m_strTableName);
		} // end try to delete
		catch (SQLException e)
		{
			// report error to user
			InfoDialogs::infoSQLException(this, e);
			return;						
		} // end catch exception
		
		// delete the list view item too !
		TableListViewItem * poTableItem = ((TableItemPopup*)parentWidget())->getTableListViewItem();
		delete poTableItem;
	} // end dropTableSchema
	

	/**
	 * This method is used to close the table.
	 */
	void DropTableForm::closeForm()
	{
		close(true);
	} // end closeForm
