/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef APPLICATIONSETTINGS_H
#define APPLICATIONSETTINGS_H

#include <qstring.h>
#include "../exceptions/openfileexception.h"
#include "../exceptions/xmlparseexception.h"

/**
 * This class is used to store the application settings.
 */
class ApplicationSettings
{

protected:
	QString m_qstrDatabaseSettingsFileName;
				
public:

	/**
 	 * Constructor
   */		
	ApplicationSettings();
	
	/**
 	 * Destructor
   */		
	~ApplicationSettings();

	/**
	 * Gets all the application settings from the file.
	 */
	void readSettingsFromFile() throw (OpenFileException, XmlParseException);
	
	/**
	 * Returns the filename of where the database settings are.
	 */
	const QString getDatabaseSettingsFileName() const;
		

};

#endif

