/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DBMASTERMANAGERREF_H
#define DBMASTERMANAGERREF_H

#include "dbmastermanager.h"

/**
 * This class is to be inherited by other classes that require a reference to
 * a DB master manager.
 */
class DBMasterManagerRef
{
protected:
	DBMasterManager * m_poDBMasterMgr;
				
public:
	
	/**
 	 * Constructor
   */		
	DBMasterManagerRef();
	
	/**
	 * Destructor
	 */
	~DBMasterManagerRef();
	
	/**
 	 * Used to set the database master manager.
 	 * @param poDBMasterMgr	a pointer to the database master manager
   */			    	
	void setDBMasterManager(DBMasterManager * poDBMasterMgr);
	
	/**
	 * Used to get the database master manager.
	 * @return a pointer to the database master manager
	 */
	DBMasterManager * getDBMasterManager();


};


#endif

