/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "dbtableschema.h"
	
	/**
 	 * Constructor
   */		
	DBTableSchema::DBTableSchema()
	{
		m_strTableName = "";
	} // end constructor
	
	/**
 	 * Destructor
   */		
	DBTableSchema::~DBTableSchema()
	{
	} // end destructor

	/**
	 * Used to clear the table schema contents.
	 * This should be called when the table schema needs to be reused.
	 */
	void DBTableSchema::clear()
	{
		m_strTableName = "";
		m_voTableColumns.clear();
	} // end clear
		
	/**
 	 * Used to set the table name.
   */			    	
	void DBTableSchema::setTableName(const string &rstrTableName)
	{
		m_strTableName = rstrTableName;
	} // end setTableName

	/**
 	 * Used to retrieve the table name.
   */			    			
	const string & DBTableSchema::getTableName() const
	{
		return m_strTableName;
	} // end getTableName

	/**
 	 * Used to get the number of columns.
   */			    			
	int DBTableSchema::getNumberOfColumns() const
	{
		return m_voTableColumns.size();
	} // end getNumberOfColumns
	
	/**
 	 * Used to add a column. This will append the column to the end of the list.
   */			    						
	void DBTableSchema::addColumn(const DBTableColumn & roDBTableColumn)
	{
		m_voTableColumns.push_back(roDBTableColumn);
	} // end addColumn

	/**
 	 * Used to retrieve a column.
   */			    			
	const DBTableColumn & DBTableSchema::getColumn(int nFieldIndex) const throw (IndexOutOfRangeException)
	{
		// check if index valid
		if (nFieldIndex <0 || nFieldIndex >= getNumberOfColumns())
		{
			throw IndexOutOfRangeException("Index out of range.", "DBTableSchema", "getFieldComment");			
		} // end if false
		
		return m_voTableColumns[nFieldIndex];	
	} // end getColumn
					
