/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DATABASECONNECTFORM_H
#define DATABASECONNECTFORM_H

#include "uic_databaseconnectform.h"
#include "databaseitempopup.h"

/**
 * This prompts the user for database connection properties.
 */
class DatabaseConnectForm: public UicDatabaseConnectForm
{
	Q_OBJECT
protected:
	bool m_bAutoConnect;
				
public:
	
	/**
 	 * Constructor
   */		
  DatabaseConnectForm(QWidget* pqoParent, bool bAutoConnect = false, bool bModal = false);

public slots:
	/**
	 * This method is used to save connection properties.
	 */
	void saveConnectDetails();

	/**
	 * This method is used to close the form.
	 */
	void closeForm();
};


#endif


