/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef GROUPITEMPOPUP_H
#define GROUPITEMPOPUP_H

#include <qpopupmenu.h>
#include <qstring.h>
#include "grouplistviewitem.h"

/**
 * This popup menu is fired when a user right clicks on a group item in the list viewer.
 */
class GroupItemPopup: public QPopupMenu
{
	Q_OBJECT
	
protected:
	GroupListViewItem * m_poGroupListViewItem;	
	
public:
	/**
	 * Constructor
	 */
	GroupItemPopup(QWidget *pqoParent, GroupListViewItem *poGroupListViewItem);

	/**
	 * Used to get a reference to the group item that this popup was generated from.
	 */
	GroupListViewItem * getGroupListViewItem() const;
	
protected slots:
	/**
 	 * This slot is called by the popup menu itself when new server is called
   */	
	void createServerItem();
	
	/**
 	 * This slot is called by the popup menu itself when edit properties is selected.
   */	
	void editProperties();
	
	/**
	 * This slot is called by the popup menu itself when delete group is selected.
	 */
	void deleteGroupItem();
	
};


#endif

