/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "grouplistviewitem.h"
#include "serverlistviewitem.h"
#include "groupitempopup.h"
#include "../utils/debugger.h"
#include "../utils/stringutils.h"

#include <iostream.h>

	GroupListViewItem::GroupListViewItem(QListView *pqoListView)
		: BaseListViewItem(pqoListView)
	{
		// testing code
		setGroupName("");
		setGroupDescription("");		
		updateDescription();
		initChildren();
	} // end constructor

	/**
	 * This method is used to set the group name.
	 */
	void GroupListViewItem::setGroupName(const string &rstrGroupName)
	{
		m_strGroupName = rstrGroupName;
	} // end setGroupName

	/**
	 * This method is used to get the group name.
	 */
	const string & GroupListViewItem::getGroupName() const
	{
		return m_strGroupName;
	} // end getGroupName
	
	/**
	 * This method is used to set the group description.
	 */
	void GroupListViewItem::setGroupDescription(const string &rstrGroupDescription)
	{
		m_strGroupDescription = rstrGroupDescription;
	} // end setGroupDescription
	
	/**
	 * This method is used to get the group description.
	 */
	const string & GroupListViewItem::getGroupDescription() const
	{
		return m_strGroupDescription;
	} // end getGroupDescription

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	void GroupListViewItem::showRightPressedMenu(const QPoint & rqoLocation, int nColumn)
	{
		
		// check to see if menu has been brought up previously
		if (m_pqoPopupMenu == 0)
		{
			m_pqoPopupMenu = new GroupItemPopup(listView(), this);
		} // end if popup already created
		m_pqoPopupMenu->popup(rqoLocation);
		
	} // end showRightPressedMenu
	
	/**
 	 * Used to update the description.
   */			    	
	void GroupListViewItem::updateDescription()
	{
		string strDescription = "<h1>Group</h1><hr><p><strong>Name</strong><br>" +
														StringUtils::htmlstr(getGroupName()) +
														"</p><p><strong>Description</strong><br>" +
														StringUtils::htmlstr(getGroupDescription()) +
														"</p>";
														
		m_qstrDescription = strDescription.c_str();		// convert over	
	} // end updateDescription
		
	/**
 	 * Used to create all the first level children of the current item.
   */			    						
	void GroupListViewItem::initChildren()
	{	
		
		string strMethodName = "GroupListViewItem::initChildren";
		
		Debugger::exited(strMethodName);
				
		Debugger::exited(strMethodName);				
	} // end initChildren
	