/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef TRIGGERLISTVIEWITEM_H
#define TRIGGERLISTVIEWITEM_H

#include "../../baselistviewitem.h"
#include "../../../dataaccess/tables/triggers/dbtrigger.h"
#include "../../../dataaccess/dbmastermanagerref.h"

/**
 * This list view item is used to represent a database table trigger.
 */
class TriggerListViewItem: public BaseListViewItem, public DBTrigger, public DBMasterManagerRef
{
				
public:
	
	/**
 	 * Constructor
   */		
	TriggerListViewItem(QListViewItem *pqoListViewItem);
	
	/**
 	 * Constructor
   */			
	TriggerListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem);	

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	virtual void showRightPressedMenu(const QPoint & rqoLocation, int nColumn);
			
	/**
 	 * Used to update the description.
   */			    	
	void updateDescription();
	
};


#endif

