/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "converter.h"

	/**
 	 * Used to convert a long into a string.
 	 * @param		nInput	the long to convert
 	 * @return	the long converted into a string
   */			    	
	string Converter::longToString(long lInput)
	{
		long lDiv = lInput;
		int nRem = 0;
		bool bIsNegative = false;
		string strOutput = "";
		if (lInput == 0)
		{
			strOutput = "0";
			return strOutput;
		} // end if input is 0
		// for negative numbers change to positive and process as positive number
		if (lInput < 0)
		{
			lDiv = -lDiv;	// change to positive
			bIsNegative = true;
		} // end if input is less than 0
		// loop through and get one digit at a time
		while (lDiv > 0)
		{
			nRem = lDiv % 10;
			lDiv = lDiv / 10;
			char cDigit = '0' + nRem;
			strOutput = cDigit + strOutput;
		} // end while more digits left
		return strOutput;
	} // end convertIntegerToString
	
	/**
	 * Used to convert a string into an long.
	 * @param		rstrInput the string to be converted
	 * @return	the long version of this string.
	 */
	long Converter::stringToLong(const string & rstrInput)
	{
		// lets go backwards through string and add accordingly
		long lOutput = 0;
		int nCurrentPower = 1;
		for (int nIdx = rstrInput.size() - 1; nIdx >= 0; nIdx--)
		{
			// check for negative
			if (nIdx == 0)
			{
				if (rstrInput[0] == '-')
				{
					lOutput *= -1;
					break;
				} // end if negative
			} // end if negative
			int nDigit = rstrInput[nIdx] - '0';
			lOutput += nCurrentPower * nDigit;
			nCurrentPower *= 10;
		} // end for more chars
		return lOutput;
	} // end stringToLong		
		
	/**
 	 * Used to convert an integer into a string.
 	 * @param		nInput	the integer to convert
 	 * @return	the integer converted into a string
   */			    	
	string Converter::intToString(int nInput)
	{
		int nDiv = nInput;
		int nRem = 0;
		bool bIsNegative = false;
		string strOutput = "";
		if (nInput == 0)
		{
			strOutput = "0";
			return strOutput;
		} // end if input is 0
		// for negative numbers change to positive and process as positive number
		if (nInput < 0)
		{
			nDiv = -nDiv;	// change to positive
			bIsNegative = true;
		} // end if input is less than 0
		// loop through and get one digit at a time
		while (nDiv > 0)
		{
			nRem = nDiv % 10;
			nDiv = nDiv / 10;
			char cDigit = '0' + nRem;
			strOutput = cDigit + strOutput;
		} // end while more digits left
		return strOutput;
	} // end convertIntegerToString
	
	/**
	 * Used to convert a string into an integer.
	 * @param		rstrInput the string to be converted
	 * @return	the integer version of this string.
	 */
	int Converter::stringToInt(const string & rstrInput)
	{
		// lets go backwards through string and add accordingly
		int nOutput = 0;
		int nCurrentPower = 1;
		for (int nIdx = rstrInput.size() - 1; nIdx >= 0; nIdx--)
		{
			// check for negative
			if (nIdx == 0)
			{
				if (rstrInput[0] == '-')
				{
					nOutput *= -1;
					break;
				} // end if negative
			} // end if negative
			int nDigit = rstrInput[nIdx] - '0';
			nOutput += nCurrentPower * nDigit;
			nCurrentPower *= 10;
		} // end for more chars
		return nOutput;
	} // end stringToInt		
		
