/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef CONVERTER_H
#define CONVERTER_H

#include <string>


/**
 * This class contains some conversion utilities.
 */
class Converter
{
				
public:	

	/**
 	 * Used to convert a long into a string.
 	 * @param		nInput	the long to convert
 	 * @return	the long converted into a string
   */			    	
	static string longToString(long lInput);

	/**
	 * Used to convert a string into a long.
	 * @param		rstrInput the string to be converted
	 * @return	the long version of this string.
	 */
	static long stringToLong(const string & rstrInput);		
			
	/**
 	 * Used to convert an integer into a string.
 	 * @param		nInput	the integer to convert
 	 * @return	the integer converted into a string
   */			    	
	static string intToString(int nInput);
	
	/**
	 * Used to convert a string into an integer.
	 * @param		rstrInput the string to be converted
	 * @return	the integer version of this string.
	 */
	static int stringToInt(const string & rstrInput);		
	
};


#endif

