<?php

/**************************************************
Program name:	ri_trig.inc.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	Get array of Referential Integrity Info
			
Create Date:	6/29/01 

Modified Date(s):	
**************************************************/


// Explode tgargs to find 
for ($i = 0; $i < $num_rows; $i++) {

	$temp = $sql_array[$i][tgargs];

	$temp_array = explode('\000',$temp);


	/*
	0-unnamed
	1-fk_table
	2-pk_table 
	3-MatchType (UNSPECIFIED, FULL, PARTIAL)
	4-fk_column (1st)
	5-pk_column (1st)
	6-fk_column (2st)
	7-pk_column (2st)
	..
	..
	*/

	// Create Array of tgargs (maximum 4 field primary key)
	$sql_array[$i][trigger_name] = $temp_array[0];
	$sql_array[$i][i_fk_table] = $temp_array[1];
	$sql_array[$i][i_pk_table] = $temp_array[2];
	$sql_array[$i][i_matchtype] = $temp_array[3];
	$sql_array[$i][i_fk1_column] = $temp_array[4];
	$sql_array[$i][i_pk1_column] = $temp_array[5];
	$sql_array[$i][i_fk2_column] = $temp_array[6];
	$sql_array[$i][i_pk2_column] = $temp_array[7];
	$sql_array[$i][i_fk3_column] = $temp_array[8];
	$sql_array[$i][i_pk3_column] = $temp_array[9];
	$sql_array[$i][i_fk4_column] = $temp_array[10];
	$sql_array[$i][i_pk4_column] = $temp_array[11];

// create if multiple primary/foreign keys, then combine them 

	// Inititialize fk and pk as first column, respectively
	$sql_array[$i][i_fk_column] = $sql_array[$i][i_fk1_column];
	$sql_array[$i][i_pk_column] = $sql_array[$i][i_pk1_column];

	// Build Foreign Key
	if (!empty($sql_array[$i][i_fk2_column])) {
		$sql_array[$i][i_fk_column] .= ", ".$sql_array[$i][i_fk2_column];

		if (!empty($sql_array[$i][i_fk3_column])) {
			$sql_array[$i][i_fk_column] .= ", ".$sql_array[$i][i_fk3_column];

			if (!empty($sql_array[$i][i_fk4_column])) {
				$sql_array[$i][i_fk_column] .= ", ".$sql_array[$i][i_fk4_column];			}
		}
	}

	// Build Primary Key
	if (!empty($sql_array[$i][i_pk2_column])) {
		$sql_array[$i][i_pk_column] .= ", ".$sql_array[$i][i_pk2_column];

		if (!empty($sql_array[$i][i_pk3_column])) {
			$sql_array[$i][i_pk_column] .= ", ".$sql_array[$i][i_pk3_column];

			if (!empty($sql_array[$i][i_fk4_column])) {
				$sql_array[$i][i_pk_column] .= ", ".$sql_array[$i][i_pk4_column];			}
		}
	}


	// Check if there is Cascade Actions for ON UPDATE or ON DELETE
	if ($sql_array[$i][$strFunction] == "RI_FKey_check_ins") {

		// Update
		if (substr($sql_array[$i+2][$strFunction],8,7) == "noactio") {
			$sql_array[$i][i_upd] = "NO ACTION";

		} elseif (substr($sql_array[$i+2][$strFunction],8,7) == "cascade") {
			$sql_array[$i][i_upd] = "CASCADE";

		} elseif (substr($sql_array[$i+2][$strFunction],8,7) == "restric") {
			$sql_array[$i][i_upd] = "RESTRICT";

		} elseif (substr($sql_array[$i+2][$strFunction],8,7) == "setnull") {
			$sql_array[$i][i_upd] = "SET NULL";

		} elseif (substr($sql_array[$i+2][$strFunction],8,7) == "setdefa") {
			$sql_array[$i][i_upd] = "SET DEFAULT";
		}

		// Delete
		if (substr($sql_array[$i+1][$strFunction],8,7) == "noactio") {
			$sql_array[$i][i_del] = "NO ACTION";

		} elseif (substr($sql_array[$i+1][$strFunction],8,7) == "cascade") {
			$sql_array[$i][i_del] = "CASCADE";

		} elseif (substr($sql_array[$i+1][$strFunction],8,7) == "restric") {
			$sql_array[$i][i_del] = "RESTRICT";

		} elseif (substr($sql_array[$i+1][$strFunction],8,7) == "setnull") {
			$sql_array[$i][i_del] = "SET NULL";

		} elseif (substr($sql_array[$i+1][$strFunction],8,7) == "setdefa") {
			$sql_array[$i][i_del] = "SET DEFAULT";
		}
	}

	// change matchtype "UNSPECIFIED" to NULL
#	if ($sql_array[$i][i_matchtype] == "UNSPECIFIED") {
#		$sql_array[$i][i_matchtype]="";
#	}

	//Build field in array with Table and Column(s) together  (ex. tbl1(id, id2))
	$sql_array[$i][i_pk] = $sql_array[$i][i_pk_table]."(".$sql_array[$i][i_pk_column].")";
	$sql_array[$i][i_fk] = $sql_array[$i][i_fk_table]."(".$sql_array[$i][i_fk_column].")";




// Make Extra Columns
	$Extra_Column_Value[$i][0] = "<a class=link href=tbl_properties.php?ntable=".$sql_array[$i][i_pk_table].">". $sql_array[$i][i_pk]."</a>";
	$Extra_Column_Value[$i][1] = "1----oo";
	$Extra_Column_Value[$i][2] = "<a class=link href=tbl_properties.php?ntable=".$sql_array[$i][i_fk_table].">". $sql_array[$i][i_fk]."</a>";
	$Extra_Column_Value[$i][3] = $sql_array[$i][i_upd];
	$Extra_Column_Value[$i][4] = $sql_array[$i][i_del];
	$Extra_Column_Value[$i][5] = $sql_array[$i][i_matchtype];

	$Extra_Heading_Value[0] = $strPrimaryKey;
	$Extra_Heading_Value[1] = $strOneToMany;
	$Extra_Heading_Value[2] = $strForeignKey;
	$Extra_Heading_Value[3] = $strUpdate;
	$Extra_Heading_Value[4] = $strDelete;
	$Extra_Heading_Value[5] = $strMatchType;

}  //end for loop


?>
