<?php

/**************************************************
Program name:	srvlist.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	List of Servers
			
Create Date:	6/29/01 

Modified Date(s):	
**************************************************/

session_start();
include ("$PATH_INCLUDE"."pre.inc.php");
include ("$PATH_INCLUDE"."links.inc.php");

//#$sql_get_version is SQL string to get version 
$sql_get = "SELECT version()";

// Connect and Execute the SQL statement ($sql_get)
include($PATH_INCLUDE."connect_exec.inc.php");

# get array of servers
if (count($cfgServers) > 1) {
	# Loop through cfgServers array to get name of host:port for each server
	reset($cfgServers);
	while(list($key, $val) = each($cfgServers)) {

		if ($val['local'] || !empty($val['host'])) {
			unset($host_display);
			if ($val['local']) {
				$host_display .= "local:" . $val['port'];
			} else {
				if (!empty($val['host'])) {
					$host_display .= $val['host'];
				}
				if (!empty($val['port'])) {
					$host_display .= ":" . $val['port'];
				}	
			}
			$aryServers[$host_display] = $key;
		}
	}

}

$num_rows = count($aryServers);
$num_columns = 6;

for ($i = 1; $i < ($num_rows + 1); $i++) {
	$j = $i - 1;
	$sql_array[$j][0] = $i;

	$sql_array[$j][3] = bool_YesNo($cfgServers[$i]['local']);
	$sql_array[$j][1] = "<a class=link href=dblist.php?nserver=".$i."&mode=newserver>".$cfgServers[$i]['host']."</a>";
	$sql_array[$j][2] = $cfgServers[$i]['port'];
	$sql_array[$j][4] = bool_YesNo($cfgServers[$i]['adv_auth']);
	if ($sql_array[$j][4] != $strYes) {
		$sql_array[$j][5] = $cfgServers[$i]['user'];
	} else {
		$sql_array[$j][5] = $strBasedOnLogin;
	}
}

#column_names
$SQL_Column_Show[0] = false;
#$column_name[0] = $strServer;
$column_name[1] = $strServer;
$column_name[2] = $strPort;
$column_name[3] = $strLocal;
$column_name[4] = $strLoginRequired;
$column_name[5] = $strUser;

// $web_page is template page that is displayed.
$web_page = webpage($PHP_SELF);


// Display Page
include($PATH_TEMPLATE.$cfgTemplate1);


?>
