<?php

/* $Id: lib.inc.php,v 1.2 2000/11/13 06:01:57 dwilson Exp $ */

if (!$LIB_INC) {

include("config.inc.php");

if ($cfgQuotes) {
	$cfgQuotes = "\"";
} else {
	unset($cfgQuotes);
}

// -----------------------------------------------------------------
// Function: 	pg_die($error, $query)
// Params:		$error -- The displayable error text.  Usually passed as pg_errormessage()
//				$query -- The query which was attempted
function pg_die($error = "", $query = "") {
	global $strError,$strMySQLSaid, $strBack, $sql_query, $HTTP_REFERER, $SCRIPT_FILENAME, $link, $db, $table, $cfgDebug, $server;
	
	echo "<b><font face=\"arial,helvetican,sans-serif\" color=\"red\">$strError - $SCRIPT_FILENAME</font></b><p>";
	if (empty($error)) {
		$error = pg_errormessage();
	}
	echo "<font face=\"arial,helvetican,sans-serif\" color=\"red\">", $strMySQLSaid . $error;
	if (empty($query)) {
		$query = $sql_query;
	}
	if (!empty($query)) {
		echo "<br>Your query: <br><b>",  nl2br(htmlentities($query)), "</b>";
	}
	echo "<br><a href=\"javascript:history.back()\">$strBack</a></font>";

	if ($cfgDebug) {
		echo "<br>Link: $link<br>DB: $db<br>Table: $table<br>Server: $server";
	}

	echo "<p>";
	include ("footer.inc.php");
	exit;
}

// -----------------------------------------------------------------
// Function: 	pre_query($query)
// Params:		$query -- Query String to prepare
// Note:		This is usually called within the pg_exec function -- pg_exec($dbh, pre_query($sql_get_auth));
function pre_query($query) {
	global $version;
	if ($version < 7) { 
		$query = str_replace("\n", "", $query);
	}
	return $query;
}


if ($mode == "restart") {
	exec("$cfgPgAdmin restart");
	$message = "$strPostgres $strRestart";
}

reset($cfgServers);
while(list($key, $val) = each($cfgServers)) {
	// Don't use servers with no hostname and not local'
	if (empty($val['host']) && !$val['local']) {
		unset($cfgServers[$key]);
	}
}

if (empty($server) || !isset($cfgServers[$server]) || !is_array($cfgServers[$server])) {
	$server = $cfgServerDefault;
}

// If no database is selected, set it to default db
if (empty($db))
	$db = $cfgDefaultDB;

if ($server == 0) {
	// If no server is selected, make sure that $cfgServer is empty
	// (so that nothing will work), and skip server authentication.
	$cfgServer = array();
} else {
	// Otherwise, set up $cfgServer and do the usual login stuff.
	$cfgServer = $cfgServers[$server];

	if (!isset($cfgServer['only_db']) && isset($db)) {
		$db = $cfgServer['only_db'];
	}

	$conn_str = "user=$cfgServer[stduser] password=$cfgServer[stdpass] ";
	if (!$cfgServer[local]) {
		$conn_str .= "host=$cfgServer[host] ";
	}
	$conn_str .= "port=$cfgServer[port] dbname='$db'";

	$ver_realm = "$cfgProgName $cfgVersion on ";
	if ($cfgServer['local']) {
		$short_realm .= "$HTTP_HOST:local";
		if (!empty($cfgServer['port'])) {
			$short_realm .= ":$cfgServer[port]";
		}
	} else {
		$short_realm .= "$HTTP_HOST";
		if (!empty($cfgServer['host'])) {
			$short_realm .= ":$cfgServer[host]";
		}
		if (!empty($cfgServer['port'])) {
			$short_realm .= ":$cfgServer[port]";
		}
	}

	if ($cfgServer['adv_auth']) {	
		if (isset($set_username) && isset($set_password)) {
			$PHP_PGADMIN_USER = $set_username;
			$PHP_PGADMIN_PW = $set_password;
		}
	
		/*
		if(empty($PHP_AUTH_USER) && isset($REMOTE_USER)) {
			$PHP_AUTH_USER = $REMOTE_USER;
		}

		 if(empty($PHP_AUTH_PW) && isset($REMOTE_PASSWORD)) {
			$PHP_AUTH_PW = $REMOTE_PASSWORD;
		}
		*/

		if (isset($mode) && $mode == "logout") {
			unset($PHP_PGADMIN_USER);
			unset($PHP_PGADMIN_PW);
			/*
			unset($REMOTE_USER);
			unset($REMOTE_PASSWORD);
			unset($PHP_AUTH_USER);
			unset($PHP_AUTH_PW);
			*/
		}
		
		if (empty($PHP_PGADMIN_USER) || empty($PHP_PGADMIN_PW)) {
			//$strMsg = $strWrongUser;
			$no_include = true;
			include("header.inc.php");
			include("login.inc.php");
			include("footer.inc.php");
			exit;
		} else if (isset($set_username) && isset($set_password)) {
			if ($dbh = pg_connect($conn_str)) {
				$sql_get_auth = "SELECT usename FROM pg_user WHERE usename = '$set_username' ";
				if ($cfgUseExpire) {
					$sql_get_auth .= "AND (valuntil > 'now' OR valuntil = NULL)";
				}
				
				$rs = pg_exec($dbh, pre_query($sql_get_auth)) or pg_die($dbh, $sql_get_auth);
				
				if (!pg_numrows($rs)) {
					$strMsg = $strWrongUser;
					$no_include = true;
					include("header.inc.php");
					include("login.inc.php");
					include("footer.inc.php");
					exit;
				} else {
					setcookie("PHP_PGADMIN_USER", $set_username, 0, "", $HTTP_HOST);
					setcookie("PHP_PGADMIN_PW", $set_password, 0, "", $HTTP_HOST);
					$PHP_PGADMIN_USER = $set_username;
					$PHP_PGADMIN_PW = $set_password;
				}
			} else {
				pg_die("Unable to connect to server");
			}
		}
		
		$realm = $ver_realm . " " . $short_realm;
		/*
		if(empty($PHP_AUTH_USER) || empty($PHP_AUTH_PW)) {
			header("status: 401 Unauthorized"); // For Roxen cgi-wrapper
			header("HTTP/1.0 401 Unauthorized");
			header("WWW-authenticate: basic realm=\"$realm\"");
			echo "<HTML><HEAD><TITLE>" . $strAccessDenied . "</TITLE></HEAD>\n";
			echo "<BODY BGCOLOR=#FFFFFF style=\"font-family: arial,helvetica\"><BR><BR><CENTER><H1>" . $strWrongUser . "</H1>\n";
			echo "Can't get in?  Click <a href=\"index.php\">here</a>.  You might already be authenticated.";
			echo "<script language=\"JavaScript\">location.href=index.php;</script>";
			echo "</CENTER></BODY></HTML>";
			exit;
		} else {
			if ($dbh = pg_connect($conn_str)) {

				$sql_get_auth = "SELECT usename, passwd FROM pg_shadow WHERE usename = '$PHP_AUTH_USER' ";
				if ($cfgUsePass) {
					$sql_get_auth .= "AND passwd = '$PHP_AUTH_PW' ";
				}
				if ($cfgUseExpire) {
					$sql_get_auth .= "AND (valuntil > 'now' OR valuntil = NULL)";
				}
				$rs = pg_exec($dbh, $sql_get_auth) or pg_die($dbh, $sql_get_auth);
	
				if (!pg_numrows($rs)) {
					Header("status: 401 Unauthorized");
					Header("HTTP/1.0 401 Unauthorized");
					header("WWW-authenticate: basic realm=\"$realm\"");
					echo "<HTML><HEAD><TITLE>" . $strAccessDenied . "</TITLE></HEAD>\n";
					echo "<BODY BGCOLOR=#FFFFFF style=\"font-family: arial,helvetica\"><BR><BR><CENTER><H1>" . $strWrongUser . "</H1>\n";
					echo "Can't get in?  Click <a href=\"index.php\">here</a>.  You might already be authenticated.";
					echo "</CENTER></BODY></HTML>";
					exit;
				}
			} else {
				pg_die("Unable to connect to server");
			}
		}
		*/
		$cfgServer[stduser] = $PHP_PGADMIN_USER;
		$cfgServer[stdpass] = $PHP_PGADMIN_PW;
	}

	$conn_str = "user=$cfgServer[stduser] password=$cfgServer[stdpass] ";
	if (!$cfgServer[local]) {
		$conn_str .= "host=$cfgServer[host] ";
	}
	$conn_str .= "port=$cfgServer[port] dbname='$db'";

	if ($cfgPersistentConnections) {
		$link = @pg_pconnect($conn_str) or pg_die(pg_errormessage(), "Unable to connect with settings: $conn_str");
	} else {
		$link = pg_connect($conn_str) or pg_die(pg_errormessage(), "Unable to connect with settings: $conn_str");
	}
}

$res_version = @pg_exec($link, "SELECT version() as version") or pg_die();
$row_version = @pg_result($res_version, 0, "version");

// Split out the version numbers for later use  $ver_num[0] contains the entire version
ereg("([6-9]).([0-9]).([0-9])", $row_version, $ver_num);
$version = $ver_num[0];

function display_table ($dt_result) {
	global $cfgBorder, $cfgBgcolorOne, $cfgBgcolorTwo, $cfgMaxRows, $pos, $server, $link, $db, $table, $sql_query, $sql_order, $cfgOrder, $cfgShowBlob;
	global $strShowingRecords,$strTotal,$strEdit,$strPrevious,$strNext,$strAction,$strDelete,$strDeleted,$strPos1,$strEnd,$pri_keys,$goto;
	global $cfgQuotes, $cfgMaxPages, $server;

	if (!isset($pos))
		$pos = 0;

	$pos_next = $pos + $cfgMaxRows;
	$pos_prev = $pos - $cfgMaxRows;

	$num_rows = @pg_numrows($dt_result);

	$num_fields = @pg_numfields($dt_result);

	$iNumRows = $num_rows;
	if ($num_rows < $pos_next) {
		$pos_next = $num_rows;
	}
	
	$strNavigation .= "<table border=0>\n";
	$strNavigation .=  "<td align=left>";
	if ($pos >= $cfgMaxRows) {
		//doj added link to beginning of results
		$strNavigation .= "<a href=\"sql.php?server=$server&db=$db&table=$table&sql_query=" . urlencode($sql_query) . "&sql_order=" . urlencode($sql_order) . "&pos=0&goto=$goto\">&lt;&lt; $strPos1 </a> | ";

		$strNavigation .= "	<a href=\"sql.php?server=$server&db=$db&table=$table&sql_query=" . urlencode($sql_query) . "&sql_order=" . urlencode($sql_order) . "&pos=$pos_prev&goto=$goto\">&lt; $strPrevious </a> | ";
	} else {
		$strNavigation .= "&nbsp;";
	}
	$strNavigation .= "</td>\n";

	$strNavigation .= "<td align=center>\n";

	//doj now only the previous and next $cfgMaxPages pages will be shown
	if (empty($cfgMaxPages)) {
		$cfgMaxPages = 9;
	}

	$iCount = $pos - ($cfgMaxRows * $cfgMaxPages);
	if ($iCount < 0) 
		$iCount = 0;

	$iPageCnt = (int)($iCount / $cfgMaxRows); 
	$iPageStop = $pos + ($cfgMaxRows * ($cfgMaxPages + 1));

	for (; $iCount < $iNumRows && $iCount < $iPageStop; $iCount += $cfgMaxRows) {
	  //doj until here
		$iPageCnt++;
		if ($iCount != $pos) {
			$strPages .= "<a href=\"sql.php?server=$server&db=$db&table=$table&sql_query=".urlencode($sql_query)."&sql_order=".urlencode($sql_order)."&pos=$iCount&goto=$goto\">$iPageCnt</a> | ";
		} else {
			if ($iNumRows > $cfgMaxRows) {
				$strPages .= "$iPageCnt | ";
			}
		}
	}
	$strNavigation .= ereg_replace(" \| $", "", $strPages);
	
	$strNavigation .= "</td>\n";
	
	$strNavigation .= "<td align=right>";
	if ($pos_next < $num_rows) {
		$strNavigation .= " | <a href=\"sql.php?server=$server&db=$db&table=$table&sql_query=".urlencode($sql_query)."&sql_order=".urlencode($sql_order)."&pos=$pos_next&goto=$goto\"> $strNext &gt;</a>";

		//doj link to end of results
		$pos_end = $num_rows - $cfgMaxRows;
		$strNavigation .= " | <a href=\"sql.php?server=$server&db=$db&table=$table&sql_query=".urlencode($sql_query)."&sql_order=".urlencode($sql_order)."&pos=$pos_end&goto=$goto\"> $strEnd &gt;&gt;</a>";
	} else {
		$strNavigation .= "&nbsp;";
	}
	$strNavigation .= "</td>\n";
	$strNavigation .= "</table>\n";

	if ($num_rows > 1) { 
		echo "$strShowingRecords $pos - $pos_next ($num_rows $strTotal)";
	}

	echo $strNavigation;
	echo "<table border=$cfgBorder><tr>";
  
	for ($i_field = 0; $i_field < $num_fields; $i_field++) {
		$field_name = pg_fieldname($dt_result, $i_field);
        if (@pg_numrows($dt_result) > 1) {
            $sort_order = urlencode(" ORDER BY $cfgQuotes$field_name$cfgQuotes $cfgOrder");
            echo "<th><A HREF=\"sql.php?server=$server&db=$db&pos=$pos&sql_query=".urlencode($sql_query)."&sql_order=$sort_order&table=$table&goto=$goto\">$field_name</a></th>\n";
		} else {
			echo "<th>$field_name</th>";
		}
	} 
	$priCnt = count($pri_keys);
	if ($priCnt > 0) {
		// echo "<th colspan=\"2\">$strAction : $priCnt</th>";
	}
	echo "</tr>\n"; 
	
	for ($i_row = $pos; $i_row < $pos_next; $i_row++) {
		$row = pg_fetch_row($dt_result, $i_row);
		unset($primary_key);
		$bgcolor = $cfgBgcolorOne;
		$i_row % 2  ? 0: $bgcolor = $cfgBgcolorTwo;
		echo "<tr bgcolor=$bgcolor>"; 
		for ($i_field = 0; $i_field < pg_numfields($dt_result); $i_field++) { 
			if (!isset($row[$i_field])) 
				unset($row[$i_field]);
			$field_type = pg_fieldtype($dt_result, $i_field);
			$field_name = pg_fieldname($dt_result, $i_field);
			if (eregi("int|numeric", $field_type)) {
			
				echo "<td align=right valign=top>&nbsp;$row[$i_field]&nbsp;</td>\n";
			} elseif ($cfgShowBlob == false && eregi("BLOB", $field_type)) {
				echo "<td align=right valign=top>&nbsp;[BLOB]&nbsp;</td>\n"; 
			} elseif ($field_type == "bool") {
				echo "<td valign=top>&nbsp;", bool_YesNo($row[$i_field]), "&nbsp;</td>\n"; 
			} else {
				echo "<td valign=top>&nbsp;", nl2br(htmlspecialchars($row[$i_field])), "&nbsp;</td>\n"; 
			}
			for ($i_pri_keys = 0; $i_pri_keys < count($pri_keys); $i_pri_keys++) {
				// echo $field_name;
				if ($field_name == $pri_keys[$i_pri_keys]) {
					$primary_key .= "$cfgQuotes$field_name$cfgQuotes = ";
					if (eregi("text|name|char|bool", $field_type)) {
						$strQuote = "'";
					} elseif (eregi("date|timestamp", $field_type)) {
						if (empty($row[$i_field])) {
							$strQuote = "";
							$row[$i_field] = "NULL";
						} else {
							$strQuote = "'";
						}
					} else {
						unset($strQuotes);
						// $primary_key .= "$row[$i_field]";
					}
					$primary_key .= $strQuote . $row[$i_field] . $strQuote;
					$primary_key .= " AND ";
					break; // This breaks us out in case the primary key column also has a seperate unique key index created on it
				}
			}
		} 

		if (!empty($primary_key)) {
			if (!empty($GLOBALS[QUERY_STRING])) {
				$extras = $GLOBALS[QUERY_STRING];
			} else {
				$extras = "db=$db&table=$table&sql_query=" . urlencode($sql_query) . "&goto=$goto";
			}
			$primary_key = urlencode(ereg_replace("AND $", "", $primary_key));
			$query = "&server=$server&db=$db&table=$table&goto=" . urlencode("sql.php?" . $extras);
			echo "<td><a href=\"tbl_change.php?edit=1&primary_key=$primary_key$query\">".$strEdit."</a></td>";
			echo "<td><a href=\"sql.php?sql_query=".urlencode("DELETE FROM $cfgQuotes$table$cfgQuotes WHERE ").$primary_key."$query&zero_rows=".urlencode($strDeleted)."\">".$strDelete."</a></td>";
		}
	} 

	echo "</table>\n"; 
	echo $strNavigation;
	return $query;
}


// Return $tables CREATE definition 
// Returns a string containing the CREATE statement on success
// "
function get_table_def($link, $table, $crlf) {
	global $drop, $drop_field, $cfgQuotes;
	unset($schema_create);
	if (!empty($drop)) {
//		$schema_create .= "DROP TABLE IF EXISTS $table;$crlf";
	}
	$schema_create .= "CREATE TABLE $cfgQuotes$table$cfgQuotes ($crlf";
	
	$sql_get_fields = "
		SELECT 
			a.attnum,
			a.attname AS field, 
			t.typname AS type, 
			a.attlen AS length,
			a.atttypmod AS lengthvar,
			a.attnotnull AS notnull
		FROM 
			pg_class c, 
			pg_attribute a, 
			pg_type t
		WHERE 
			c.relname = '$table'
			and a.attnum > 0
			and a.attrelid = c.oid
			and a.atttypid = t.oid
		ORDER BY a.attnum
	";

	$result = pg_exec($link, pre_query($sql_get_fields)) or pg_die(pg_errormessage());
	$i = 0;
	while ($row = @pg_fetch_array($result, $i++)) {
		if ($row[field] != $drop_field) {
			$sql_get_default = "
				SELECT d.adsrc AS rowdefault
				FROM pg_attrdef d, pg_class c 
				WHERE 
					c.relname = '$table' 
					AND c.oid = d.adrelid 
					AND d.adnum = $row[attnum]
			";
			$def_res = pg_exec($link, pre_query($sql_get_default)) or pg_die(pg_errormessage());
			if (!$def_res) {
				unset($row[rowdefault]);
			} else {
				$row[rowdefault] = @pg_result($def_res, 0, "rowdefault");
			}
	
			if ($row[type] == "bpchar") {
				// Internally stored as bpchar, but isn't accepted in a CREATE TABLE
				$row[type] = "char";
			}
			
			$schema_create .= "   $cfgQuotes$row[field]$cfgQuotes $row[type]";
			if (eregi("char", $row[type])) {
				if ($row[lengthvar] > 0) {
					$schema_create .= "(" . ($row[lengthvar] - 4) . ")";
				}
			}
			if (eregi("numeric", $row[type])) {
				//Marcellus fixed problem on 5-25-00
				$schema_create .= "(";
				$schema_create .= sprintf("%s,%s", ($row[lengthvar] >> 16) & 0xffff, ($row[lengthvar] - 4) & 0xffff);
				$schema_create .= ")";
	
			}
			if (!empty($row[rowdefault])) {
				if (eregi("text|name|char|date|timestamp|bool", $row[type])) {
					//$delim = "'";
				} else {
					unset($delim);
				}
				$schema_create .= " DEFAULT ". $delim . $row[rowdefault] . $delim;
			}
			if ($row["notnull"] == "t") {
				$schema_create .= " NOT NULL";
			}
			$schema_create .= ",$crlf";
		}
	}

	$sql_pri_keys = "
		SELECT 
			a.attname AS column_name,
			i.indisprimary AS primary_key,
			i.indisunique as unique_key,
			ic.relname AS index_name
		FROM 
			pg_class bc,
			pg_class ic,
			pg_index i,
			pg_attribute a
		WHERE 
			i.indrelid = bc.oid
			and i.indexrelid = ic.oid
			and 
			(
				i.indkey[0] = a.attnum 
				or
				i.indkey[1] = a.attnum
				or
				i.indkey[2] = a.attnum
				or
				i.indkey[3] = a.attnum
				or
				i.indkey[4] = a.attnum
				or
				i.indkey[5] = a.attnum
				or
				i.indkey[6] = a.attnum
				or
				i.indkey[7] = a.attnum
			)
			and a.attrelid = bc.oid
			and i.indproc = '0'::oid
			and bc.relname = '$table'
	";

	$result = @pg_exec($link, pre_query($sql_pri_keys)) or pg_die();

	$i = 0;
	while ($row = @pg_fetch_array($result, $i++)) {
		if ($row[column_name] != $drop_field) {
			if ($row[primary_key] == "t") {
				if (!empty($primary_key)) {
					$primary_key .= ", ";
				}
				$primary_key .= "$cfgQuotes$row[column_name]$cfgQuotes";
			} elseif ($row[unique_key] == "t") {
				$schema_create .= "   UNIQUE ($cfgQuotes$row[column_name]$cfgQuotes),$crlf";
			} else {
				$index_create .= "CREATE INDEX $cfgQuotes" . $row[column_name] . "_$table" . "_key$cfgQuotes ON $cfgQuotes$table$cfgQuotes ($cfgQuotes$row[column_name]$cfgQuotes);$crlf";
			}
		}
	}
	if (!empty($primary_key)) {
		$schema_create .= "   PRIMARY KEY ($primary_key),$crlf";
	}

	$schema_create = ereg_replace(",".$crlf."$", "", $schema_create);
	$index_create = ereg_replace(",".$crlf."$", "", $index_create);

	$schema_create .= "$crlf);$crlf";
	
	if (!empty($index_create)) {
		$schema_create .= $index_create;
	}
	return (stripslashes($schema_create));
} 

// Get the content of $table as a series of INSERT statements.
// After every row, a custom callback function $handler gets called.
// $handler must accept one parameter ($sql_insert);
function get_table_content($link, $table, $handler) {
	$result = @pg_exec($link, "SELECT * FROM $cfgQuotes$table$cfgQuotes") or pg_die(pg_errormessage());
	$iNumFields = pg_numfields($result);

	// Gather info about each column in the table	
	for ($iField = 0; $iField < $iNumFields; $iField++) {
		$aryType[] = pg_fieldtype($result, $iField);
		$aryName[] = pg_fieldname($result, $iField);
	}
	
	$iRec = 0;
	while ($row = @pg_fetch_array($result, $iRec++)) {
		unset($schema_vals);
		unset($schema_fields);
		unset($schema_insert);
		
		for ($iFieldVal = 0; $iFieldVal < $iNumFields; $iFieldVal++) {
			$strVal = $row[$aryName[$iFieldVal]];
			if (eregi("char|text|bool", $aryType[$iFieldVal])) {
				$strQuote = "'";
				$strEmpty = "";
				$strVal = addslashes($strVal);
			} elseif (eregi("date|timestamp", $aryType[$iFieldVal])) {
				if (empty($strVal)) {
					$strQuote = "";
				} else {
					$strQuote = "'";
				}
				$strEmpty = "NULL";
			} else {
				$strQuote = "";
				$strEmpty = "NULL";
			}
			if (empty($strVal) && $strVal != "0") {
				$strVal = $strEmpty;
			}
			$schema_vals .= " $strQuote$strVal$strQuote,";
			$schema_fields .= " $cfgQuotes$aryName[$iFieldVal]$cfgQuotes,";
		}
		
		$schema_vals = ereg_replace(",$", "", $schema_vals);
		$schema_vals = ereg_replace("^ ", "", $schema_vals);
		$schema_fields = ereg_replace(",$", "", $schema_fields);
		$schema_fields = ereg_replace("^ ", "", $schema_fields);
		$schema_insert = "INSERT INTO $cfgQuotes$table$cfgQuotes ($schema_fields) VALUES($schema_vals)";
		$handler(trim($schema_insert));
	}
	return (true);
}
 
function count_records ($link, $table) {
	global $strNoAuth, $cfgQuotes;
	$result = @pg_exec($link, "SELECT COUNT(*) AS num FROM $cfgQuotes$table$cfgQuotes");
	$num = @pg_result($result, 0 ,"num");
	if (!empty($num) || $num == 0) {
		echo $num;
	} else {
		echo $strNoAuth;
	}
}

// Get the content of $table as a CSV output.
// $sep contains the separation string.
// After every row, a custom callback function $handler gets called.
// $handler must accept one parameter ($sql_insert);

function get_table_csv($link, $table, $sep, $handler) {
	$result = pg_exec($link, "SELECT * FROM $cfgQuotes$table$cfgQuotes") or pg_die(pg_errormessage());
	$i = 0;
	if (pg_numrows($result)) {
		while ($row = @pg_fetch_row($result, $i++)) {
			unset($schema_insert);
			for ($j = 0; $j < pg_numfields($result); $j++) {
				if (!isset($row[$j])) {
					$schema_insert .= "NULL".$sep;
				} elseif ($row[$j] != "") {
					$schema_insert .= "$row[$j]".$sep;
				} else {
					$schema_insert .= "".$sep;
				}
			}
			$schema_insert = ereg_replace($sep."$", "", $schema_insert);
			//       $schema_insert .= ")";
			$handler(trim($schema_insert));
		}
	} else {
		echo "$strNoData $strFound";
	}
	return (true);
}

function show_docu($link) {
	global $cfgManualBase, $strDocu;
	if (!empty($cfgManualBase)) {
		return("[<a href=\"$cfgManualBase/$link\">$strDocu</a>]");
	}
}

function show_message($message) {
	global $affected_rows;
	if (!empty($GLOBALS['reload']) && ($GLOBALS['reload'] == "true")) { ?>
	    <script language="JavaScript1.2">
	    parent.frames.nav.location.reload();
	    </script>
<?php } ?>

	<div align="left">
	<table border="<?php echo $GLOBALS['cfgBorder'];?>">
		<tr>
			<td bgcolor="<?php echo $GLOBALS['cfgThBgcolor'];?>">
				<b><?php echo $message; ?><b><br>
			</td>
		</tr>
<?php if ($GLOBALS['cfgShowSQL'] == true && !empty($GLOBALS['sql_query'])) { ?>
		<tr>
			<td bgcolor="<?php echo $GLOBALS['cfgBgcolorOne'];?>">
			<?php 
				if (isset($affected_rows)) {
					echo $GLOBALS['strAffected'].": $affected_rows<br>\n"; 
				}
			?>
			<?php echo $GLOBALS['strSQLQuery'].":\n<br>", stripslashes(nl2br(htmlentities($GLOBALS['sql_query'])));?>
			</td>
		</tr>
<?php } ?>
	</table>
	</div>
<?php
}

//***************************************************************************************
//      Function:       isInArray($value, $chkArray)
//      Puspose:        Check to see if $value is in $chkArray
//      Params:         $value, $chkArray

function isInArray($value, $chkArray) {
	for ($iTrav = 0; $iTrav < count($chkArray); $iTrav++) {
		if ($value == $chkArray[$iTrav]) {
			return 1;
		}
	}
	return 0;
}


function bool_YesNo($boolVal) {
	global $strNo, $strYes;
	if (eregi("^t|1|^y", $boolVal)) {
		return $strYes;
	} elseif (eregi("^f|0|^n", $boolVal)) {
		return $strNo;
	}
}

function noQuoteSplit($string, $sep, $delim) {
	$curpos = 0;
	$in = 0;
	unset($accum);
	$string = trim($string); 
	
	for ($i = 0, $n = strlen($string); $i < $n; $i++) {
		$char = $string[$i];
		$accum .= $char;
		if (($char == $delim) && ($string[$i - 1] != "\\")) {
			if ($in == 0) {
				$in = 1;
			} else {
				$in = 0;
			}
		} elseif ($char == $sep) {
			if ($in == 0) {
				$found[] = trim($accum);
				unset($accum);
			}
		}
	}
	if ($accum) {
		$found[] = $accum;
	}
	
	return $found;
}


//***************************************************************************************
//      Function:       select_box($settings)
//      Puspose:        Display a drop-down box
//      Params:         $settings -- Associative array containing all info about the select.
//                                      - selected      -- The selected/default option
//                                      - values        -- array containing all options.  Associative or normal array
//                                      - multiple      -- specifies wether is a multiple select or not

function select_box($settings) {
	// Compile the attributes such as size etc.
	while (list($thiskey, $thisval) = each($settings)) {
		if ($thiskey == "multiple") {
			$attribs .= " multiple";
		} else if (($thiskey != "values") && ($thiskey != "name") && ($thiskey != "selected")) {
			$attribs .= " $thiskey=\"$thisval\"";
		} 
	}
	if (ereg("multiple", $attribs)) {
		$name = "$settings[name][]";
	} else {
		$name = "$settings[name]";
	}
	
	// Start the selectbox tag
	$strReturn .= "\n<select name=\"$name\" $attribs>";
	// Check if the valuse are in associative array or not
	if (count($settings[values]) > 0) {
		if (!isset($settings[values][0])) {
			while (list($disp, $val) = each($settings[values])) {
				$strReturn .= "\n<option value=\"".chop($val)."\"";
				// Check if the selected is an array
				if (is_array($settings[selected])) {
					// Loop through the selected array
					for ($iSelIndex = 0; $iSelIndex < count($settings[selected]); $iSelIndex++) {
						if ($val == chop($settings[selected][$iSelIndex]))  {
							$strReturn .= " selected";
						}
					}
				} else {
					if ($val == chop($settings[selected]))  {
						$strReturn .= " selected";
					}
				}
				$strReturn .= ">$disp";
			}
		} else { // If not in associative array
			for ($index = 0; $index < count($settings[values]); $index++) {
				$strReturn .= "\n<option value=\"".chop($settings[values][$index])."\"";
				// Check if the selected is an array
				if (is_array($settings[selected])) {
					for ($iSelIndex = 0; $iSelIndex < count($settings[selected]); $iSelIndex++) {
						if (chop($settings[values][$index]) == chop($settings[selected][$iSelIndex])) {
							$strReturn .= " selected";
						}
					}
				} else {
					if (chop($settings[values][$index]) == chop($settings[selected])) {
						$strReturn .= " selected";
					}
				}
				$strReturn .= ">".$settings[values][$index];
			}
		}
	} else {
		$strReturn .= "<option value=\"0\">No Values";
	}
	$strReturn .= "\n</select>\n";
	return $strReturn;
}

// -----------------------------------------------------------------

// Array of standard postgres functions
$cfgFunctions = array(
	"CURVAL",
	"NEXTVAL",
	"TEXTCAT",
	"TEXTLEN",
	"COALESCE",
	"NULLIF",
	"ABS",
	"DEGREES",
	"EXP",
	"LN",
	"LOG",
	"PI",
	"POW",
	"RADIANS",
	"ROUND",
	"SQRT",
	"CBRT",
	"TRUNC",
	"FLOAT",
	"FLOAT4",
	"INTERGER",
	"ACOS",
	"ASIN",
	"ATAN",
	"ATAN2",
	"COS",
	"COT",
	"SIN",
	"TAN",
	"CHAR_LENGTH",
	"LOWER",
	"OCTET_LENGTH",
	"POSITION",
	"SUBSTRING",
	"TRIM",
	"UPPER",
	"CHAR",
	"INITCAP",
	"LPAD",
	"LTRIM",
	"TEXTPOS",
	"RPAD",
	"RTRIM",
	"SUBSTR",
	"TEXT",
	"TRANSLATE",
	"VARCHAR",
	"ABSTIME",
	"AGE",
	"DATE_PART",
	"DATE_TRUNC",
	"INTERVAL",
	"ISFINITE",
	"RELTIME",
	"TIMESTAMP",
	"TO_CHAR",
	"TO_DATE",
	"TO_TIMESTAMP",
	"TO_NUMBER",
	"AREA",
	"BOX",
	"CENTER",
	"DIAMETER",
	"HEIGHT",
	"ISCLOSED",
	"ISOPEN",
	"LENGTH",
	"PCLOSE",
	"NPOINT",
	"POPEN",
	"RADIUS",
	"WIDTH",
	"CIRCLE",
	"LSEG",
	"PATH",
	"POINT",
	"POLYGON",
	"ISOLDPATH",
	"REVERTPOLY",
	"UPGRADEPATH",
	"UPGRADEPOLY",
	"BROADCAST",
	"HOST",
	"MASKLEN",
	"NETMASK"
	);

	$LIB_INC = 1;
}
?>
