/* Module:          SQLTransact.c
 *
 * Description:     Has been replaced by SQLEndTran. 
 *
 * Classes:         
 *
 * API functions:   SQLTransact
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */

#include "driver.h"

SQLRETURN SQL_API SQLTransact(
							  SQLHENV		hDrvEnv,
							  SQLHDBC		hDrvDbc,
							  SQLUSMALLINT	nType
							  )
{
	static char *func = "SQLTransact";
	extern ConnectionClass *conns[];
	ConnectionClass *conn;
	QResultClass *res;
	char ok, *stmt_string;
	int lf;

	mylog("entering %s: hDrvDbc=%u, hDrvEnv=%u\n", func, hDrvDbc, hDrvEnv);

	if (hDrvDbc == SQL_NULL_HDBC && hDrvEnv == SQL_NULL_HENV)
	{
		CC_log_error(func, "", NULL);
		return SQL_INVALID_HANDLE;
	}

	/* If hDrvDbc is null and hDrvEnv is valid,
	it means transact all connections on that hDrvEnv.  
	*/
	if (hDrvDbc == SQL_NULL_HDBC && hDrvEnv != SQL_NULL_HENV)
	{
		for (lf=0; lf <MAX_CONNECTIONS; lf++)
		{
			conn = conns[lf];

			//  if (conn && conn->hDrvEnv == hDrvEnv)
			if (conn && conn->henv == hDrvEnv)
			{
				if ( SQLTransact(hDrvEnv, (SQLHDBC) conn, nType) != SQL_SUCCESS)
				{
					return SQL_ERROR;
				}
			}

		}
		return SQL_SUCCESS;       
	}

	conn = (ConnectionClass *) hDrvDbc;

	if (nType == SQL_COMMIT)
	{
		stmt_string = "COMMIT";
	}
	else if (nType == SQL_ROLLBACK)
	{
		stmt_string = "ROLLBACK";
	}
	else
	{
		conn->errornumber = CONN_INVALID_ARGUMENT_NO;
		conn->errormsg ="SQLTransact can only be called with SQL_COMMIT or SQL_ROLLBACK as parameter";
		CC_log_error(func, "", conn);
		return SQL_ERROR;
	}    

	/*	If manual commit and in transaction, then proceed. */
	if ( ! CC_is_in_autocommit(conn) &&  CC_is_in_trans(conn))
	{

		mylog("SQLTransact: sending on conn %d '%s'\n", conn, stmt_string);

		res = CC_send_query(conn, stmt_string, NULL);
		CC_set_no_trans(conn);

		if ( ! res)
		{
			/*	error msg will be in the connection */
			CC_log_error(func, "", conn);
			return SQL_ERROR;
		}

		ok = QR_command_successful(res);   
		QR_Destructor(res);

		if (!ok)
		{
			CC_log_error(func, "", conn);
			return SQL_ERROR;
		}
	}    
	return SQL_SUCCESS;
}

