'
'	Frank Lupo (Wolf) !! 
'	frank_lupo@email.it
'
'	This is a Psql command for Postgresql write in Visual Basic Script
'
'	Export Excel
'	Export Into Access application
'
Option Explicit

Class ClsExport
	Private szFileExport

	Private Sub Class_Initialize
	Dim szTemp,bExit,Fso

		Set fso = CreateObject("Scripting.FileSystemObject")

		'File Name
		bExit=True
		While bExit
			WScript.StdOut.Write "File Name to export: "
			szTemp = WScript.StdIn.ReadLine
			if len(trim(szTemp))>0 then
				'Verify directory
				if fso.FolderExists(fso.GetParentFolderName(szTemp)) then
					szFileExport=szTemp
					bExit=False
				else
					Wscript.Echo App.Data.Message.NoSuchFD(szTemp)
				end if
			end if
		Wend
	End Sub

	Public Sub Export(ResultSet)
	Dim X,Y,AccessApp,Fso,szSql,iNum,szSqlInsert

		On error resume next

  		Set AccessApp = CreateObject("Access.Application")
	  	AccessApp.Visible = True

		Set Fso = CreateObject("Scripting.FileSystemObject")
		Fso.DeleteFile szFileExport

		AccessApp.NewCurrentDatabase szFileExport

		szSqlInsert="insert into Result ("
		szSql ="Create table Result ("
    	For X = 0 To ResultSet.Fields.Count - 1
			szSqlInsert=szSqlInsert & " " & ResultSet.Fields(X).Name
			szSql=szSql & " " & ResultSet.Fields(X).Name & " "
			Select case ResultSet.Fields(X).Type
			Case adInteger,adBinary,adUnsignedInt
				szSql=szSql & " Integer "
			Case adBoolean 
				szSql=szSql & " Boolean "
			Case adUnsignedTinyInt 
				szSql=szSql & " Byte "
			Case adCurrency 
				szSql=szSql & " Money "
			Case adDate,adDBDate
				szSql=szSql & " Date "
			Case adDBTime
				szSql=szSql & " Time "
			Case adDBTimeStamp
				szSql=szSql & " TimeStamp "
			Case adDouble 
				szSql=szSql & " Double "
			Case adLongVarBinary
				szSql=szSql & " LongBinary "
			Case adLongVarWChar
				szSql=szSql & " LongText "
			Case adSingle
				szSql=szSql & " Single "
			Case adSmallInt
				szSql=szSql & " Short "
			Case adVarWChar,adLongVarChar
				szSql=szSql & " Text "
			Case adChar
				iNum=ResultSet.Fields(X).DefinedSize
				if iNum > 255 then iNum=255
				szSql=szSql & " Char(" & iNum & ") "
			Case adVarChar
				iNum=ResultSet.Fields(X).DefinedSize
				if iNum > 255 then iNum=255
				szSql=szSql & " Varchar(" & iNum & ") "
			Case Else 
				wscript.echo  "Type field not found !! " & ResultSet.Fields(X).Type
				szSql=szSql & " Varchar(255) "
			End Select
			if X<ResultSet.Fields.Count - 1 then 
				szSql=szSql & " ,"
				szSqlInsert=szSqlInsert & " ,"
			end if
    	Next
		szSql=szSql & " )"
		szSqlInsert=szSqlInsert & " ) values ("

		'Create table
		AccessApp.CurrentDb.Execute szSql

	  	'Enter Data
  		Y = 1
  		While Not ResultSet.EOF
			szSql=szSqlInsert 
    		For X = 0 To ResultSet.Fields.Count - 1
				Select case ResultSet.Fields(X).Type
				Case adInteger,adBinary,adUnsignedInt
					szSql=szSql & ResultSet.Fields(X).Value 
				Case adBoolean 
					szSql=szSql & ResultSet.Fields(X).Value 
				Case adUnsignedTinyInt 
					szSql=szSql & ResultSet.Fields(X).Value 
				Case adCurrency 
					szSql=szSql & "'" & ResultSet.Fields(X).Value  & "'"
				Case adDate,adDBDate
					szSql=szSql & "'" & ResultSet.Fields(X).Value  & "'"
				Case adDBTime
					szSql=szSql & "'" & ResultSet.Fields(X).Value  & "'"
				Case adDBTimeStamp
					szSql=szSql & "'" & ResultSet.Fields(X).Value  & "'"
				Case adDouble 
					szSql=szSql & ResultSet.Fields(X).Value
				Case adLongVarBinary
					szSql=szSql & ResultSet.Fields(X).Value
				Case adLongVarWChar
					szSql=szSql & "'" & ResultSet.Fields(X).Value  & "'"
				Case adSingle
					szSql=szSql & ResultSet.Fields(X).Value 
				Case adSmallInt
					szSql=szSql & ResultSet.Fields(X).Value 
				Case adVarWChar,adLongVarChar
					szSql=szSql & "'" & ResultSet.Fields(X).Value  & "'"
				Case adChar
					szSql=szSql & "'" & ResultSet.Fields(X).Value  & "'"
				Case adVarChar
					szSql=szSql & "'" & ResultSet.Fields(X).Value  & "'"
				Case Else 
					szSql=szSql & "'" & ResultSet.Fields(X).Value  & "'"
				End Select
				if X<ResultSet.Fields.Count - 1 then szSql=szSql & " ,"
    		Next
			szSql=szSql & " ) "
			AccessApp.CurrentDb.Execute szSql
    		ResultSet.MoveNext
    		Y = Y + 1
  		Wend
	End Sub
End Class
