/*
 * Decompiled with CFR 0.152.
 */
package xcodegen;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.velocity.app.Velocity;
import xcodegen.exceptions.ParserException;
import xcodegen.exceptions.XCodeGenException;
import xcodegen.generator.CodeGenerator;
import xcodegen.generator.CodeGeneratorFactory;
import xcodegen.parser.Parser;
import xcodegen.parser.ParserFactory;
import xcodegen.structure.XPackage;

public class XCodeGen {
    public static final String VERSION = "0.1";
    private static final Logger __logger = Logger.getLogger((Class)(class$xcodegen$XCodeGen == null ? (class$xcodegen$XCodeGen = XCodeGen.class$("xcodegen.XCodeGen")) : class$xcodegen$XCodeGen));
    private boolean _generateDAO;
    private Properties _daoConfig = new Properties();
    private boolean _generateDTO;
    private Properties _dtoConfig = new Properties();
    private boolean _generateDDL;
    private Properties _ddlConfig = new Properties();
    private String _filepath;
    private Collection _errors = new Vector();
    static /* synthetic */ Class class$xcodegen$XCodeGen;

    public void init() throws Exception {
        String string = "resources/conf/log4j.properties";
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            throw new XCodeGenException("Log4j configuration resource not found: " + string);
        }
        Properties properties = new Properties();
        properties.load(inputStream);
        PropertyConfigurator.configure((Properties)properties);
        __logger.info((Object)"Initializing Velocity Template Engine");
        string = "resources/conf/velocity.properties";
        inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            throw new XCodeGenException("Velocity configuration resource not found: " + string);
        }
        properties = new Properties();
        properties.load(inputStream);
        Velocity.init((Properties)properties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() throws ParserException, XCodeGenException, IOException {
        FileInputStream fileInputStream = null;
        try {
            block6: {
                CodeGenerator codeGenerator;
                __logger.info((Object)("Loading class descriptor from: " + this._filepath));
                fileInputStream = new FileInputStream(this._filepath);
                __logger.info((Object)"Parsing the class descriptor file");
                Parser parser = ParserFactory.getInstance().getXMLParser();
                XPackage[] xPackageArray = parser.parse(fileInputStream);
                CodeGeneratorFactory codeGeneratorFactory = CodeGeneratorFactory.getInstance();
                if (this._generateDTO) {
                    __logger.info((Object)"Running the DTO Code Generator");
                    codeGenerator = codeGeneratorFactory.getDTOCodeGenerator();
                    codeGenerator.init(this._dtoConfig);
                    codeGenerator.generate(xPackageArray);
                }
                if (this._generateDAO) {
                    __logger.info((Object)"Running the DAO Code Generator");
                    codeGenerator = codeGeneratorFactory.getDAOCodeGenerator();
                    codeGenerator.init(this._daoConfig);
                    codeGenerator.generate(xPackageArray);
                }
                if (!this._generateDDL) break block6;
                __logger.info((Object)"Running the DDL CodeGenrator");
                codeGenerator = codeGeneratorFactory.getDDLCodeGenerator();
                codeGenerator.init(this._ddlConfig);
                codeGenerator.generate(xPackageArray);
            }
            Object var7_7 = null;
            if (fileInputStream == null) return;
            fileInputStream.close();
            return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (fileInputStream == null) throw throwable;
            fileInputStream.close();
            throw throwable;
        }
    }

    public void setFilepath(String string) {
        this._filepath = string;
    }

    public void setLanguage(String string) {
        this._daoConfig.put("language", string);
        this._dtoConfig.put("language", string);
    }

    public void setDatabase(String string) {
        this._ddlConfig.put("database", string);
    }

    public void setBeanOutputDir(String string) {
        this._daoConfig.put("class.output.dir", string);
        this._dtoConfig.put("class.output.dir", string);
    }

    public void setGenerateDAO(boolean bl) {
        this._generateDAO = bl;
    }

    public void setDAOClassPrefix(String string) {
        this._daoConfig.put("class.prefix", string);
    }

    public void setDAOClassSuffix(String string) {
        this._daoConfig.put("class.suffix", string);
    }

    public void setDAOPackageSuffix(String string) {
        this._daoConfig.put("package.suffix", string);
    }

    public void setGenerateDTO(boolean bl) {
        this._generateDTO = bl;
    }

    public void setDTOClassPrefix(String string) {
        this._dtoConfig.put("class.prefix", string);
    }

    public void setDTOClassSuffix(String string) {
        this._dtoConfig.put("class.suffix", string);
    }

    public void setDTOPackageSuffix(String string) {
        this._dtoConfig.put("package.suffix", string);
    }

    public void setGenerateDDL(boolean bl) {
        this._generateDDL = bl;
    }

    public void setSQLOutputDir(String string) {
        this._ddlConfig.put("database.output.dir", string);
    }

    public void setDDLOutputFile(String string) {
        this._ddlConfig.put("database.output.file", string);
    }

    public void setDDLStringSize(String string) {
        this._ddlConfig.put("database.string.size", string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

