/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseColumn;
import com.microsoft.jdbc.base.BaseData;
import com.microsoft.jdbc.base.BaseFileChunkCharStream;
import com.microsoft.jdbc.base.BaseFileChunkInputStream;
import com.microsoft.jdbc.base.BaseImplBlob;
import com.microsoft.jdbc.base.BaseImplClob;
import com.microsoft.jdbc.base.BaseImplServiceResultSet;
import com.microsoft.util.UtilException;
import com.microsoft.util.UtilPagedTempBuffer;
import com.microsoft.util.UtilTempFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.sql.SQLException;

public final class BaseImplStaticCursorResultSet
extends BaseImplServiceResultSet {
    private static String footprint = "$Revision:   1.16.1.3  $";
    private File longDataFileHandle;
    private RandomAccessFile longDataFile;
    UtilPagedTempBuffer rowDataBuff;
    UtilPagedTempBuffer rowPositionBuff;
    private int rowsFetchedFromSubResultSet = 0;
    private BaseData[] rowData;
    private boolean endOfResultSetReached = false;
    byte[] byteArrayForReading;
    static int DEFAULT_BUFF_INCREMENT = 1024;

    private void cacheBinaryStream(int n, InputStream inputStream) throws IOException, UtilException {
        this.rowDataBuff.writeInt(n);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        long l = 0L;
        this.longDataFile.seek(this.longDataFile.length());
        byte[] byArray = new byte[1024];
        int n2 = inputStream.read(byArray, 0, 1024);
        while (n2 != -1) {
            this.longDataFile.write(byArray, 0, n2);
            l += (long)n2;
            n2 = inputStream.read(byArray, 0, 1024);
        }
        this.rowDataBuff.writeLong(l);
    }

    private void cacheBlob(BaseImplBlob baseImplBlob) throws SQLException, IOException, UtilException {
        this.rowDataBuff.writeInt(1020);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        this.longDataFile.seek(this.longDataFile.length());
        this.subImplResultSet.writeBlob(this.longDataFile, baseImplBlob);
    }

    private void cacheCharacterStream(int n, Reader reader) throws IOException, UtilException {
        this.rowDataBuff.writeInt(n);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        long l = 0L;
        this.longDataFile.seek(this.longDataFile.length());
        char[] cArray = new char[1024];
        int n2 = reader.read(cArray, 0, 1024);
        while (n2 != -1) {
            int n3 = 0;
            while (n3 < n2) {
                this.longDataFile.writeChar(cArray[n3]);
                ++n3;
            }
            l += (long)(n2 * 2);
            n2 = reader.read(cArray, 0, 1024);
        }
        this.rowDataBuff.writeLong(l);
    }

    private void cacheClob(BaseImplClob baseImplClob) throws SQLException, IOException, UtilException {
        this.rowDataBuff.writeInt(1021);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        this.longDataFile.seek(this.longDataFile.length());
        this.subImplResultSet.writeClob(this.longDataFile, baseImplClob);
    }

    void cacheCurrentRow() throws SQLException {
        try {
            this.rowPositionBuff.writeLong(this.rowDataBuff.getSize());
            int n = 0;
            while (n < this.columns.count(0)) {
                BaseColumn baseColumn = this.columns.get(n + 1);
                BaseData baseData = this.subImplResultSet.getData(n + 1, baseColumn.baseDataType);
                switch (baseData.type) {
                    case 1001: 
                    case 1002: 
                    case 1003: 
                    case 1004: 
                    case 1005: 
                    case 1006: 
                    case 1007: 
                    case 1008: 
                    case 1009: 
                    case 1010: 
                    case 1011: 
                    case 1012: 
                    case 1013: {
                        this.rowDataBuff.writeInt(baseData.type);
                        String string = baseData.getString(-1, this.implStatement.implConnection.exceptions);
                        byte[] byArray = string.getBytes();
                        this.rowDataBuff.writeInt(byArray.length);
                        this.rowDataBuff.write(this.rowDataBuff.getSize(), byArray);
                        break;
                    }
                    case 1019: {
                        this.rowDataBuff.writeInt(1019);
                        this.rowDataBuff.writeInt(0);
                        break;
                    }
                    case 1014: 
                    case 1015: {
                        this.cacheBinaryStream(baseData.type, (InputStream)baseData.data);
                        break;
                    }
                    case 1020: {
                        this.cacheBlob((BaseImplBlob)baseData.data);
                        break;
                    }
                    case 1018: {
                        this.cacheCharacterStream(1018, (Reader)baseData.data);
                        break;
                    }
                    case 1021: {
                        this.cacheClob((BaseImplClob)baseData.data);
                        break;
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(exception);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6040);
        }
    }

    public void close() throws SQLException {
        super.close();
        try {
            this.rowDataBuff.truncate();
            this.rowPositionBuff.truncate();
            this.longDataFile.close();
            this.longDataFileHandle.delete();
        }
        catch (Exception exception) {}
    }

    private boolean fetch(int n) throws SQLException {
        boolean bl = true;
        if (n > this.rowsFetchedFromSubResultSet) {
            bl = this.fetchAndCache(n - this.rowsFetchedFromSubResultSet);
        }
        return bl;
    }

    boolean fetchAndCache(int n) throws SQLException {
        boolean bl = true;
        int n2 = 0;
        while (bl && n2 < n) {
            bl = this.endOfResultSetReached ? false : this.subImplResultSet.positionCursor(this.rowsFetchedFromSubResultSet + 1);
            if (bl) {
                ++this.rowsFetchedFromSubResultSet;
                this.cacheCurrentRow();
            } else {
                this.endOfResultSetReached = true;
                if (this.notificationSink != null) {
                    this.notificationSink.endOfResultSetReached(this.rowsFetchedFromSubResultSet);
                }
            }
            ++n2;
        }
        return bl;
    }

    private void getCachedBinaryStream(int n, long l, BaseData baseData) throws IOException, UtilException {
        long l2 = this.rowDataBuff.readLong(l);
        long l3 = this.rowDataBuff.readLong(l + 8L);
        BaseFileChunkInputStream baseFileChunkInputStream = new BaseFileChunkInputStream(this.longDataFile, l2, l3);
        baseData.data = baseFileChunkInputStream;
        baseData.type = n;
    }

    private void getCachedBlob(long l, BaseData baseData) throws SQLException, IOException {
        this.longDataFile.seek(l);
        baseData.data = this.subImplResultSet.readBlob(this.longDataFile);
        baseData.type = 1020;
    }

    private void getCachedCharStream(int n, long l, BaseData baseData) throws IOException, UtilException {
        long l2 = this.rowDataBuff.readLong(l);
        long l3 = this.rowDataBuff.readLong(l + 8L);
        BaseFileChunkCharStream baseFileChunkCharStream = new BaseFileChunkCharStream(this.longDataFile, l2, l3);
        baseData.data = baseFileChunkCharStream;
        baseData.type = n;
    }

    private void getCachedClob(long l, BaseData baseData) throws SQLException, IOException {
        this.longDataFile.seek(l);
        baseData.data = this.subImplResultSet.readClob(this.longDataFile);
        baseData.type = 1021;
    }

    boolean getCachedRow(int n) throws SQLException {
        boolean bl = false;
        try {
            long l = n * 8;
            long l2 = this.rowPositionBuff.readLong((long)((int)l));
            this.intializeRow();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < this.columns.count(0)) {
                int n3 = this.rowDataBuff.readInt(l2);
                l2 += 2L;
                if (n3 == 1015 || n3 == 1014) {
                    this.getCachedBinaryStream(n3, l2, this.rowData[n2]);
                    l2 += 16L;
                } else if (n3 == 1018) {
                    this.getCachedCharStream(n3, l2, this.rowData[n2]);
                    l2 += 16L;
                } else if (n3 == 1020) {
                    this.getCachedBlob(this.rowDataBuff.readLong(l2), this.rowData[n2]);
                    l2 += 8L;
                } else if (n3 == 1021) {
                    this.getCachedClob(this.rowDataBuff.readLong(l2), this.rowData[n2]);
                    l2 += 8L;
                } else {
                    int n4 = this.rowDataBuff.readInt(l2);
                    l2 += 2L;
                    if (n3 != 1019) {
                        stringBuffer.setLength(0);
                        if (n4 > this.byteArrayForReading.length) {
                            int n5 = n4 + DEFAULT_BUFF_INCREMENT;
                            this.byteArrayForReading = new byte[n5];
                        }
                        this.rowDataBuff.read(l2, this.byteArrayForReading, 0, n4);
                        l2 += (long)n4;
                        this.rowData[n2].data = new String(this.byteArrayForReading, 0, n4);
                        this.rowData[n2].type = 1010;
                    }
                    switch (n3) {
                        case 1001: {
                            this.rowData[n2].data = new Byte(this.rowData[n2].getByte(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 1002: {
                            this.rowData[n2].data = this.rowData[n2].getBytes(-1, this.implStatement.implConnection.exceptions);
                            break;
                        }
                        case 1003: {
                            this.rowData[n2].data = new Short(this.rowData[n2].getShort(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 1004: {
                            this.rowData[n2].data = new Integer(this.rowData[n2].getInteger(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 1005: {
                            this.rowData[n2].data = new Long(this.rowData[n2].getLong(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 1006: {
                            this.rowData[n2].data = new Float(this.rowData[n2].getFloat(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 1007: {
                            this.rowData[n2].data = new Double(this.rowData[n2].getDouble(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 1008: {
                            this.rowData[n2].data = this.rowData[n2].getBigDecimal(this.implStatement.implConnection.exceptions);
                            break;
                        }
                        case 1009: {
                            this.rowData[n2].data = new Boolean(this.rowData[n2].getBoolean(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 1011: {
                            this.rowData[n2].data = this.rowData[n2].getDate(this.implStatement.implConnection.exceptions);
                            break;
                        }
                        case 1012: {
                            this.rowData[n2].data = this.rowData[n2].getTime(this.implStatement.implConnection.exceptions);
                            break;
                        }
                        case 1013: {
                            this.rowData[n2].data = this.rowData[n2].getTimestamp(this.implStatement.implConnection.exceptions);
                            break;
                        }
                        case 1019: {
                            this.rowData[n2].data = null;
                            break;
                        }
                    }
                    this.rowData[n2].type = n3;
                }
                ++n2;
            }
            bl = true;
        }
        catch (Exception exception) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(exception);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6041);
        }
        return bl;
    }

    public int getColumnAccess() {
        return 2;
    }

    public BaseData getData(int n, int n2) throws SQLException {
        return this.rowData[n - 1];
    }

    public int getScrollType() {
        return 1004;
    }

    private void intializeRow() {
        if (this.rowData == null) {
            this.rowData = new BaseData[this.columns.count(0)];
            int n = 0;
            while (n < this.columns.count(0)) {
                BaseColumn baseColumn = this.columns.get(n + 1);
                this.rowData[n] = new BaseData();
                ++n;
            }
        }
    }

    public boolean positionCursor(int n) throws SQLException {
        boolean bl = this.fetch(n);
        if (bl) {
            this.fetch(n + 1);
        }
        if (bl) {
            bl = n > this.rowsFetchedFromSubResultSet ? false : this.getCachedRow(n - 1);
        }
        return bl;
    }

    public void postSetupInitialize() throws SQLException {
        this.rowDataBuff = new UtilPagedTempBuffer();
        this.rowPositionBuff = new UtilPagedTempBuffer();
        this.byteArrayForReading = new byte[DEFAULT_BUFF_INCREMENT];
        this.setupTempFiles();
        super.postSetupInitialize();
        this.positionCursor(1);
    }

    public void setFetchSize(int n) {
    }

    private void setupTempFiles() throws SQLException {
        try {
            this.longDataFileHandle = UtilTempFile.createTempFile((String)"scb_");
            this.longDataFile = new RandomAccessFile(this.longDataFileHandle, "rw");
        }
        catch (Exception exception) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(exception);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6039);
        }
    }
}

