/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.IllegalAddException;
import org.jdom.Namespace;
import org.jdom.Verifier;

class AttributeList
extends AbstractList
implements List,
Serializable {
    private static final String CVS_ID = "@(#) $RCSfile: AttributeList.java,v $ $Revision: 1.8 $ $Date: 2002/03/20 10:07:54 $ $Name: jdom_1_0_b8 $";
    private static final int INITIAL_ARRAY_SIZE = 3;
    protected ArrayList list;
    protected Element parent;

    private AttributeList() {
    }

    public AttributeList(Element parent) {
        this.parent = parent;
    }

    public void add(int index, Object obj) {
        Attribute attribute;
        if (obj instanceof Attribute) {
            attribute = (Attribute)obj;
            int duplicate = this.indexOfDuplicate(attribute);
            if (duplicate >= 0) {
                throw new IllegalAddException("Cannot add duplicate attribute");
            }
        } else {
            if (obj == null) {
                throw new IllegalAddException("Cannot add null attribute");
            }
            throw new IllegalAddException("Class " + obj.getClass().getName() + " is not an attribute");
        }
        this.add(index, attribute);
        ++this.modCount;
    }

    protected void add(int index, Attribute attribute) {
        if (attribute.getParent() != null) {
            throw new IllegalAddException("The attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"");
        }
        String reason = Verifier.checkNamespaceCollision(attribute, this.parent);
        if (reason != null) {
            throw new IllegalAddException(this.parent, attribute, reason);
        }
        if (this.list == null) {
            if (index == 0) {
                this.ensureCapacity(3);
            } else {
                throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
            }
        }
        this.list.add(index, attribute);
        attribute.setParent(this.parent);
    }

    public boolean add(Object obj) {
        if (obj instanceof Attribute) {
            Attribute attribute = (Attribute)obj;
            int duplicate = this.indexOfDuplicate(attribute);
            if (duplicate < 0) {
                this.add(this.size(), attribute);
            } else {
                this.set(duplicate, attribute);
            }
        } else {
            if (obj == null) {
                throw new IllegalAddException("Cannot add null attribute");
            }
            throw new IllegalAddException("Class " + obj.getClass().getName() + " is not an attribute");
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean addAll(int index, Collection collection) {
        block6: {
            if (this.list == null && index != 0) {
                throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
            }
            if (collection == null || collection.size() == 0) {
                return false;
            }
            count = 0;
            try {
                i = collection.iterator();
                while (i.hasNext()) {
                    obj = i.next();
                    this.add(index + count, (Object)obj);
                    ++count;
                }
                break block6;
            }
            catch (RuntimeException exception) {
                i = 0;
                ** while (i < count)
            }
lbl-1000:
            // 1 sources

            {
                this.remove(index + i);
                ++i;
                continue;
            }
lbl21:
            // 1 sources

            throw exception;
        }
        return true;
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size(), collection);
    }

    public void clear() {
        if (this.list != null) {
            int i = 0;
            while (i < this.list.size()) {
                Attribute attribute = (Attribute)this.list.get(i);
                attribute.setParent(null);
                ++i;
            }
            this.list = null;
        }
        ++this.modCount;
    }

    public void clearAndSet(Collection collection) {
        ArrayList old = this.list;
        this.list = null;
        if (collection != null && collection.size() != 0) {
            this.ensureCapacity(collection.size());
            try {
                this.addAll(0, collection);
            }
            catch (RuntimeException exception) {
                this.list = old;
                throw exception;
            }
        }
        if (old != null) {
            int i = 0;
            while (i < old.size()) {
                Attribute attribute = (Attribute)old.get(i);
                attribute.setParent(null);
                ++i;
            }
        }
    }

    protected void ensureCapacity(int minCapacity) {
        if (this.list == null) {
            this.list = new ArrayList(minCapacity);
        } else {
            this.list.ensureCapacity(minCapacity);
        }
    }

    public Object get(int index) {
        if (this.list == null) {
            throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
        }
        return this.list.get(index);
    }

    protected Object get(String name, Namespace namespace) {
        int index = this.indexOf(name, namespace);
        if (index < 0) {
            return null;
        }
        return this.list.get(index);
    }

    protected int indexOf(String name, Namespace namespace) {
        String uri = namespace.getURI();
        if (this.list != null) {
            int i = 0;
            while (i < this.list.size()) {
                Attribute old = (Attribute)this.list.get(i);
                String oldURI = old.getNamespaceURI();
                String oldName = old.getName();
                if (oldURI.equals(uri) && oldName.equals(name)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private int indexOfDuplicate(Attribute attribute) {
        int duplicate = -1;
        String name = attribute.getName();
        Namespace namespace = attribute.getNamespace();
        duplicate = this.indexOf(name, namespace);
        return duplicate;
    }

    public Object remove(int index) {
        if (this.list == null) {
            throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
        }
        Attribute old = (Attribute)this.list.get(index);
        old.setParent(null);
        ++this.modCount;
        this.list.remove(index);
        return old;
    }

    protected boolean remove(String name, Namespace namespace) {
        int index = this.indexOf(name, namespace);
        if (index < 0) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public Object set(int index, Object obj) {
        if (obj instanceof Attribute) {
            Attribute attribute = (Attribute)obj;
            int duplicate = this.indexOfDuplicate(attribute);
            if (duplicate >= 0 && duplicate != index) {
                throw new IllegalAddException("Cannot set duplicate attribute");
            }
            return this.set(index, attribute);
        }
        if (obj == null) {
            throw new IllegalAddException("Cannot add null attribute");
        }
        throw new IllegalAddException("Class " + obj.getClass().getName() + " is not an attribute");
    }

    protected Object set(int index, Attribute attribute) {
        if (this.list == null) {
            throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
        }
        if (attribute.getParent() != null) {
            throw new IllegalAddException("The attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"");
        }
        String reason = Verifier.checkNamespaceCollision(attribute, this.parent);
        if (reason != null) {
            throw new IllegalAddException(this.parent, attribute, reason);
        }
        Attribute old = (Attribute)this.list.get(index);
        old.setParent(null);
        this.list.set(index, attribute);
        return old;
    }

    public int size() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    public String toString() {
        if (this.list != null && this.list.size() > 0) {
            return this.list.toString();
        }
        return "[]";
    }
}

