/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.Field;
import org.postgresql.jdbc2.Connection;
import org.postgresql.jdbc2.ResultSetMetaData;
import org.postgresql.jdbc2.Statement;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.largeobject.PGblob;
import org.postgresql.largeobject.PGclob;
import org.postgresql.util.PSQLException;

public class ResultSet
extends org.postgresql.ResultSet
implements java.sql.ResultSet {
    protected Statement statement;
    private StringBuffer sbuf;

    public ResultSet(Connection connection, Field[] fieldArray, Vector vector, String string, int n, int n2) {
        super(connection, fieldArray, vector, string, n, n2);
    }

    public ResultSet(Connection connection, Field[] fieldArray, Vector vector, String string, int n) {
        super(connection, fieldArray, vector, string, n, 0);
    }

    public boolean next() throws SQLException {
        if (++this.current_row >= this.rows.size()) {
            return false;
        }
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        return true;
    }

    public void close() throws SQLException {
        if (this.rows != null) {
            this.rows.setSize(0);
            this.rows = null;
        }
    }

    public boolean wasNull() throws SQLException {
        return this.wasNullFlag;
    }

    public String getString(int n) throws SQLException {
        if (n < 1 || n > this.fields.length) {
            throw new PSQLException("postgresql.res.colrange");
        }
        boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        String string = this.connection.getEncoding();
        if (string == null) {
            return new String(this.this_row[n - 1]);
        }
        try {
            return new String(this.this_row[n - 1], string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PSQLException("postgresql.res.encoding", unsupportedEncodingException);
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            char c = string.charAt(0);
            return c == 't' || c == 'T';
        }
        return false;
    }

    public byte getByte(int n) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            try {
                return Byte.parseByte(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badbyte", (Object)string);
            }
        }
        return 0;
    }

    public short getShort(int n) throws SQLException {
        String string = this.getFixedString(n);
        if (string != null) {
            try {
                return Short.parseShort(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badshort", (Object)string);
            }
        }
        return 0;
    }

    public int getInt(int n) throws SQLException {
        String string = this.getFixedString(n);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badint", (Object)string);
            }
        }
        return 0;
    }

    public long getLong(int n) throws SQLException {
        String string = this.getFixedString(n);
        if (string != null) {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badlong", (Object)string);
            }
        }
        return 0L;
    }

    public float getFloat(int n) throws SQLException {
        String string = this.getFixedString(n);
        if (string != null) {
            try {
                return Float.valueOf(string).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badfloat", (Object)string);
            }
        }
        return 0.0f;
    }

    public double getDouble(int n) throws SQLException {
        String string = this.getFixedString(n);
        if (string != null) {
            try {
                return Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.baddouble", (Object)string);
            }
        }
        return 0.0;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        String string = this.getFixedString(n);
        if (string != null) {
            BigDecimal bigDecimal;
            try {
                bigDecimal = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badbigdec", (Object)string);
            }
            if (n2 == -1) {
                return bigDecimal;
            }
            try {
                return bigDecimal.setScale(n2);
            }
            catch (ArithmeticException arithmeticException) {
                throw new PSQLException("postgresql.res.badbigdec", (Object)string);
            }
        }
        return null;
    }

    public byte[] getBytes(int n) throws SQLException {
        if (n < 1 || n > this.fields.length) {
            throw new PSQLException("postgresql.res.colrange");
        }
        boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
        if (!this.wasNullFlag && this.fields[n - 1].getOID() == 26) {
            LargeObjectManager largeObjectManager = this.connection.getLargeObjectAPI();
            LargeObject largeObject = largeObjectManager.open(this.getInt(n));
            byte[] byArray = largeObject.read(largeObject.size());
            largeObject.close();
            return byArray;
        }
        return this.this_row[n - 1];
    }

    public Date getDate(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return Date.valueOf(string);
    }

    public Time getTime(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return Time.valueOf(string);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        boolean bl = string.indexOf(46) != -1;
        ResultSet resultSet = this;
        synchronized (resultSet) {
            if (this.sbuf == null) {
                this.sbuf = new StringBuffer();
            }
            this.sbuf.setLength(0);
            this.sbuf.append(string);
            char c = this.sbuf.charAt(this.sbuf.length() - 3);
            if (c == '+' || c == '-') {
                this.sbuf.setLength(this.sbuf.length() - 3);
                if (bl) {
                    this.sbuf.append('0').append("GMT").append(string.substring(string.length() - 3)).append(":00");
                } else {
                    this.sbuf.append("GMT").append(string.substring(string.length() - 3)).append(":00");
                }
            } else if (bl) {
                this.sbuf.append('0');
            }
            SimpleDateFormat simpleDateFormat = null;
            simpleDateFormat = string.length() > 23 && bl ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSzzzzzzzzz") : (string.length() > 23 && !bl ? new SimpleDateFormat("yyyy-MM-dd HH:mm:sszzzzzzzzz") : (string.length() > 10 && bl ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS") : (string.length() > 10 && !bl ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd"))));
            try {
                Timestamp timestamp = new Timestamp(simpleDateFormat.parse(this.sbuf.toString()).getTime());
                return timestamp;
            }
            catch (ParseException parseException) {
                throw new PSQLException("postgresql.res.badtimestamp", new Integer(parseException.getErrorOffset()), string);
            }
        }
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return this.getBinaryStream(n);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return this.getBinaryStream(n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        if (!this.wasNullFlag && this.fields[n - 1].getOID() == 26) {
            LargeObjectManager largeObjectManager = this.connection.getLargeObjectAPI();
            LargeObject largeObject = largeObjectManager.open(this.getInt(n));
            return largeObject.getInputStream();
        }
        byte[] byArray = this.getBytes(n);
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public String getCursorName() throws SQLException {
        return this.connection.getCursorName();
    }

    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        return new ResultSetMetaData(this.rows, this.fields);
    }

    public Object getObject(int n) throws SQLException {
        if (n < 1 || n > this.fields.length) {
            throw new PSQLException("postgresql.res.colrange");
        }
        boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        Field field = this.fields[n - 1];
        if (field == null) {
            this.wasNullFlag = true;
            return null;
        }
        switch (field.getSQLType()) {
            case -7: {
                return new Boolean(this.getBoolean(n));
            }
            case 5: {
                return new Integer(this.getInt(n));
            }
            case 4: {
                return new Integer(this.getInt(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
            case 2: {
                return this.getBigDecimal(n, field.mod == -1 ? -1 : field.mod - 4 & 0xFFFF);
            }
            case 7: {
                return new Float(this.getFloat(n));
            }
            case 8: {
                return new Double(this.getDouble(n));
            }
            case 1: 
            case 12: {
                return this.getString(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
        }
        return this.connection.getObject(field.getTypeName(), this.getString(n));
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        int n = 0;
        while (n < this.fields.length) {
            if (this.fields[n].name.equalsIgnoreCase(string)) {
                return n + 1;
            }
            ++n;
        }
        throw new PSQLException("postgresql.res.colname", (Object)string);
    }

    public boolean absolute(int n) throws SQLException {
        int n2;
        if (n == 0) {
            throw new SQLException("Cannot move to index of 0");
        }
        if (n < 0) {
            if (n >= -this.rows.size()) {
                n2 = this.rows.size() + n;
            } else {
                this.beforeFirst();
                return false;
            }
        }
        if (n > this.rows.size()) {
            this.afterLast();
            return false;
        }
        n2 = n - 1;
        this.current_row = n2;
        this.this_row = (byte[][])this.rows.elementAt(n2);
        return true;
    }

    public void afterLast() throws SQLException {
        if (this.rows.size() > 0) {
            this.current_row = this.rows.size();
        }
    }

    public void beforeFirst() throws SQLException {
        if (this.rows.size() > 0) {
            this.current_row = -1;
        }
    }

    public void cancelRowUpdates() throws SQLException {
        this.notUpdateable();
    }

    public void deleteRow() throws SQLException {
        this.notUpdateable();
    }

    public boolean first() throws SQLException {
        if (this.rows.size() <= 0) {
            return false;
        }
        this.current_row = 0;
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        return true;
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public Array getArray(int n) throws SQLException {
        throw Driver.notImplemented();
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, 0);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Blob getBlob(int n) throws SQLException {
        return new PGblob(this.connection, this.getInt(n));
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        try {
            String string = this.connection.getEncoding();
            if (string == null) {
                return new InputStreamReader(this.getBinaryStream(n));
            }
            return new InputStreamReader(this.getBinaryStream(n), string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PSQLException("postgresql.res.encoding", unsupportedEncodingException);
        }
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Clob getClob(int n) throws SQLException {
        return new PGclob(this.connection, this.getInt(n));
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        return this.rows.size();
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw Driver.notImplemented();
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public Ref getRef(int n) throws SQLException {
        throw new PSQLException("postgresql.psqlnotimp");
    }

    public int getRow() throws SQLException {
        return this.current_row + 1;
    }

    public java.sql.Statement getStatement() throws SQLException {
        return this.statement;
    }

    public int getType() throws SQLException {
        return 1004;
    }

    public void insertRow() throws SQLException {
        this.notUpdateable();
    }

    public boolean isAfterLast() throws SQLException {
        return this.current_row >= this.rows.size() && this.rows.size() > 0;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.current_row < 0 && this.rows.size() > 0;
    }

    public boolean isFirst() throws SQLException {
        return this.current_row == 0 && this.rows.size() >= 0;
    }

    public boolean isLast() throws SQLException {
        return this.current_row == this.rows.size() - 1 && this.rows.size() > 0;
    }

    public boolean last() throws SQLException {
        if (this.rows.size() <= 0) {
            return false;
        }
        this.current_row = this.rows.size() - 1;
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        return true;
    }

    public void moveToCurrentRow() throws SQLException {
        this.notUpdateable();
    }

    public void moveToInsertRow() throws SQLException {
        this.notUpdateable();
    }

    public boolean previous() throws SQLException {
        if (--this.current_row < 0) {
            return false;
        }
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        return true;
    }

    public void refreshRow() throws SQLException {
        throw new PSQLException("postgresql.notsensitive");
    }

    public boolean relative(int n) throws SQLException {
        return this.absolute(this.current_row + 1 + n);
    }

    public boolean rowDeleted() throws SQLException {
        this.notUpdateable();
        return false;
    }

    public boolean rowInserted() throws SQLException {
        this.notUpdateable();
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        this.notUpdateable();
        return false;
    }

    public void setFetchDirection(int n) throws SQLException {
        throw new PSQLException("postgresql.psqlnotimp");
    }

    public void setFetchSize(int n) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.notUpdateable();
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.notUpdateable();
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.notUpdateable();
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.notUpdateable();
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.notUpdateable();
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.notUpdateable();
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.notUpdateable();
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.notUpdateable();
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.notUpdateable();
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.notUpdateable();
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.notUpdateable();
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.notUpdateable();
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateNull(int n) throws SQLException {
        this.notUpdateable();
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.notUpdateable();
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.notUpdateable();
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateRow() throws SQLException {
        this.notUpdateable();
    }

    public void updateShort(int n, short s) throws SQLException {
        this.notUpdateable();
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateString(int n, String string) throws SQLException {
        this.notUpdateable();
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.notUpdateable();
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.notUpdateable();
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void notUpdateable() throws SQLException {
        throw new PSQLException("postgresql.noupdate");
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }
}

