/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseEscapeTranslator;
import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseSQLParser;
import com.microsoft.jdbc.base.BaseSQLParser_Full;
import com.microsoft.jdbc.base.BaseSQLStringGenerator;
import com.microsoft.jdbc.base.BaseSQLTreeNode;
import com.microsoft.jdbc.base.BaseSQLTreePreOrderTraverser;
import com.microsoft.jdbc.base.BaseSQLTreeTraversalVisitor;
import java.sql.SQLException;

final class BaseSQLEscapeProcessor
implements BaseSQLTreeTraversalVisitor {
    private static String footprint = "$Revision:   1.8.1.0  $";
    private BaseExceptions exceptions;
    private BaseEscapeTranslator translator;
    private BaseSQLTreeNode escapeNode = null;
    private StringBuffer escapeValue;
    private BaseSQLTreeNode whereNode;
    private int escapeLevel;
    int firstEscape = 0;
    private boolean firstEscapeFound = false;
    private boolean firstConstructWasFound = false;
    private boolean firstConstructWasAnEscape = false;

    BaseSQLEscapeProcessor() {
    }

    private void fixupEscapeTranslatedToEscape(BaseSQLTreeNode baseSQLTreeNode) {
        if ((baseSQLTreeNode = baseSQLTreeNode.leftMostChild()) != null && baseSQLTreeNode.type == 1 && (baseSQLTreeNode = baseSQLTreeNode.leftMostChild()) != null && baseSQLTreeNode.type == 2 && (baseSQLTreeNode = baseSQLTreeNode.leftMostChild()) != null && baseSQLTreeNode.type == 4 && (baseSQLTreeNode = baseSQLTreeNode.leftMostChild()) != null && baseSQLTreeNode.type == 15) {
            baseSQLTreeNode.type = 14;
        }
    }

    private String getWhereClause(BaseSQLTreeNode baseSQLTreeNode) throws SQLException {
        boolean bl = true;
        String string = null;
        this.whereNode = null;
        while (baseSQLTreeNode != null && bl) {
            if ((baseSQLTreeNode = baseSQLTreeNode.getParent()) == null || baseSQLTreeNode.type != 6) continue;
            bl = false;
        }
        if (baseSQLTreeNode != null) {
            baseSQLTreeNode = baseSQLTreeNode.getRightSibling();
            if (baseSQLTreeNode.type == 7) {
                bl = false;
            }
        }
        if (baseSQLTreeNode != null) {
            this.whereNode = baseSQLTreeNode;
            BaseSQLStringGenerator baseSQLStringGenerator = new BaseSQLStringGenerator();
            string = baseSQLStringGenerator.generateSQL(baseSQLTreeNode, false, this.exceptions);
            if (string.length() == 0) {
                string = null;
            }
        }
        return string;
    }

    public void processEscapes(BaseSQLTreeNode baseSQLTreeNode, BaseEscapeTranslator baseEscapeTranslator, BaseExceptions baseExceptions) throws SQLException {
        BaseSQLTreePreOrderTraverser baseSQLTreePreOrderTraverser = new BaseSQLTreePreOrderTraverser();
        this.translator = baseEscapeTranslator;
        this.exceptions = baseExceptions;
        this.escapeValue = new StringBuffer();
        this.escapeLevel = -1;
        baseSQLTreePreOrderTraverser.setExceptions(baseExceptions);
        baseSQLTreePreOrderTraverser.setVisitor(this);
        baseSQLTreePreOrderTraverser.traverse(baseSQLTreeNode);
    }

    private void replaceEscape(String string, String string2) throws SQLException {
        if (string != null) {
            BaseSQLParser_Full baseSQLParser_Full = new BaseSQLParser_Full();
            baseSQLParser_Full.setExceptions(this.exceptions);
            BaseSQLTreeNode baseSQLTreeNode = ((BaseSQLParser)baseSQLParser_Full).parse(String.valueOf(string) + " ", '\"');
            this.escapeNode.removeChildren();
            this.escapeNode.setNextChild(baseSQLTreeNode);
            if (this.whereNode != null && string2 != null) {
                baseSQLTreeNode = ((BaseSQLParser)baseSQLParser_Full).parse(string2, '\"');
                this.whereNode.removeChildren();
                this.whereNode.setNextChild(baseSQLTreeNode);
            }
            this.fixupEscapeTranslatedToEscape(this.escapeNode);
        }
    }

    public boolean visit(BaseSQLTreeNode baseSQLTreeNode, int n) throws SQLException {
        if (!this.firstConstructWasFound && baseSQLTreeNode.type != 18 && baseSQLTreeNode.type != 19) {
            if (baseSQLTreeNode.type == 15) {
                this.firstConstructWasFound = true;
                this.firstConstructWasAnEscape = true;
            } else if (baseSQLTreeNode.value != null) {
                this.firstConstructWasFound = true;
                this.firstConstructWasAnEscape = false;
            }
        }
        if (baseSQLTreeNode.type == 15 && this.escapeNode == null) {
            this.escapeNode = baseSQLTreeNode;
            this.escapeLevel = n;
        } else if (this.escapeLevel != -1) {
            if (n <= this.escapeLevel) {
                String string = this.getWhereClause(this.escapeNode);
                int n2 = this.translator.translateEscape(this.escapeValue.toString(), string, this.exceptions);
                if (!this.firstEscapeFound) {
                    if (this.firstConstructWasAnEscape) {
                        this.firstEscape = n2;
                    }
                    this.firstEscapeFound = true;
                }
                this.replaceEscape(this.translator.getTranslation(), this.translator.getNewWhere());
                this.escapeNode.type = 14;
                this.escapeLevel = -1;
                this.escapeValue.setLength(0);
                BaseSQLTreeNode baseSQLTreeNode2 = this.escapeNode;
                this.escapeNode = null;
                this.processEscapes(baseSQLTreeNode2, this.translator, this.exceptions);
            } else if (baseSQLTreeNode.value != null) {
                this.escapeValue.append(baseSQLTreeNode.value);
            }
        }
        return true;
    }
}

