/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.util;

import com.microsoft.util.UtilDataProvider;
import com.microsoft.util.UtilException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;

public class UtilSocketDataProvider
implements UtilDataProvider {
    private static String footprint = "$Revision:   1.8  $";
    private Socket sourceSocket;
    private InputStream socketInputStream = null;
    private int timeoutPeriodForReads;

    public UtilSocketDataProvider(Socket socket) {
        this.sourceSocket = socket;
        this.timeoutPeriodForReads = 0;
    }

    public void empty() throws UtilException {
        byte[] byArray = new byte[1024];
        boolean bl = true;
        while (bl) {
            try {
                this.getArrayOfBytes(byArray, 0, byArray.length);
            }
            catch (UtilException utilException) {
                if (utilException.getReason() == 1001) {
                    bl = false;
                    continue;
                }
                throw utilException;
            }
        }
    }

    public int getArrayOfBytes(byte[] byArray, int n, int n2) throws UtilException {
        if (n2 <= 0) {
            return 0;
        }
        try {
            int n3;
            int n4 = this.sourceSocket.getSoTimeout();
            if (n4 != this.timeoutPeriodForReads) {
                this.sourceSocket.setSoTimeout(this.timeoutPeriodForReads);
            }
            if ((n3 = this.getSocketInputStream().read(byArray, n, n2)) == -1) {
                throw new UtilException(1002);
            }
            if (n4 != this.timeoutPeriodForReads) {
                this.sourceSocket.setSoTimeout(n4);
            }
            return n3;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new UtilException(1001);
        }
        catch (IOException iOException) {
            throw new UtilException(1018, iOException.getMessage());
        }
    }

    public byte getByte() throws UtilException {
        try {
            int n = this.sourceSocket.getSoTimeout();
            if (n != this.timeoutPeriodForReads) {
                this.sourceSocket.setSoTimeout(this.timeoutPeriodForReads);
            }
            int n2 = this.getSocketInputStream().read();
            if (n != this.timeoutPeriodForReads) {
                this.sourceSocket.setSoTimeout(n);
            }
            if (n2 == -1) {
                throw new UtilException(1002);
            }
            return (byte)n2;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new UtilException(1001);
        }
        catch (IOException iOException) {
            throw new UtilException(1018, iOException.getMessage());
        }
    }

    private InputStream getSocketInputStream() throws IOException {
        if (this.socketInputStream == null) {
            this.socketInputStream = this.sourceSocket.getInputStream();
        }
        return this.socketInputStream;
    }

    public void receive() throws UtilException {
    }

    public void setTimeoutValue(int n) {
        this.timeoutPeriodForReads = n;
    }
}

