/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.util;

import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.communication.NodeAgent;
import com.edb.gridsql.util.ParseArgs;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public class XdbAgent {
    private static final String USAGE = "Parameters: -n <node_numbers>\nwhere <node_numbers> is space-separated list of Nodes to launch";

    private static void printUsage() {
        System.out.println(USAGE);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            XdbAgent.printUsage();
            System.exit(-1);
        }
        if (Property.get((String)"log4j.configuration") != null && new File(Property.get((String)"log4j.configuration")).exists()) {
            PropertyConfigurator.configure((String)Property.get((String)"log4j.configuration"));
        } else if (new File("log4j.properties").exists()) {
            PropertyConfigurator.configure((String)"log4j.properties");
        } else {
            PropertyConfigurator.configure((Properties)Property.getProperties());
        }
        Map<String, List<String>> map = null;
        try {
            map = ParseArgs.parse(stringArray, "n");
        }
        catch (Exception exception) {
            XdbAgent.printUsage();
            System.exit(-1);
        }
        ArrayList arrayList = (ArrayList)map.get("-n");
        if (arrayList == null || arrayList.size() == 0) {
            XdbAgent.printUsage();
            System.exit(-1);
        }
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = (String)arrayList.get(i);
                int n = Integer.parseInt(string);
                NodeAgent.getNodeAgent((int)n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            XdbAgent.printUsage();
            System.exit(-1);
        }
    }
}

