/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.protocol;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.protocol.ProtocolManager;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProtocolHandler<T>
implements ProtocolManager {
    private static XLogger logger = XLogger.getLogger(AbstractProtocolHandler.class);
    private HashMap<SocketChannel, T> clients = new HashMap();
    private Executor serviceQueue = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    protected AbstractProtocolHandler() throws IOException {
    }

    public synchronized void addClient(SocketChannel socketChannel) {
        try {
            T t = this.createClient(socketChannel);
            this.clients.put(socketChannel, t);
            if (t instanceof Runnable) {
                this.serviceQueue.execute((Runnable)t);
            }
        }
        catch (Exception exception) {
            logger.catching((Throwable)exception);
            try {
                socketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized void removeClient(SocketChannel socketChannel) {
        T t = this.clients.remove(socketChannel);
        this.closeClient(t);
        logger.debug((Object)("connectedClients=" + this.clients.size()));
    }

    protected Iterator<T> clientIterator() {
        return this.clients.values().iterator();
    }

    protected abstract T createClient(SocketChannel var1) throws Exception;

    protected abstract void closeClient(T var1);
}

