/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.communication;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.communication.AbstractConnector;
import com.edb.gridsql.communication.IMessageListener;
import com.edb.gridsql.communication.message.NodeMessage;
import com.edb.gridsql.exception.XDBUnexpectedMessageException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractAgent
implements IMessageListener {
    private static final XLogger logger = XLogger.getLogger(AbstractAgent.class);
    public static final long MAX_PROCESS_IDLE = 600000L;
    private Map<Integer, ProcessContext> processes = new HashMap<Integer, ProcessContext>();

    protected abstract void init();

    protected abstract void close();

    public abstract AbstractConnector getConnector(Integer var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(NodeMessage nodeMessage) {
        if (nodeMessage == null) {
            return;
        }
        Integer n = nodeMessage.getTargetNodeID();
        if (n != null && this.getNodeID() == n.intValue()) {
            this.processMessage(nodeMessage);
        } else {
            AbstractConnector abstractConnector = this.getConnector(n);
            if (abstractConnector == null) {
                if (n == null) {
                    Collection<Integer> collection = nodeMessage.getNodeList();
                    for (Integer n2 : collection) {
                        NodeMessage nodeMessage2 = (NodeMessage)nodeMessage.clone();
                        nodeMessage2.setTargetNodeID(n2);
                        this.sendMessage(nodeMessage2);
                    }
                }
            } else {
                abstractConnector.enqueueMessage(nodeMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeMessage reply(NodeMessage nodeMessage, int n) {
        NodeMessage nodeMessage2 = null;
        nodeMessage2 = NodeMessage.getNodeMessage(n);
        nodeMessage2.setSourceNodeID(this.getNodeID());
        nodeMessage2.setTargetNodeID(new Integer(nodeMessage.getSourceNodeID()));
        nodeMessage2.setSessionID(nodeMessage.getSessionID());
        nodeMessage2.setRequestId(nodeMessage.getRequestId());
        NodeMessage nodeMessage3 = nodeMessage2;
        return nodeMessage3;
    }

    public abstract int getNodeID();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMessageListener addProcess(Integer n, IMessageListener iMessageListener) {
        ProcessContext processContext = null;
        Object object = this.processes;
        synchronized (object) {
            processContext = this.processes.put(n, new ProcessContext(iMessageListener));
        }
        object = processContext == null ? null : processContext.getListener();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMessageListener removeProcess(Integer n) {
        ProcessContext processContext = null;
        Object object = this.processes;
        synchronized (object) {
            processContext = this.processes.remove(n);
        }
        object = processContext == null ? null : processContext.getListener();
        return object;
    }

    public boolean beforeProcessMessage(NodeMessage nodeMessage) {
        if (nodeMessage.getMessageType() == 14 && nodeMessage.getSessionID() == null) {
            this.sendMessage(this.reply(nodeMessage, 15));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean afterProcessMessage(NodeMessage nodeMessage) {
        block5: {
            block4: {
                if (nodeMessage.getMessageType() != 1) break block4;
                boolean bl = false;
                return bl;
            }
            if (nodeMessage.getMessageType() != 14) break block5;
            boolean bl = false;
            return bl;
        }
        NodeMessage nodeMessage2 = this.reply(nodeMessage, 1);
        nodeMessage2.setCause(new XDBUnexpectedMessageException(this.getNodeID(), "Message is not delivered: target process not found", nodeMessage));
        this.sendMessage(nodeMessage2);
        boolean bl = true;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean processMessage(NodeMessage nodeMessage) {
        block5: {
            block4: {
                if (!this.beforeProcessMessage(nodeMessage)) break block4;
                boolean bl = true;
                return bl;
            }
            if (!this.dispatchMessage(nodeMessage)) break block5;
            boolean bl = true;
            return bl;
        }
        boolean bl = this.afterProcessMessage(nodeMessage);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchMessage(NodeMessage nodeMessage) {
        ProcessContext processContext = null;
        Map<Integer, ProcessContext> map = this.processes;
        synchronized (map) {
            processContext = this.processes.get(nodeMessage.getSessionID());
        }
        if (processContext != null) {
            return processContext.incomingMessage(nodeMessage);
        }
        return false;
    }

    protected class ProcessAnalizer
    implements Runnable {
        protected ProcessAnalizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = AbstractAgent.this.processes;
            synchronized (map) {
                for (Map.Entry entry : AbstractAgent.this.processes.entrySet()) {
                    NodeMessage nodeMessage;
                    ProcessContext processContext = (ProcessContext)entry.getValue();
                    if (processContext.getIdleTime() <= 600000L) continue;
                    if (AbstractAgent.this.getNodeID() == 0 || processContext.pinged) {
                        nodeMessage = NodeMessage.getNodeMessage(4);
                        nodeMessage.setSourceNodeID(AbstractAgent.this.getNodeID());
                        nodeMessage.setTargetNodeID(new Integer(AbstractAgent.this.getNodeID()));
                        nodeMessage.setSessionID((Integer)entry.getKey());
                        AbstractAgent.this.sendMessage(nodeMessage);
                        continue;
                    }
                    nodeMessage = NodeMessage.getNodeMessage(14);
                    nodeMessage.setSourceNodeID(AbstractAgent.this.getNodeID());
                    nodeMessage.setTargetNodeID(new Integer(0));
                    nodeMessage.setSessionID((Integer)entry.getKey());
                    AbstractAgent.this.sendMessage(nodeMessage);
                }
            }
        }
    }

    private class ProcessContext {
        private IMessageListener listener;
        private long timestamp;
        private boolean pinged = false;

        public ProcessContext(IMessageListener iMessageListener) {
            this.listener = iMessageListener;
            this.timestamp = System.currentTimeMillis();
        }

        public synchronized boolean incomingMessage(NodeMessage nodeMessage) {
            boolean bl = this.listener.processMessage(nodeMessage);
            if (bl) {
                this.timestamp = System.currentTimeMillis();
                if (this.pinged && nodeMessage.getSourceNodeID() == 0 && nodeMessage.getMessageType() != 1) {
                    this.pinged = false;
                }
            }
            return bl;
        }

        public synchronized long getIdleTime() {
            return System.currentTimeMillis() - this.timestamp;
        }

        public IMessageListener getListener() {
            return this.listener;
        }
    }
}

