/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.communication;

import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.communication.AbstractAgent;
import com.edb.gridsql.communication.AbstractConnector;
import com.edb.gridsql.communication.ConnectorFactory;
import com.edb.gridsql.communication.LocalConnector;
import com.edb.gridsql.communication.message.NodeMessage;
import com.edb.gridsql.engine.CoordinatorPools;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.Node;
import com.edb.gridsql.metadata.SysDatabase;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import org.apache.log4j.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinatorAgent
extends AbstractAgent {
    private static final XLogger logger = XLogger.getLogger(CoordinatorAgent.class);
    private static final XLogger serverLogger = XLogger.getLogger("Server");
    private static CoordinatorAgent agent = null;
    private AbstractConnector[] nodeConnectors;
    private AbstractConnector broadcastConnector = null;

    private CoordinatorAgent() {
    }

    @Override
    public int getNodeID() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void init() throws XDBServerException {
        try {
            try {
                Collection<Node> collection = MetaData.getMetaData().getNodes();
                this.nodeConnectors = new AbstractConnector[collection.size()];
                for (Node node : collection) {
                    AbstractConnector abstractConnector;
                    this.nodeConnectors[node.getNodeid() - 1] = abstractConnector = ConnectorFactory.getConnector(0, node.getNodeid());
                    abstractConnector.addMessageListener(this);
                    abstractConnector.start();
                }
                this.broadcastConnector = ConnectorFactory.getBroadcastConnector(0);
                if (this.broadcastConnector != null) {
                    this.broadcastConnector.addMessageListener(this);
                    this.broadcastConnector.start();
                }
            }
            catch (Exception exception) {
                logger.catching(exception);
                XDBServerException xDBServerException = new XDBServerException("Exception during Agent initialization", exception);
                logger.throwing(xDBServerException);
                throw xDBServerException;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void close() {
        try {
            if (this.broadcastConnector != null) {
                this.broadcastConnector.destroy();
                this.broadcastConnector.removeMessageListener(this);
            }
            for (AbstractConnector abstractConnector : this.nodeConnectors) {
                abstractConnector.destroy();
                abstractConnector.removeMessageListener(this);
            }
            this.nodeConnectors = null;
            serverLogger.info("*** Coordinator agent is stopped");
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized AbstractConnector getConnector(Integer n) {
        AbstractConnector abstractConnector = null;
        try {
            if (n == null) {
                try {
                    abstractConnector = this.broadcastConnector;
                }
                catch (Exception exception) {}
            } else {
                int n2 = n;
                if (n2 > 0 && n2 <= this.nodeConnectors.length) {
                    abstractConnector = this.nodeConnectors[n2 - 1];
                }
            }
            AbstractConnector abstractConnector2 = abstractConnector;
            Object var5_6 = null;
            return abstractConnector2;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean beforeProcessMessage(NodeMessage nodeMessage) {
        try {
            switch (nodeMessage.getMessageType()) {
                case 112: {
                    try {
                        Object object;
                        Node node = MetaData.getMetaData().getNode(nodeMessage.getSourceNodeID());
                        serverLogger.log(Level.INFO, "Coordinator: Node %0% is connected", new Object[]{new Integer(nodeMessage.getSourceNodeID())});
                        NodeMessage nodeMessage2 = this.reply(nodeMessage, 44);
                        Properties properties = Property.getProperties();
                        Enumeration<?> enumeration = properties.propertyNames();
                        while (enumeration.hasMoreElements()) {
                            object = (String)enumeration.nextElement();
                            String string = properties.getProperty((String)object);
                            if (!nodeMessage2.canAddRows()) {
                                this.sendMessage(nodeMessage2);
                                nodeMessage2 = this.reply(nodeMessage, 44);
                            }
                            nodeMessage2.addRowData((String)object + "=" + string);
                        }
                        this.sendMessage(nodeMessage2);
                        this.sendMessage(this.reply(nodeMessage, 113));
                        object = node.setUp().iterator();
                        while (object.hasNext()) {
                            this.connectTo((DBNode)object.next());
                        }
                        return true;
                    }
                    catch (Exception exception) {
                        logger.catching(exception);
                    }
                    return true;
                }
                case 13: {
                    try {
                        Node node = MetaData.getMetaData().getNode(nodeMessage.getSourceNodeID());
                        String string = nodeMessage.getDatabase();
                        node.getDBNode(string).setOnline();
                        if (!MetaData.getMetaData().getSysDatabase(string).isOnline()) return true;
                        serverLogger.log(Level.INFO, "*** Database %0% is now online", new Object[]{nodeMessage.getDatabase()});
                        return true;
                    }
                    catch (Exception exception) {
                        logger.catching(exception);
                    }
                    return true;
                }
                case 63: {
                    try {
                        Node node = MetaData.getMetaData().getNode(nodeMessage.getSourceNodeID());
                        String string = nodeMessage.getDatabase();
                        if (string == null) {
                            node.setDown();
                            return true;
                        } else {
                            DBNode dBNode = node.getDBNode(string);
                            if (dBNode != null) {
                                dBNode.setOffline();
                            }
                            if (MetaData.getMetaData().getSysDatabase(nodeMessage.getDatabase()).isOnline()) return true;
                            serverLogger.log(Level.INFO, "*** Database %0% is now offline", new Object[]{nodeMessage.getDatabase()});
                        }
                        return true;
                    }
                    catch (Exception exception) {
                        logger.catching(exception);
                    }
                    return true;
                }
                default: {
                    return super.beforeProcessMessage(nodeMessage);
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_24 = null;
            throw throwable;
        }
    }

    public void initDatabase(String string) throws XDBServerException {
        SysDatabase sysDatabase = MetaData.getMetaData().getSysDatabase(string);
        CoordinatorPools.initPool(string, sysDatabase.getCoordinatorNodeID());
        this.connectToDatabase(sysDatabase);
    }

    public void connectToDatabase(SysDatabase sysDatabase) throws XDBServerException {
        Iterator<DBNode> iterator = sysDatabase.start().iterator();
        while (iterator.hasNext()) {
            this.connectTo(iterator.next());
        }
    }

    public void shutdownDatabase(SysDatabase sysDatabase) throws XDBServerException {
        this.disconnectFrom(sysDatabase.stop());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectTo(DBNode dBNode) {
        try {
            Node node = dBNode.getNode();
            SysDatabase sysDatabase = dBNode.getDatabase();
            NodeMessage nodeMessage = NodeMessage.getNodeMessage(12);
            nodeMessage.setTargetNodeID(new Integer(node.getNodeid()));
            nodeMessage.setSourceNodeID(this.getNodeID());
            nodeMessage.setDatabase(sysDatabase.getDbname());
            nodeMessage.setJdbcDriver(node.getSJdbcDriver());
            nodeMessage.setJdbcString(dBNode.getJdbcString());
            nodeMessage.setJdbcUser(node.getJdbcUser());
            nodeMessage.setJdbcPassword(node.getJdbcPassword());
            nodeMessage.setMaxConns(dBNode.getPoolSize());
            nodeMessage.setTimeOut(dBNode.getPoolTimeout());
            this.sendMessage(nodeMessage);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }

    public void disconnectFrom(Collection<DBNode> collection) throws XDBServerException {
        for (DBNode dBNode : collection) {
            this.disconnectFrom(dBNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectFrom(DBNode dBNode) {
        try {
            Node node = dBNode.getNode();
            SysDatabase sysDatabase = dBNode.getDatabase();
            NodeMessage nodeMessage = NodeMessage.getNodeMessage(62);
            nodeMessage.setTargetNodeID(new Integer(node.getNodeid()));
            nodeMessage.setSourceNodeID(this.getNodeID());
            nodeMessage.setDatabase(sysDatabase.getDbname());
            this.sendMessage(nodeMessage);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetNodes(boolean bl) {
        try {
            for (Node node : MetaData.getMetaData().getNodes()) {
                Integer n = node.getNodeid();
                if (bl && this.getConnector(n) instanceof LocalConnector) continue;
                NodeMessage nodeMessage = NodeMessage.getNodeMessage(62);
                nodeMessage.setTargetNodeID(n);
                nodeMessage.setSourceNodeID(this.getNodeID());
                nodeMessage.setSqlCommand(bl ? "RESTART" : "SHUTDOWN");
                this.sendMessage(nodeMessage);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            throw throwable;
        }
    }

    public static final CoordinatorAgent getInstance() {
        if (agent == null) {
            agent = new CoordinatorAgent();
            try {
                agent.init();
            }
            catch (XDBServerException xDBServerException) {
                logger.catching(xDBServerException);
                agent = null;
                throw xDBServerException;
            }
        }
        return agent;
    }

    public static final void releaseInstance() {
        if (agent != null) {
            agent.close();
            agent = null;
        }
    }
}

