/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.communication;

import com.edb.gridsql.communication.AbstractAgent;
import com.edb.gridsql.communication.message.NodeMessage;
import com.edb.gridsql.metadata.DBNode;
import java.util.Collection;

public class SendMessageHelper {
    private int nodeID;
    private Integer sessionID;
    private AbstractAgent agent;

    public SendMessageHelper(int n, Integer n2, AbstractAgent abstractAgent) {
        this.nodeID = n;
        this.sessionID = n2;
        this.agent = abstractAgent;
    }

    public void sendMessage(Integer n, int n2, int n3) {
        NodeMessage nodeMessage = NodeMessage.getNodeMessage(n2);
        nodeMessage.setRequestId(n3);
        this.sendMessage(n, nodeMessage);
    }

    public void sendMessage(Integer n, NodeMessage nodeMessage) {
        nodeMessage.setSourceNodeID(this.nodeID);
        nodeMessage.setSessionID(this.sessionID);
        nodeMessage.setTargetNodeID(n);
        this.agent.sendMessage(nodeMessage);
    }

    public void sendMessageByDestInMessage(NodeMessage nodeMessage) {
        nodeMessage.setSourceNodeID(this.nodeID);
        nodeMessage.setSessionID(this.sessionID);
        this.agent.sendMessage(nodeMessage);
    }

    public void sendMessageToList(Collection collection, int n, int n2) {
        NodeMessage nodeMessage = NodeMessage.getNodeMessage(n);
        nodeMessage.setRequestId(n2);
        this.sendMessageToList(collection, nodeMessage);
    }

    public void sendMessageToList(Collection collection, NodeMessage nodeMessage) {
        Integer[] integerArray = new Integer[collection.size()];
        int n = 0;
        for (Object e : collection) {
            integerArray[n++] = e instanceof DBNode ? new Integer(((DBNode)e).getNode().getNodeid()) : (Integer)e;
        }
        nodeMessage.setSourceNodeID(this.nodeID);
        nodeMessage.setSessionID(this.sessionID);
        nodeMessage.setTargetNodeIDs(integerArray);
        this.agent.sendMessage(nodeMessage);
    }

    public void sendReplyMessage(NodeMessage nodeMessage, int n) {
        NodeMessage nodeMessage2 = NodeMessage.getNodeMessage(n);
        this.sendReplyMessage(nodeMessage, nodeMessage2);
    }

    public void sendReplyMessage(NodeMessage nodeMessage, NodeMessage nodeMessage2) {
        nodeMessage2.setSessionID(nodeMessage.getSessionID());
        nodeMessage2.setRequestId(nodeMessage.getRequestId());
        nodeMessage2.setSourceNodeID(this.nodeID);
        this.sendMessage(new Integer(nodeMessage.getSourceNodeID()), nodeMessage2);
    }
}

