/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.communication;

import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.communication.AbstractConnector;
import com.edb.gridsql.communication.message.NodeMessage;
import com.edb.gridsql.exception.XDBServerException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Level;

public class SocketConnector
extends AbstractConnector {
    private static final XLogger logger = XLogger.getLogger(SocketConnector.class);
    private int nodeID;
    private int port;
    private HashMap<Integer, SocketChannel> channels = new HashMap();
    private HashSet<SocketChannel> newChannels = new HashSet();
    private HashSet<SocketChannel> toRegister = new HashSet();
    private Selector selector = null;
    private ServerSocketChannel server = null;
    private Selector serverSelector = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketConnector(int n) {
        try {
            this.nodeID = n;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    private void listen() throws IOException, ClosedChannelException {
        String string = this.nodeID == 0 ? "xdb.coordinator.port" : "xdb.node." + this.nodeID + ".port";
        this.port = Property.getInt(string, -1);
        if (this.port != -1) {
            this.serverSelector = Selector.open();
            this.server = ServerSocketChannel.open();
            this.server.configureBlocking(false);
            this.server.socket().bind(new InetSocketAddress(this.port));
            this.server.register(this.serverSelector, 16);
            this.addWorkerThread(new AcceptingThread());
        }
    }

    public void start() throws XDBServerException {
        if (this.server == null) {
            try {
                this.listen();
            }
            catch (IOException iOException) {
                logger.catching(iOException);
                XDBServerException xDBServerException = new XDBServerException("Failed to initialize listening, can not start", iOException);
                logger.throwing(xDBServerException);
                throw xDBServerException;
            }
            try {
                this.selector = Selector.open();
            }
            catch (IOException iOException) {
                logger.catching(iOException);
                XDBServerException xDBServerException = new XDBServerException("Failed to open selector, can not start", iOException);
                logger.throwing(xDBServerException);
                throw xDBServerException;
            }
            this.addWorkerThread(new SendingThread());
            this.addWorkerThread(new ReceivingThread());
            this.addWorkerThread(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            super.destroy();
            try {
                this.selector.close();
                this.serverSelector.close();
                this.server.close();
                HashMap<Integer, SocketChannel> hashMap = this.channels;
                synchronized (hashMap) {
                    for (SocketChannel socketChannel : this.newChannels) {
                        socketChannel.close();
                    }
                    this.newChannels.clear();
                    for (SocketChannel socketChannel : this.channels.values()) {
                        socketChannel.close();
                    }
                    this.channels.clear();
                }
            }
            catch (IOException iOException) {
                logger.catching(iOException);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerChannel(SocketChannel socketChannel) {
        try {
            HashMap<Integer, SocketChannel> hashMap = this.channels;
            synchronized (hashMap) {
                this.newChannels.add(socketChannel);
                this.toRegister.add(socketChannel);
            }
            this.selector.wakeup();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerChannel(Integer n, SocketChannel socketChannel) {
        try {
            HashMap<Integer, SocketChannel> hashMap = this.channels;
            synchronized (hashMap) {
                SocketChannel socketChannel2 = this.channels.put(n, socketChannel);
                try {
                    if (socketChannel2 != null) {
                        socketChannel2.close();
                    }
                }
                catch (IOException iOException) {
                    logger.catching(iOException);
                }
                this.toRegister.add(socketChannel);
            }
            this.selector.wakeup();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelector() {
        try {
            HashMap<Integer, SocketChannel> hashMap = this.channels;
            synchronized (hashMap) {
                for (SocketChannel socketChannel : this.toRegister) {
                    try {
                        socketChannel.register(this.selector, 1);
                    }
                    catch (ClosedChannelException closedChannelException) {
                        logger.catching(closedChannelException);
                        this.closeChannel(socketChannel);
                    }
                }
                this.toRegister.clear();
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeChannel(SocketChannel socketChannel) {
        try {
            HashMap<Integer, SocketChannel> hashMap = this.channels;
            synchronized (hashMap) {
                if (!this.newChannels.remove(socketChannel)) {
                    Iterator<Map.Entry<Integer, SocketChannel>> iterator = this.channels.entrySet().iterator();
                    while (iterator.hasNext()) {
                        if (!socketChannel.equals(iterator.next().getValue())) continue;
                        iterator.remove();
                        break;
                    }
                }
            }
            try {
                socketChannel.close();
            }
            catch (IOException iOException) {
                logger.catching(iOException);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            throw throwable;
        }
    }

    static /* synthetic */ Selector access$700(SocketConnector socketConnector) {
        return socketConnector.serverSelector;
    }

    static /* synthetic */ void access$800(SocketConnector socketConnector, SocketChannel socketChannel) {
        socketConnector.registerChannel(socketChannel);
    }

    protected class AcceptingThread
    implements Runnable {
        protected AcceptingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            try {
                while (true) {
                    try {
                        block5: while (true) {
                            if (SocketConnector.access$700(SocketConnector.this).select() <= 0) {
                                continue;
                            }
                            var1_1 = SocketConnector.access$700(SocketConnector.this).selectedKeys().iterator();
                            while (true) {
                                if (var1_1.hasNext()) ** break;
                                continue block5;
                                var2_3 = var1_1.next();
                                var1_1.remove();
                                if (!var2_3.isAcceptable()) continue;
                                var3_4 = (ServerSocketChannel)var2_3.channel();
                                var4_5 = var3_4.accept();
                                var4_5.configureBlocking(false);
                                SocketConnector.access$800(SocketConnector.this, var4_5);
                            }
                            break;
                        }
                    }
                    catch (IOException var1_2) {
                        if (!Thread.currentThread().isInterrupted()) {
                            SocketConnector.access$200().catching(var1_2);
                            continue;
                        }
                        var6_6 = null;
                    }
                    break;
                }
            }
            catch (Throwable var5_8) {
                var6_7 = null;
                throw var5_8;
            }
        }
    }

    protected class SendingThread
    extends AbstractConnector.AbstractSendingThread {
        protected SendingThread() {
            super(SocketConnector.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void send(NodeMessage nodeMessage) throws Exception {
            try {
                Integer n = nodeMessage.getTargetNodeID();
                SocketChannel socketChannel = null;
                boolean bl = true;
                try {
                    HashMap hashMap = SocketConnector.this.channels;
                    synchronized (hashMap) {
                        socketChannel = (SocketChannel)SocketConnector.this.channels.get(n);
                    }
                    if (socketChannel == null) {
                        int n2 = n;
                        String string = n2 == 0 ? "xdb.coordinator" : "xdb.node." + n2;
                        String string2 = Property.get(string + ".host");
                        int n3 = Property.getInt(string + ".port", -1);
                        InetAddress inetAddress = InetAddress.getByName(string2);
                        socketChannel = SocketChannel.open();
                        socketChannel.configureBlocking(false);
                        bl = socketChannel.connect(new InetSocketAddress(inetAddress, n3));
                        SocketConnector.this.registerChannel(n, socketChannel);
                    }
                    while (!bl) {
                        bl = socketChannel.finishConnect();
                        Thread.sleep(1L);
                    }
                    this.write(socketChannel, nodeMessage);
                }
                catch (Exception exception) {
                    if (socketChannel != null) {
                        SocketConnector.this.closeChannel(socketChannel);
                    }
                    throw exception;
                }
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void write(SocketChannel socketChannel, NodeMessage nodeMessage) throws Exception {
            try {
                byte[] byArray = NodeMessage.getBytes(nodeMessage);
                byte[] byArray2 = new byte[4 + byArray.length];
                byArray2[0] = (byte)(byArray.length >> 24 & 0xFF);
                byArray2[1] = (byte)(byArray.length >> 16 & 0xFF);
                byArray2[2] = (byte)(byArray.length >> 8 & 0xFF);
                byArray2[3] = (byte)(byArray.length & 0xFF);
                System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
                socketChannel.write(byteBuffer);
                while (byteBuffer.hasRemaining()) {
                    socketChannel.write(byteBuffer);
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendFailed(NodeMessage nodeMessage, Exception exception) {
            try {
                block7: {
                    if (nodeMessage.getMessageType() == 112) {
                        while (true) {
                            try {
                                Thread.sleep(1000L);
                                this.send(nodeMessage);
                                break block7;
                            }
                            catch (InterruptedException interruptedException) {
                                break block7;
                            }
                            catch (Exception exception2) {
                                continue;
                            }
                            break;
                        }
                    }
                    super.sendFailed(nodeMessage, exception);
                }
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                throw throwable;
            }
        }
    }

    protected class ReceivingThread
    extends AbstractConnector.AbstractReceivingThread {
        private boolean hasData;

        protected ReceivingThread() {
            super(SocketConnector.this);
            this.hasData = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected NodeMessage[] receive() throws Exception {
            LinkedList<NodeMessage> linkedList = new LinkedList<NodeMessage>();
            int n = SocketConnector.this.selector.select();
            SocketConnector.this.updateSelector();
            if (n > 0) {
                Iterator<SelectionKey> iterator = SocketConnector.this.selector.selectedKeys().iterator();
                while (iterator.hasNext()) {
                    Object var12_10;
                    SelectionKey selectionKey = iterator.next();
                    iterator.remove();
                    if (!selectionKey.isReadable()) continue;
                    this.hasData = false;
                    try {
                        NodeMessage nodeMessage = this.read(selectionKey);
                        logger.log(Level.DEBUG, "Read data from channel %0%, got message %1%", new Object[]{selectionKey.channel(), nodeMessage});
                        if (nodeMessage != null) {
                            HashMap hashMap = SocketConnector.this.channels;
                            synchronized (hashMap) {
                                SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
                                if (SocketConnector.this.newChannels.remove(socketChannel)) {
                                    SocketChannel socketChannel2 = SocketConnector.this.channels.put(new Integer(nodeMessage.getSourceNodeID()), socketChannel);
                                    try {
                                        if (socketChannel2 != null) {
                                            socketChannel2.close();
                                        }
                                    }
                                    catch (IOException iOException) {
                                        logger.catching(iOException);
                                    }
                                }
                            }
                        }
                        while (nodeMessage != null) {
                            linkedList.add(nodeMessage);
                            nodeMessage = this.read(selectionKey);
                        }
                        var12_10 = null;
                        if (this.hasData) continue;
                    }
                    catch (Throwable throwable) {
                        var12_10 = null;
                        if (!this.hasData) {
                            SocketConnector.this.closeChannel((SocketChannel)selectionKey.channel());
                        }
                        throw throwable;
                    }
                    SocketConnector.this.closeChannel((SocketChannel)selectionKey.channel());
                    {
                    }
                }
            }
            return linkedList.toArray(new NodeMessage[linkedList.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private NodeMessage read(SelectionKey selectionKey) {
            try {
                ByteBuffer byteBuffer;
                SocketChannel socketChannel;
                block12: {
                    block11: {
                        socketChannel = (SocketChannel)selectionKey.channel();
                        byteBuffer = (ByteBuffer)selectionKey.attachment();
                        if (byteBuffer == null) {
                            byteBuffer = ByteBuffer.allocate(4);
                        }
                        if (byteBuffer.capacity() != 4) break block11;
                        if (socketChannel.read(byteBuffer) > 0) {
                            this.hasData = true;
                        }
                        if (byteBuffer.position() == 4) {
                            Object object = byteBuffer.array();
                            int n = (object[0] & 0xFF) << 24 | (object[1] & 0xFF) << 16 | (object[2] & 0xFF) << 8 | object[3] & 0xFF;
                            byte[] byArray = new byte[n + 4];
                            System.arraycopy(object, 0, byArray, 0, 4);
                            byteBuffer = ByteBuffer.wrap(byArray, 4, n);
                            break block11;
                        }
                        selectionKey.attach(byteBuffer);
                        return null;
                    }
                    if (socketChannel.read(byteBuffer) > 0) {
                        this.hasData = true;
                    }
                    if (byteBuffer.position() != byteBuffer.limit()) break block12;
                    selectionKey.attach(null);
                    return NodeMessage.decodeBytes(byteBuffer.array(), 4, byteBuffer.position() - 4);
                }
                try {
                    selectionKey.attach(byteBuffer);
                    return null;
                }
                catch (IOException iOException) {
                    SocketConnector.this.closeChannel(socketChannel);
                    return null;
                }
                catch (Throwable throwable) {
                    logger.catching(throwable);
                    SocketConnector.this.closeChannel(socketChannel);
                    return null;
                }
            }
            catch (Throwable throwable) {
                Object var8_15 = null;
                throw throwable;
            }
        }
    }
}

