/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.constraintchecker;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.constraintchecker.IConstraintChecker;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IExecutable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.ILockCost;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConstraintChecker
implements IConstraintChecker,
ILockCost {
    private static final XLogger logger = XLogger.getLogger(AbstractConstraintChecker.class);
    protected static final int VIOLATE_IF_EMPTY = 1;
    protected static final int VIOLATE_IF_NOT_EMPTY = 2;
    protected XDBSessionContext client;
    protected SysTable targetTable;
    protected SysTable tempTable;
    private Collection keysToCheck;
    private Map<IExecutable, ViolationCriteria> validateSQL;

    public AbstractConstraintChecker(SysTable sysTable, XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.targetTable = sysTable;
    }

    @Override
    public final Collection<SysColumn> scanConstraints(Collection<SysColumn> collection) {
        this.keysToCheck = new LinkedList();
        return this.scanConstraints(collection, this.keysToCheck);
    }

    protected abstract Collection<SysColumn> scanConstraints(Collection<SysColumn> var1, Collection var2);

    @Override
    public void setTempTable(SysTable sysTable) {
        this.tempTable = sysTable;
    }

    @Override
    public boolean isPrepared() {
        return this.validateSQL != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws Exception {
        try {
            List<SysColumn> list = Collections.emptyList();
            if (this.keysToCheck == null) {
                this.scanConstraints(list);
            }
            this.validateSQL = new HashMap<IExecutable, ViolationCriteria>();
            try {
                Iterator iterator = this.keysToCheck.iterator();
                while (iterator.hasNext()) {
                    this.validateSQL.putAll(this.prepareConstraint(iterator.next()));
                }
            }
            catch (Exception exception) {
                logger.catching(exception);
                this.validateSQL = null;
                logger.throwing(exception);
                throw exception;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            throw throwable;
        }
    }

    protected abstract Map<IExecutable, ViolationCriteria> prepareConstraint(Object var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        try {
            if (!this.isPrepared()) {
                this.prepare();
            }
            Object object = this.validateSQL.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry<IExecutable, ViolationCriteria> entry;
                Map.Entry<IExecutable, ViolationCriteria> entry2 = entry = object.next();
                IExecutable iExecutable = entry2.getKey();
                ViolationCriteria violationCriteria = entry2.getValue();
                this.checkViolation(engine, iExecutable, violationCriteria);
            }
            object = this.getReport();
            Object var8_7 = null;
            return object;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkViolation(Engine engine, IExecutable iExecutable, ViolationCriteria violationCriteria) throws Exception {
        boolean bl = true;
        ResultSet resultSet = iExecutable.execute(engine).getResultSet();
        try {
            boolean bl2 = resultSet.next();
            if (violationCriteria.violationType == 1) {
                bl = !bl2;
            } else if (violationCriteria.violationType == 2) {
                bl = bl2;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            resultSet.close();
            throw throwable;
        }
        resultSet.close();
        if (bl) {
            throw new XDBServerException("Constraint violation: " + violationCriteria.message);
        }
    }

    protected ExecutionResult getReport() throws Exception {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.keysToCheck == null || this.keysToCheck.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCost() {
        try {
            try {
                if (!this.isPrepared()) {
                    this.prepare();
                }
            }
            catch (Exception exception) {
                logger.catching(exception);
            }
            long l = 1L;
            for (IExecutable iExecutable : this.validateSQL.keySet()) {
                if (!(iExecutable instanceof ILockCost)) continue;
                l += ((ILockCost)((Object)iExecutable)).getCost();
            }
            long l2 = l;
            Object var6_6 = null;
            return l2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        try {
            try {
                if (!this.isPrepared()) {
                    this.prepare();
                }
            }
            catch (Exception exception) {
                logger.catching(exception);
            }
            LockSpecification<SysTable> lockSpecification = new LockSpecification<SysTable>();
            for (IExecutable iExecutable : this.validateSQL.keySet()) {
                if (!(iExecutable instanceof ILockCost)) continue;
                lockSpecification.addAll(((ILockCost)((Object)iExecutable)).getLockSpecs());
            }
            LockSpecification<SysTable> lockSpecification2 = lockSpecification;
            Object var5_5 = null;
            return lockSpecification2;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            throw throwable;
        }
    }

    @Override
    public boolean needCoordinatorConnection() {
        return true;
    }

    protected class ViolationCriteria {
        public int violationType;
        public String message;

        protected ViolationCriteria() {
        }
    }
}

