/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLevel;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.communication.IMessageListener;
import com.edb.gridsql.communication.NodeAgent;
import com.edb.gridsql.communication.SendMessageHelper;
import com.edb.gridsql.communication.message.NodeMessage;
import com.edb.gridsql.engine.JDBCPool;
import com.edb.gridsql.engine.NodeProducerThread;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBBaseException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.exception.XDBUnexpectedMessageException;
import com.edb.gridsql.exception.XDBUnexpectedStateException;
import com.edb.gridsql.exception.XDBWrappedException;
import com.edb.gridsql.exception.XDBWrappedSQLException;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.planner.StepDetail;
import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class NodeThread
implements Runnable,
IMessageListener {
    private static final XLogger logger = XLogger.getLogger(NodeThread.class);
    private static final boolean USEBATCHES = true;
    private static final boolean AUTOCOMMIT = false;
    private static final int BATCHSIZE = 1000;
    private static final int STATEDONE = -3;
    private static final int STATEDISCONNECTED = -1;
    private static final int STATEWAIT = 0;
    private static final int STATECOMMAND = 1;
    private static final int STATEBEGINTRAN = 2;
    private static final int STATECOMMIT = 3;
    private static final int STATEROLLBACK = 4;
    private static final int STATEENDTRAN = 5;
    private static final int STATESTEP = 8;
    private static final int STATEDATADOWN = 9;
    private static final int STATESTEPEND = 10;
    private static final int freeInterval = Property.getInt("xdb.memory.freeinterval", 0);
    private int currentState;
    private int nodeId;
    private volatile int requestIDtoAbort = -1;
    private StepDetail aStepDetail;
    private Connection oConn;
    private LinkedBlockingQueue<NodeMessage> msgQueue = new LinkedBlockingQueue();
    private LinkedBlockingQueue<NodeMessage> producerQueue = new LinkedBlockingQueue();
    private Statement batchStatement = null;
    private int iCount;
    private String downTableName;
    private String baseInsert;
    private JDBCPool currentPool;
    private SendMessageHelper sendHelper;
    private HashMap<String, Savepoint> savepointTable;
    HashSet<String> tempTableNames = new HashSet();
    private volatile Statement aStatement = null;
    private boolean isTaking;
    private int lastMessageType = -1;
    private NodeProducerThread aNodeProducerThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeThread(int n) {
        try {
            this.savepointTable = new HashMap();
            this.nodeId = n;
            this.currentState = -1;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset(Integer n, JDBCPool jDBCPool) throws XDBBaseException {
        try {
            try {
                Serializable serializable;
                int n2;
                for (n2 = 0; this.currentState != -1 && this.currentState != 0 && this.currentState != -3 && n2 <= 10; ++n2) {
                    try {
                        this.wait(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        logger.catching(interruptedException);
                    }
                }
                n2 = 0;
                while (this.currentState != -1 && this.currentState != 0 && this.currentState != -3) {
                    XLogger.getLogger("Server").warn(" NodeThread in inconsistent state during reset.  State = " + this.currentState);
                    this.kill();
                    try {
                        this.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.catching(interruptedException);
                    }
                    if (n2 >= 6) {
                        serializable = new XDBUnexpectedStateException(this.nodeId, this.currentState, new int[]{0, -1});
                        logger.throwing((Throwable)serializable);
                        throw serializable;
                    }
                    ++n2;
                }
                if (this.currentState == -3) {
                    XDBUnexpectedStateException xDBUnexpectedStateException = new XDBUnexpectedStateException(this.nodeId, -3, new int[]{0, -1});
                    logger.throwing(xDBUnexpectedStateException);
                    throw xDBUnexpectedStateException;
                }
                if (n != null) {
                    this.sendHelper = new SendMessageHelper(this.nodeId, n, NodeAgent.getNodeAgent(this.nodeId));
                }
                n2 = 0;
                if (this.oConn != null) {
                    try {
                        this.oConn.rollback();
                    }
                    catch (SQLException sQLException) {
                        n2 = 1;
                        logger.catching(sQLException);
                    }
                    serializable = this.tempTableNames;
                    synchronized (serializable) {
                        for (String string : this.tempTableNames) {
                            try {
                                this.doProcessSqlCommand("DROP TABLE " + IdentifierHandler.quote(string), true);
                            }
                            catch (Throwable throwable) {}
                        }
                        this.tempTableNames.clear();
                    }
                }
                this.savepointTable.clear();
                if (this.oConn != null) {
                    if (n2 != 0) {
                        this.currentPool.destroyConnection(this.oConn);
                    } else {
                        this.currentPool.releaseConnection(this.oConn);
                    }
                    this.oConn = null;
                }
                this.currentPool = jDBCPool;
                if (this.currentPool != null) {
                    this.oConn = this.currentPool.getConnection();
                    this.setState(0);
                } else {
                    this.setState(-1);
                }
                if (this.aNodeProducerThread != null) {
                    this.aNodeProducerThread.reset();
                }
                this.requestIDtoAbort = -1;
            }
            catch (Exception exception) {
                logger.catching(exception);
                if (this.currentPool != null && this.oConn != null) {
                    this.currentPool.destroyConnection(this.oConn);
                }
                XDBBaseException xDBBaseException = exception instanceof XDBBaseException ? (XDBBaseException)exception : (exception instanceof SQLException ? new XDBWrappedSQLException(this.nodeId, (SQLException)exception) : new XDBWrappedException(this.nodeId, (Throwable)exception));
                logger.throwing(xDBBaseException);
                throw xDBBaseException;
            }
            Object var10_15 = null;
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initNodeProducerThread(Connection connection, SendMessageHelper sendMessageHelper) throws XDBBaseException {
        try {
            if (this.aNodeProducerThread == null) {
                this.producerQueue = new LinkedBlockingQueue();
                this.aNodeProducerThread = new NodeProducerThread(this, this.producerQueue);
                new Thread(this.aNodeProducerThread).start();
            }
            this.aNodeProducerThread.reset();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBeginSavepoint(String string) throws SQLException {
        Connection connection = this.oConn;
        synchronized (connection) {
            if (Props.XDB_SAVEPOINTTYPE.equals("S")) {
                Savepoint savepoint = this.oConn.setSavepoint(string);
                this.savepointTable.put(string, savepoint);
            } else {
                this.aStatement = this.oConn.createStatement();
                try {
                    this.aStatement.executeUpdate("SUBTRANS BEGIN");
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.aStatement.close();
                    this.aStatement = null;
                    throw throwable;
                }
                this.aStatement.close();
                this.aStatement = null;
                {
                }
            }
            this.oConn.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginSavepoint(String string) throws XDBBaseException {
        try {
            block6: {
                try {
                    this.doBeginSavepoint(string);
                }
                catch (SQLException sQLException) {
                    if (!this.handleSqlException(sQLException, null)) break block6;
                    try {
                        this.doBeginSavepoint(string);
                    }
                    catch (SQLException sQLException2) {
                        logger.catching(sQLException2);
                        XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                        logger.throwing(xDBWrappedSQLException);
                        throw xDBWrappedSQLException;
                    }
                }
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRollbackSavepoint(String string) throws SQLException {
        Connection connection = this.oConn;
        synchronized (connection) {
            if (Props.XDB_SAVEPOINTTYPE.equals("S")) {
                Savepoint savepoint = this.savepointTable.get(string);
                if (savepoint == null) {
                    throw new XDBServerException(ErrorMessageRepository.SQL_ROLLBACK_SAVEPOINT_ERROR + " nodeId = " + this.nodeId, 8, ErrorMessageRepository.SQL_ROLLBACK_SAVEPOINT_ERROR_CODE);
                }
                this.oConn.rollback(savepoint);
            } else {
                this.aStatement = this.oConn.createStatement();
                try {
                    this.aStatement.executeUpdate("SUBTRANS ROLLBACK");
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.aStatement.close();
                    this.aStatement = null;
                    throw throwable;
                }
                this.aStatement.close();
                this.aStatement = null;
                {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void rollbackSavepoint(String string) throws XDBBaseException {
        try {
            try {
                this.doRollbackSavepoint(string);
            }
            catch (SQLException sQLException) {
                if (this.handleSqlException(sQLException, null)) {
                    try {
                        this.doRollbackSavepoint(string);
                    }
                    catch (SQLException sQLException2) {
                        logger.catching(sQLException2);
                        XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                        logger.throwing(xDBWrappedSQLException);
                        throw xDBWrappedSQLException;
                    }
                }
                Object var6_3 = null;
                this.savepointTable.remove(string);
                return;
            }
            Object var6_2 = null;
            this.savepointTable.remove(string);
            return;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.savepointTable.remove(string);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEndSavepoint(String string) throws SQLException {
        Connection connection = this.oConn;
        synchronized (connection) {
            if (Props.XDB_SAVEPOINTTYPE.equals("S")) {
                Savepoint savepoint = this.savepointTable.get(string);
                this.oConn.releaseSavepoint(savepoint);
            } else {
                this.aStatement = this.oConn.createStatement();
                try {
                    this.aStatement.executeUpdate("SUBTRANS END");
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.aStatement.close();
                    this.aStatement = null;
                    throw throwable;
                }
                this.aStatement.close();
                this.aStatement = null;
                {
                }
            }
            this.oConn.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void endSavepoint(String string) throws XDBBaseException {
        try {
            try {
                this.doEndSavepoint(string);
            }
            catch (SQLException sQLException) {
                if (this.handleSqlException(sQLException, null)) {
                    try {
                        this.doEndSavepoint(string);
                    }
                    catch (SQLException sQLException2) {
                        logger.catching(sQLException2);
                        XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                        logger.throwing(xDBWrappedSQLException);
                        throw xDBWrappedSQLException;
                    }
                }
                Object var6_3 = null;
                this.savepointTable.remove(string);
                return;
            }
            Object var6_2 = null;
            this.savepointTable.remove(string);
            return;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.savepointTable.remove(string);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int doProcessSqlCommand(String string, boolean bl) throws SQLException {
        int n = 0;
        Connection connection = this.oConn;
        synchronized (connection) {
            block7: {
                this.aStatement = this.oConn.createStatement();
                if (bl) {
                    this.oConn.setAutoCommit(true);
                }
                try {
                    try {
                        n = this.aStatement.executeUpdate(string);
                        Object var6_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        this.aStatement.close();
                        this.aStatement = null;
                        throw throwable;
                    }
                    this.aStatement.close();
                    this.aStatement = null;
                    Object var8_8 = null;
                    if (!bl) break block7;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (!bl) throw throwable;
                    this.oConn.setAutoCommit(false);
                    throw throwable;
                }
                this.oConn.setAutoCommit(false);
            }
            this.oConn.notify();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int processSqlCommand(String string, boolean bl) throws XDBBaseException {
        try {
            return this.doProcessSqlCommand(string, bl);
        }
        catch (SQLException sQLException) {
            if (!this.handleSqlException(sQLException, string)) return 0;
            try {
                return this.doProcessSqlCommand(string, bl);
            }
            catch (SQLException sQLException2) {
                try {
                    logger.catching(sQLException2);
                    XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                    logger.throwing(xDBWrappedSQLException);
                    throw xDBWrappedSQLException;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initStep() throws XDBBaseException {
        try {
            if (this.aStepDetail.isConsumer && this.aStepDetail.getDestType() != 6) {
                boolean bl;
                boolean bl2 = bl = !Props.XDB_COMMIT_AFTER_CREATE_TEMP_TABLE && !Props.XDB_USE_LOAD_FOR_STEP;
                if (this.aStepDetail.targetSchema != null && this.aStepDetail.targetSchema.length() > 0) {
                    block11: {
                        try {
                            if (bl) {
                                this.beginSavepoint("stepSavepoint");
                            }
                            this.processSqlCommand(this.aStepDetail.targetSchema, !bl);
                            Object var3_2 = null;
                            if (!bl) break block11;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            if (!bl) throw throwable;
                            this.endSavepoint("stepSavepoint");
                            throw throwable;
                        }
                        this.endSavepoint("stepSavepoint");
                    }
                    if (this.aStepDetail.targetTable != null) {
                        HashSet<String> hashSet = this.tempTableNames;
                        synchronized (hashSet) {
                            this.tempTableNames.add(this.aStepDetail.targetTable);
                        }
                    }
                }
                if (!Props.XDB_USE_LOAD_FOR_STEP) {
                    this.initDataDown(this.aStepDetail.targetTable);
                }
            }
            if (!this.aStepDetail.isProducer) return;
            this.initNodeProducerThread(this.oConn, this.sendHelper);
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStep(NodeMessage nodeMessage) throws XDBBaseException {
        try {
            if (this.aStepDetail.isProducer) {
                this.initNodeProducerThread(this.oConn, this.sendHelper);
                nodeMessage.setStepDetail(this.aStepDetail);
                if (this.producerQueue != null) {
                    this.producerQueuePut(nodeMessage);
                }
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQuery(NodeMessage nodeMessage) throws XDBBaseException {
        try {
            this.initNodeProducerThread(this.oConn, this.sendHelper);
            if (this.producerQueue != null) {
                this.producerQueuePut(nodeMessage);
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitDataDown(String string) throws SQLException {
        Connection connection = this.oConn;
        synchronized (connection) {
            this.aStatement = this.batchStatement = this.oConn.createStatement();
            this.oConn.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDataDown(String string) throws XDBBaseException {
        this.downTableName = string;
        this.baseInsert = "INSERT INTO " + IdentifierHandler.quote(string) + " VALUES ";
        try {
            try {
                this.downTableName = string;
                this.baseInsert = "INSERT INTO " + IdentifierHandler.quote(string) + " VALUES ";
                this.doInitDataDown(string);
            }
            catch (SQLException sQLException) {
                if (this.handleSqlException(sQLException, null)) {
                    try {
                        this.doInitDataDown(string);
                    }
                    catch (SQLException sQLException2) {
                        logger.catching(sQLException2);
                        XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                        logger.throwing(xDBWrappedSQLException);
                        throw xDBWrappedSQLException;
                    }
                }
                Object var6_3 = null;
            }
            Object var6_2 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPopulateDownData(String string) throws SQLException {
        if (string == null) {
            return;
        }
        String string2 = Props.XDB_JUST_DATA_VALUES ? this.baseInsert + string : string;
        Connection connection = this.oConn;
        synchronized (connection) {
            this.batchStatement.addBatch(string2);
            logger.log(XLevel.TRACE, "From connection: %0% added batch command to Statement: ", new Object[]{this.oConn, this.batchStatement});
            if (++this.iCount % 1000 == 0) {
                logger.log(XLevel.TRACE, "From connection: %0% executing batch Statement: %1%", new Object[]{this.oConn, this.batchStatement});
                this.batchStatement.executeBatch();
                logger.log(XLevel.TRACE, "From connection: %0% executed batch Statement: %1%", new Object[]{this.oConn, this.batchStatement});
                this.batchStatement.clearBatch();
                logger.log(XLevel.TRACE, "From connection: %0% cleared batch Statement: %1%", new Object[]{this.oConn, this.batchStatement});
            }
            this.oConn.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateDownData(String string) throws XDBBaseException {
        try {
            try {
                this.doPopulateDownData(string);
            }
            catch (SQLException sQLException) {
                if (this.handleSqlException(sQLException, null)) {
                    try {
                        this.doPopulateDownData(string);
                    }
                    catch (SQLException sQLException2) {
                        logger.catching(sQLException2);
                        XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                        logger.throwing(xDBWrappedSQLException);
                        throw xDBWrappedSQLException;
                    }
                }
                Object var6_3 = null;
            }
            Object var6_2 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFinishInserts() throws SQLException {
        Connection connection = this.oConn;
        synchronized (connection) {
            this.batchStatement.executeBatch();
            this.batchStatement.close();
            this.aStatement = null;
            this.oConn.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishInserts() throws XDBBaseException {
        try {
            try {
                this.doFinishInserts();
            }
            catch (SQLException sQLException) {
                if (this.handleSqlException(sQLException, null)) {
                    try {
                        this.doFinishInserts();
                    }
                    catch (SQLException sQLException2) {
                        logger.catching(sQLException2);
                        XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                        logger.throwing(xDBWrappedSQLException);
                        throw xDBWrappedSQLException;
                    }
                }
                this.iCount = 0;
                Object var5_2 = null;
            }
            Object var5_1 = null;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFinalizeStep() throws SQLException {
        Connection connection = this.oConn;
        synchronized (connection) {
            if (this.aStepDetail.isConsumer && this.aStepDetail.getDestType() != 6) {
                Object object;
                Object object2;
                if (Props.XDB_STEP_INDEX_CORRELATED && (object2 = this.aStepDetail.getCorrelatedIndex()) != null) {
                    object = this.oConn.createStatement();
                    object.execute((String)object2);
                    object.close();
                }
                if (Props.XDB_STEP_RUNANALYZE) {
                    object2 = new HashMap();
                    ((HashMap)object2).put("table", IdentifierHandler.quote(this.aStepDetail.targetTable));
                    object = Props.XDB_SQLCOMMAND_ANALYZE_TEMPLATE_TABLE.trim();
                    String string = ParseCmdLine.substitute((String)object, (Map<String, String>)object2);
                    Statement statement = this.oConn.createStatement();
                    statement.execute(string);
                    statement.close();
                }
            }
            this.oConn.commit();
            this.oConn.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeStep() throws XDBBaseException {
        try {
            try {
                this.doFinalizeStep();
            }
            catch (SQLException sQLException) {
                if (this.handleSqlException(sQLException, null)) {
                    try {
                        this.doFinalizeStep();
                    }
                    catch (SQLException sQLException2) {
                        logger.catching(sQLException2);
                        XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                        logger.throwing(xDBWrappedSQLException);
                        throw xDBWrappedSQLException;
                    }
                }
                this.iCount = 0;
                Object var5_2 = null;
            }
            Object var5_1 = null;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] processExecuteBatch(NodeMessage nodeMessage) throws XDBBaseException {
        try {
            String[] stringArray;
            this.initBatch();
            for (String string : stringArray = nodeMessage.getRowData()) {
                this.addBatch(string);
            }
            int[] nArray = this.executeBatch();
            Object var8_8 = null;
            return nArray;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitBatch() throws SQLException {
        Connection connection = this.oConn;
        synchronized (connection) {
            this.aStatement = this.batchStatement = this.oConn.createStatement();
            this.oConn.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBatch() throws XDBBaseException {
        try {
            try {
                this.doInitBatch();
            }
            catch (SQLException sQLException) {
                if (this.handleSqlException(sQLException, null)) {
                    try {
                        this.doInitBatch();
                    }
                    catch (SQLException sQLException2) {
                        logger.catching(sQLException2);
                        XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                        logger.throwing(xDBWrappedSQLException);
                        throw xDBWrappedSQLException;
                    }
                }
                Object var5_2 = null;
            }
            Object var5_1 = null;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddBatch(String string) throws SQLException {
        Connection connection = this.oConn;
        synchronized (connection) {
            this.batchStatement.addBatch(string);
            logger.log(XLevel.TRACE, "From connection: %0% added batch command to Statement: %1%", new Object[]{this.oConn, this.batchStatement});
            this.oConn.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBatch(String string) throws XDBBaseException {
        try {
            try {
                this.doAddBatch(string);
            }
            catch (SQLException sQLException) {
                if (this.handleSqlException(sQLException, null)) {
                    try {
                        this.doAddBatch(string);
                    }
                    catch (SQLException sQLException2) {
                        logger.catching(sQLException2);
                        XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                        logger.throwing(xDBWrappedSQLException);
                        throw xDBWrappedSQLException;
                    }
                }
                Object var6_3 = null;
            }
            Object var6_2 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] doExecuteBatch() throws SQLException {
        int[] nArray = null;
        try {
            Connection connection = this.oConn;
            synchronized (connection) {
                nArray = this.batchStatement.executeBatch();
                this.oConn.notify();
            }
        }
        catch (BatchUpdateException batchUpdateException) {
            logger.catching(batchUpdateException);
            nArray = batchUpdateException.getUpdateCounts();
        }
        this.iCount = 0;
        return nArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int[] executeBatch() throws XDBBaseException {
        try {
            return this.doExecuteBatch();
        }
        catch (SQLException sQLException) {
            Throwable throwable2;
            this.handleSqlException(sQLException, null);
            try {
                return this.doExecuteBatch();
            }
            catch (SQLException sQLException2) {
                try {
                    logger.catching(sQLException2);
                    XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                    logger.throwing(xDBWrappedSQLException);
                    throw xDBWrappedSQLException;
                }
                catch (Throwable throwable2) {
                    Object var5_5 = null;
                }
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setState(int n) {
        try {
            this.currentState = n;
            this.notify();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    private synchronized int checkCurrentState(int[] nArray, int n) throws XDBUnexpectedStateException {
        for (int n2 : nArray) {
            if (this.currentState != n2) continue;
            this.setState(n);
            return n2;
        }
        XDBUnexpectedStateException xDBUnexpectedStateException = new XDBUnexpectedStateException(this.nodeId, this.currentState, nArray);
        logger.throwing(xDBUnexpectedStateException);
        throw xDBUnexpectedStateException;
    }

    public synchronized boolean isAlive() {
        return this.currentState != -3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            NodeMessage nodeMessage = null;
            while (true) {
                String[] stringArray;
                try {
                    block56: while (true) {
                        this.isTaking = true;
                        nodeMessage = this.msgQueue.poll(5L, TimeUnit.SECONDS);
                        if (nodeMessage == null) continue;
                        this.isTaking = false;
                        this.lastMessageType = nodeMessage.getMessageType();
                        if (nodeMessage.getMessageType() != 1 && nodeMessage.getRequestId() == this.requestIDtoAbort) continue;
                        this.requestIDtoAbort = -1;
                        switch (nodeMessage.getMessageType()) {
                            case 22: {
                                this.tranCommit(nodeMessage);
                                continue block56;
                            }
                            case 24: {
                                this.tranRollback(nodeMessage);
                                continue block56;
                            }
                            case 28: {
                                this.checkCurrentState(new int[]{0}, 2);
                                try {
                                    this.beginSavepoint(nodeMessage.getSavepoint());
                                    this.sendHelper.sendReplyMessage(nodeMessage, 29);
                                    stringArray = null;
                                    this.setState(0);
                                    continue block56;
                                }
                                catch (Throwable throwable) {
                                    stringArray = null;
                                    this.setState(0);
                                    throw throwable;
                                }
                            }
                            case 30: {
                                int[] nArray;
                                this.checkCurrentState(new int[]{0}, 4);
                                try {
                                    this.rollbackSavepoint(nodeMessage.getSavepoint());
                                    this.sendHelper.sendReplyMessage(nodeMessage, 31);
                                    nArray = null;
                                    this.setState(0);
                                    continue block56;
                                }
                                catch (Throwable throwable) {
                                    nArray = null;
                                    this.setState(0);
                                    throw throwable;
                                }
                            }
                            case 32: {
                                String string;
                                this.checkCurrentState(new int[]{0}, 5);
                                try {
                                    this.endSavepoint(nodeMessage.getSavepoint());
                                    this.sendHelper.sendReplyMessage(nodeMessage, 33);
                                    string = null;
                                    this.setState(0);
                                    continue block56;
                                }
                                catch (Throwable throwable) {
                                    string = null;
                                    this.setState(0);
                                    throw throwable;
                                }
                            }
                            case 7: 
                            case 107: {
                                Object var9_23;
                                this.checkCurrentState(new int[]{0}, 1);
                                try {
                                    this.processQuery(nodeMessage);
                                    var9_23 = null;
                                    this.setState(0);
                                    continue block56;
                                }
                                catch (Throwable throwable) {
                                    var9_23 = null;
                                    this.setState(0);
                                    throw throwable;
                                }
                            }
                            case 9: {
                                Object var11_24;
                                this.checkCurrentState(new int[]{0}, 8);
                                try {
                                    this.aStepDetail = nodeMessage.getStepDetail();
                                    this.initStep();
                                    this.sendHelper.sendReplyMessage(nodeMessage, 109);
                                    var11_24 = null;
                                    this.setState(this.aStepDetail.isConsumer ? 9 : 0);
                                    continue block56;
                                }
                                catch (Throwable throwable) {
                                    var11_24 = null;
                                    this.setState(this.aStepDetail.isConsumer ? 9 : 0);
                                    throw throwable;
                                }
                            }
                            case 209: {
                                Object var13_25;
                                int n = this.checkCurrentState(new int[]{0, 9}, 8);
                                this.aStepDetail = nodeMessage.getStepDetail();
                                try {
                                    this.processStep(nodeMessage);
                                    var13_25 = null;
                                    this.setState(n);
                                    continue block56;
                                }
                                catch (Throwable throwable) {
                                    var13_25 = null;
                                    this.setState(n);
                                    throw throwable;
                                }
                            }
                            case 10: {
                                Object var15_26;
                                this.checkCurrentState(new int[]{0, 9}, 10);
                                try {
                                    if (!Props.XDB_USE_LOAD_FOR_STEP) {
                                        this.finishInserts();
                                    }
                                    this.finalizeStep();
                                    if (Props.XDB_DUMPSTEPPATH != null) {
                                        NodeThread.dumpStepResults(this.oConn, this.aStepDetail.targetTable, this.nodeId);
                                    }
                                    this.sendHelper.sendReplyMessage(nodeMessage, 110);
                                    var15_26 = null;
                                    this.setState(0);
                                    continue block56;
                                }
                                catch (Throwable throwable) {
                                    var15_26 = null;
                                    this.setState(0);
                                    throw throwable;
                                }
                            }
                            case 19: {
                                this.checkCurrentState(new int[]{0}, 9);
                                this.initDataDown(nodeMessage.getTargetTable());
                                continue block56;
                            }
                            case 16: {
                                if (this.aStepDetail != null && !this.aStepDetail.consumerNodeList.contains(new Integer(this.nodeId))) continue block56;
                                this.checkCurrentState(new int[]{9}, 9);
                                for (String string : stringArray = nodeMessage.getRowData()) {
                                    this.populateDownData(string);
                                }
                                NodeMessage nodeMessage2 = NodeMessage.getNodeMessage(17);
                                nodeMessage2.setDataSeqNo(nodeMessage.getDataSeqNo());
                                this.sendHelper.sendReplyMessage(nodeMessage, nodeMessage2);
                                stringArray = null;
                                Object var4_12 = null;
                                if (freeInterval <= 0 || nodeMessage.getDataSeqNo() % (long)freeInterval != 0L) continue block56;
                                nodeMessage = null;
                                System.gc();
                                continue block56;
                            }
                            case 17: {
                                this.producerQueuePut(nodeMessage);
                                continue block56;
                            }
                            case 40: {
                                Object var17_27;
                                int[] nArray;
                                this.checkCurrentState(new int[]{0}, 1);
                                try {
                                    void var4_15;
                                    stringArray = NodeMessage.getNodeMessage(41);
                                    stringArray.setRequestId(nodeMessage.getRequestId());
                                    nArray = this.processExecuteBatch(nodeMessage);
                                    if (nArray.length < nodeMessage.getRowCount()) {
                                        int[] nArray2 = new int[nodeMessage.getRowCount()];
                                        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                                        Arrays.fill(nArray2, nArray.length, nArray2.length, -3);
                                    } else {
                                        int[] nArray3 = nArray;
                                    }
                                    stringArray.setBatchResult((int[])var4_15);
                                    this.sendHelper.sendReplyMessage(nodeMessage, (NodeMessage)stringArray);
                                    var17_27 = null;
                                    this.setState(0);
                                    continue block56;
                                }
                                catch (Throwable throwable) {
                                    var17_27 = null;
                                    this.setState(0);
                                    throw throwable;
                                }
                            }
                            case 26: {
                                this.producerQueuePut(nodeMessage);
                                continue block56;
                            }
                            case 1001: {
                                this.setState(-3);
                                try {
                                    if (this.producerQueue != null) {
                                        this.producerQueuePut(nodeMessage);
                                    }
                                    this.producerQueue = null;
                                    return;
                                }
                                catch (Exception exception) {
                                    logger.catching(exception);
                                }
                                return;
                            }
                            case 1: {
                                Object var19_28;
                                try {
                                    if (this.producerQueue != null) {
                                        this.producerQueuePut(nodeMessage);
                                    }
                                    var19_28 = null;
                                    this.requestIDtoAbort = nodeMessage.getRequestId();
                                    this.setState(0);
                                    continue block56;
                                }
                                catch (Throwable throwable) {
                                    var19_28 = null;
                                    this.requestIDtoAbort = nodeMessage.getRequestId();
                                    this.setState(0);
                                    throw throwable;
                                }
                            }
                            case 14: {
                                Object var21_29;
                                this.checkCurrentState(new int[]{0}, 1);
                                try {
                                    this.checkConnection();
                                    var21_29 = null;
                                    this.setState(0);
                                }
                                catch (Throwable throwable) {
                                    var21_29 = null;
                                    this.setState(0);
                                    throw throwable;
                                }
                                this.sendHelper.sendReplyMessage(nodeMessage, 15);
                                continue block56;
                            }
                            case 42: {
                                this.producerQueuePut(nodeMessage);
                                continue block56;
                            }
                            case 142: {
                                this.producerQueuePut(nodeMessage);
                                continue block56;
                            }
                            case 15: {
                                continue block56;
                            }
                            case 71: 
                            case 72: 
                            case 73: {
                                this.producerQueuePut(nodeMessage);
                                continue block56;
                            }
                        }
                        stringArray = new XDBUnexpectedMessageException(this.nodeId, "NodeThread can not handle message", nodeMessage);
                        logger.throwing((Throwable)stringArray);
                        throw stringArray;
                    }
                }
                catch (XDBBaseException xDBBaseException) {
                    stringArray = this;
                    synchronized (stringArray) {
                        logger.catching(xDBBaseException);
                        if (this.sendHelper != null) {
                            this.requestIDtoAbort = nodeMessage.getRequestId();
                            NodeMessage nodeMessage3 = NodeMessage.getNodeMessage(1);
                            nodeMessage3.setCause(xDBBaseException);
                            this.sendHelper.sendReplyMessage(nodeMessage, nodeMessage3);
                        }
                    }
                }
                catch (Throwable throwable) {
                    stringArray = this;
                    synchronized (stringArray) {
                        logger.catching(throwable);
                        if (this.sendHelper != null) {
                            this.requestIDtoAbort = nodeMessage.getRequestId();
                            NodeMessage nodeMessage4 = NodeMessage.getNodeMessage(1);
                            nodeMessage4.setCause(new XDBWrappedException(this.nodeId, throwable));
                            this.sendHelper.sendReplyMessage(nodeMessage, nodeMessage4);
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var25_36 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnection() throws XDBBaseException {
        try {
            if ("".equals(Props.XDB_BACKEND_PING_STATEMENT)) {
                Object var9_1 = null;
                return;
            }
            Savepoint savepoint = null;
            Connection connection = this.oConn;
            synchronized (connection) {
                try {
                    this.aStatement = this.oConn.createStatement();
                    try {
                        boolean bl;
                        logger.debug("SQL: " + Props.XDB_BACKEND_PING_STATEMENT);
                        boolean bl2 = bl = Props.XDB_BACKEND_PING_SETUP != null && Props.XDB_SAVEPOINTTYPE.equals("S");
                        if (bl) {
                            savepoint = this.oConn.setSavepoint("checkConn");
                        }
                        try {
                            this.aStatement.execute(Props.XDB_BACKEND_PING_STATEMENT);
                            logger.log(XLevel.TRACE, "From connection: %0% executed Statement: %1%", new Object[]{this.oConn, this.aStatement});
                            if (bl) {
                                this.oConn.releaseSavepoint(savepoint);
                            }
                        }
                        catch (SQLException sQLException) {
                            if (bl) {
                                this.oConn.rollback(savepoint);
                            }
                            if (Props.XDB_BACKEND_PING_SETUP != null) {
                                this.aStatement.execute(Props.XDB_BACKEND_PING_SETUP);
                                logger.log(XLevel.TRACE, "From connection: %0% executed Statement: %1%", new Object[]{this.oConn, this.aStatement});
                            }
                            throw sQLException;
                        }
                        Object var6_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        this.aStatement.close();
                        this.aStatement = null;
                        throw throwable;
                    }
                    this.aStatement.close();
                    this.aStatement = null;
                    {
                    }
                }
                catch (SQLException sQLException) {
                    throw new XDBBaseException(this.getNodeId(), "Ping failed: " + sQLException.getMessage());
                }
                this.oConn.notify();
            }
        }
        catch (Throwable throwable) {
            Object var9_3 = null;
            throw throwable;
        }
        Object var9_2 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTranRollback(NodeMessage nodeMessage) throws XDBBaseException, SQLException {
        this.checkCurrentState(new int[]{0}, 4);
        try {
            Connection connection = this.oConn;
            synchronized (connection) {
                this.oConn.rollback();
                this.oConn.notify();
            }
            Object var5_4 = null;
            this.setState(0);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.setState(0);
            throw throwable;
        }
        this.sendHelper.sendReplyMessage(nodeMessage, 25);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tranRollback(NodeMessage nodeMessage) throws XDBBaseException {
        try {
            try {
                this.doTranRollback(nodeMessage);
            }
            catch (SQLException sQLException) {
                if (this.handleSqlException(sQLException, null)) {
                    try {
                        this.doTranRollback(nodeMessage);
                    }
                    catch (SQLException sQLException2) {
                        logger.catching(sQLException2);
                        XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                        logger.throwing(xDBWrappedSQLException);
                        throw xDBWrappedSQLException;
                    }
                }
                Object var6_3 = null;
                this.savepointTable.clear();
                this.setState(0);
            }
            Object var6_2 = null;
            this.savepointTable.clear();
            this.setState(0);
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.savepointTable.clear();
            this.setState(0);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTranCommit(NodeMessage nodeMessage) throws XDBBaseException, SQLException {
        this.checkCurrentState(new int[]{0}, 3);
        Connection connection = this.oConn;
        synchronized (connection) {
            this.oConn.commit();
            this.oConn.notify();
        }
        if (nodeMessage != null) {
            this.sendHelper.sendReplyMessage(nodeMessage, 23);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void tranCommit(NodeMessage nodeMessage) throws XDBBaseException {
        NodeThread nodeThread;
        try {
            try {
                this.doTranCommit(nodeMessage);
            }
            catch (SQLException sQLException) {
                if (this.handleSqlException(sQLException, null)) {
                    try {
                        this.doTranCommit(nodeMessage);
                    }
                    catch (SQLException sQLException2) {
                        logger.catching(sQLException2);
                        XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                        logger.throwing(xDBWrappedSQLException);
                        throw xDBWrappedSQLException;
                    }
                }
                Object var6_3 = null;
                NodeThread nodeThread3 = this;
                synchronized (nodeThread3) {
                    this.savepointTable.clear();
                    this.setState(0);
                    return;
                }
            }
            Object var6_2 = null;
            nodeThread = this;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            NodeThread nodeThread2 = this;
            synchronized (nodeThread2) {
                this.savepointTable.clear();
                this.setState(0);
                throw throwable;
            }
        }
        synchronized (nodeThread) {
            this.savepointTable.clear();
            this.setState(0);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processMessage(NodeMessage nodeMessage) {
        switch (nodeMessage.getMessageType()) {
            case 0: {
                NodeThread nodeThread = this;
                synchronized (nodeThread) {
                    if (this.oConn != null) {
                        this.kill();
                    }
                    break;
                }
            }
            case 1: {
                NodeThread nodeThread = this;
                synchronized (nodeThread) {
                    if (this.oConn != null) {
                        this.kill();
                    }
                }
            }
            default: {
                this.msgQueue.offer(nodeMessage);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kill() {
        block7: {
            try {
                block6: {
                    try {
                        if (this.aNodeProducerThread != null) {
                            this.aNodeProducerThread.kill();
                        }
                        if (this.aStatement == null) break block6;
                        this.aStatement.cancel();
                    }
                    catch (SQLException sQLException) {
                        logger.catching(sQLException);
                        Object var3_2 = null;
                        break block7;
                    }
                    catch (Throwable throwable) {
                        logger.catching(throwable);
                        Object var3_3 = null;
                    }
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    private void producerQueuePut(NodeMessage nodeMessage) throws XDBBaseException {
        if (this.aNodeProducerThread == null || this.aNodeProducerThread.getState() == -1) {
            this.initNodeProducerThread(this.oConn, this.sendHelper);
        }
        this.producerQueue.offer(nodeMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean handleSqlException(SQLException sQLException, Object object) throws XDBBaseException {
        Object object2;
        String string;
        String string2;
        logger.catching(sQLException);
        switch (sQLException.getErrorCode()) {
            case -708: {
                int n;
                NodeThread nodeThread = this;
                synchronized (nodeThread) {
                    n = this.currentState;
                    this.setState(0);
                }
                this.reset(null, this.currentPool);
                this.checkCurrentState(new int[]{0}, n);
                return true;
            }
            case -4004: {
                String string3;
                if (!(object instanceof String) || (string2 = ((String)object).trim()).length() <= 5 || !(string = string2.substring(0, 4).toUpperCase()).equals("DROP") || (string2 = string2.substring(5).trim()).length() <= 6 || !(string3 = string2.substring(0, 5).toUpperCase()).equals("TABLE")) break;
                return false;
            }
        }
        if ("57P01".equals(sQLException.getSQLState()) || "08006".equals(sQLException.getSQLState())) {
            try {
                Connection connection = this.currentPool.getConnection();
                this.currentPool.destroyConnection(this.oConn);
                this.oConn = connection;
                if (this.aNodeProducerThread != null) {
                    try {
                        this.aNodeProducerThread.reset();
                    }
                    catch (Throwable throwable) {
                        this.producerQueue.offer(NodeMessage.getNodeMessage(1001));
                        this.aNodeProducerThread = null;
                    }
                }
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ("42P01".equals(sQLException.getSQLState()) && object instanceof String && ((String)(object2 = ((String)object).trim())).length() > 5 && (string2 = ((String)object2).substring(0, 4).toUpperCase()).equals("DROP") && ((String)(object2 = ((String)object2).substring(5).trim())).length() > 6 && (string = ((String)object2).substring(0, 5).toUpperCase()).equals("TABLE")) {
            try {
                this.oConn.rollback();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            return false;
        }
        if ("08003".equals(sQLException.getSQLState())) {
            try {
                object2 = this.currentPool.getConnection();
                this.currentPool.destroyConnection(this.oConn);
                this.oConn = object2;
                if (this.aNodeProducerThread != null) {
                    try {
                        this.aNodeProducerThread.reset();
                    }
                    catch (Throwable throwable) {
                        this.producerQueue.offer(NodeMessage.getNodeMessage(1001));
                        this.aNodeProducerThread = null;
                    }
                }
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        object2 = new XDBWrappedSQLException(this.nodeId, sQLException);
        logger.throwing((Throwable)object2);
        throw object2;
    }

    int getNodeId() {
        return this.nodeId;
    }

    Connection getConnection() {
        return this.oConn;
    }

    SendMessageHelper getSendHelper() {
        return this.sendHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpStepResults(Connection connection, String string, int n) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("path", Props.XDB_DUMPSTEPPATH);
        hashMap.put("table", string);
        hashMap.put("node", "" + n);
        String string2 = ParseCmdLine.substitute(Props.XDB_DUMPCOMMAND, hashMap);
        Connection connection2 = connection;
        synchronized (connection2) {
            try {
                Statement statement = connection.createStatement();
                statement.execute(string2);
            }
            catch (Exception exception) {
                logger.catching(exception);
            }
        }
    }
}

