/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine.copy;

import com.edb.PGConnection;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.copy.CopyIn;
import com.edb.gridsql.engine.copy.CopyOut;
import com.edb.gridsql.engine.copy.EdbCopyManager;
import com.edb.gridsql.engine.copy.PgCopyManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class CopyManager {
    private static final XLogger logger = XLogger.getLogger(CopyManager.class);

    public static CopyManager getCopyManager(Connection connection) {
        try {
            if (connection instanceof PGConnection) {
                return new EdbCopyManager((PGConnection)connection);
            }
            if (connection instanceof org.postgresql.PGConnection) {
                return new PgCopyManager((org.postgresql.PGConnection)connection);
            }
        }
        catch (Exception exception) {
            logger.catching(exception);
        }
        throw new UnsupportedOperationException("The connection does not support COPY");
    }

    public abstract long copyIn(String var1, InputStream var2) throws SQLException, IOException;

    public abstract CopyIn copyIn(String var1) throws SQLException;

    public abstract long copyOut(String var1, OutputStream var2) throws SQLException, IOException;

    public abstract CopyOut copyOut(String var1) throws SQLException;
}

