/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine.io;

import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.XLogger;
import java.io.UnsupportedEncodingException;

public abstract class XMessage {
    private static final XLogger logger = XLogger.getLogger(XMessage.class);
    protected static final String CHARSET_NAME = Property.get("xdb.charset", "ISO-8859-1");
    protected static final boolean USE_UNICODE = Property.getBoolean("xdb.unicode", false);
    public static final int MAX_LENGTH = 0xFFFFFF;
    public static final int HEADER_SIZE = 8;
    public static final String ARGS_DELIMITER = "|";
    public static char SOH = '\u0001';
    public static char STX = (char)2;
    public static char ETX = (char)3;
    public static final String STR_DELIMITER = "|" + SOH + "|" + STX + "|" + ETX;
    protected static final int STRING_NULL_SIZE = -2;
    public static final int INTEGER_SIZE = 4;
    protected byte[] message = null;
    protected int currentPos = 0;
    protected int readPos = 0;
    protected int packetLength = 8;
    protected byte type = 0;
    protected int requestId = 0;

    protected XMessage() {
    }

    public int getPacketLength() {
        return this.packetLength;
    }

    public void increasePacketLength(int n) {
        this.packetLength += n;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte by) {
        this.type = by;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public void setRequestId(int n) {
        this.requestId = n;
    }

    public void setHeaderBytes(byte[] byArray) {
        this.packetLength = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16;
        this.requestId = byArray[3] & 0xFF | (byArray[4] & 0xFF) << 8 | (byArray[5] & 0xFF) << 16 | (byArray[6] & 0xFF) << 24;
        this.type = byArray[7];
    }

    public byte[] getHeaderBytes() {
        byte[] byArray = new byte[]{(byte)(this.packetLength & 0xFF), (byte)(this.packetLength >> 8), (byte)(this.packetLength >> 16), (byte)(this.requestId & 0xFF), (byte)(this.requestId >> 8), (byte)(this.requestId >> 16), (byte)(this.requestId >> 24), this.type};
        return byArray;
    }

    public void setMessage(byte[] byArray) {
        this.message = byArray;
        this.readPos = 0;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public int getCurrentMessageSize() {
        return this.currentPos;
    }

    public void initSize(int n) {
        if (this.message == null) {
            this.message = new byte[n];
        } else if (this.currentPos + n > this.message.length) {
            if (n < 8192) {
                n = 8192;
            }
            int n2 = this.currentPos + n;
            byte[] byArray = new byte[n2];
            System.arraycopy(this.message, 0, byArray, 0, this.message.length);
            this.message = byArray;
        }
    }

    public final void storeByte(byte by) {
        this.initSize(1);
        this.message[this.currentPos++] = by;
        this.increasePacketLength(1);
    }

    public final void storeBytes(byte[] byArray) {
        if (byArray == null) {
            this.storeInt(-2);
            return;
        }
        this.storeBytes(byArray, 0, byArray.length, true);
    }

    public final void storeBytes(byte[] byArray, int n, int n2, boolean bl) {
        if (bl) {
            this.storeInt(n2);
        }
        this.initSize(n2);
        System.arraycopy(byArray, n, this.message, this.currentPos, n2);
        this.currentPos += n2;
        this.increasePacketLength(n2);
    }

    public final void storeShort(short s) {
        this.initSize(2);
        this.message[this.currentPos++] = (byte)(s & 0xFF);
        this.message[this.currentPos++] = (byte)(s >> 8);
        this.increasePacketLength(2);
    }

    public final void storeShort(int n) {
        this.storeShort((short)n);
    }

    public final void storeInt(int n) {
        this.initSize(4);
        this.message[this.currentPos++] = (byte)(n & 0xFF);
        this.message[this.currentPos++] = (byte)(n >> 8);
        this.message[this.currentPos++] = (byte)(n >> 16);
        this.message[this.currentPos++] = (byte)(n >> 24);
        this.increasePacketLength(4);
    }

    public final void storeLong(long l) {
        this.initSize(8);
        this.message[this.currentPos++] = (byte)(l & 0xFFL);
        this.message[this.currentPos++] = (byte)(l >> 8);
        this.message[this.currentPos++] = (byte)(l >> 16);
        this.message[this.currentPos++] = (byte)(l >> 24);
        this.message[this.currentPos++] = (byte)(l >> 32);
        this.message[this.currentPos++] = (byte)(l >> 40);
        this.message[this.currentPos++] = (byte)(l >> 48);
        this.message[this.currentPos++] = (byte)(l >> 56);
        this.increasePacketLength(8);
    }

    public final void storeFloat(float f) {
        this.storeInt(Float.floatToIntBits(f));
    }

    public final void storeDouble(double d) {
        this.storeLong(Double.doubleToLongBits(d));
    }

    public final void storeString(String string) {
        if (string == null) {
            this.storeInt(-2);
            return;
        }
        int n = string.length();
        if (n == 0) {
            this.storeInt(n);
            return;
        }
        if (USE_UNICODE) {
            this.storeInt(n * 2);
            this.initSize(n * 2);
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                this.message[this.currentPos++] = (byte)(c & 0xFF);
                this.message[this.currentPos++] = (byte)(c >> 8);
            }
            this.increasePacketLength(n * 2);
        } else {
            try {
                byte[] byArray = string.getBytes(CHARSET_NAME);
                this.storeBytes(byArray);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.catching(unsupportedEncodingException);
                this.storeInt(-2);
            }
        }
    }

    public boolean hasMoreDataToRead() {
        return this.readPos < this.packetLength - 8;
    }

    public final byte readByte() {
        return this.message[this.readPos++];
    }

    public final byte[] readBytes() {
        int n = this.readInt();
        return this.readBytes(n);
    }

    public final byte[] readBytes(int n) {
        if (n < 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        if (n > 0) {
            System.arraycopy(this.message, this.readPos, byArray, 0, n);
            this.readPos += n;
        }
        return byArray;
    }

    public final short readShort() {
        return (short)(this.message[this.readPos++] & 0xFF | (this.message[this.readPos++] & 0xFF) << 8);
    }

    public final int readInt() {
        return this.message[this.readPos++] & 0xFF | (this.message[this.readPos++] & 0xFF) << 8 | (this.message[this.readPos++] & 0xFF) << 16 | (this.message[this.readPos++] & 0xFF) << 24;
    }

    public final long readLong() {
        return this.message[this.readPos++] & 0xFF | (this.message[this.readPos++] & 0xFF) << 8 | (this.message[this.readPos++] & 0xFF) << 16 | (this.message[this.readPos++] & 0xFF) << 24 | (this.message[this.readPos++] & 0xFF) << 32 | (this.message[this.readPos++] & 0xFF) << 40 | (this.message[this.readPos++] & 0xFF) << 48 | (this.message[this.readPos++] & 0xFF) << 56;
    }

    public final float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readString() {
        int n = this.readInt();
        if (n == -2) {
            return null;
        }
        if (n == 0) {
            return "";
        }
        String string = null;
        byte[] byArray = this.readBytes(n);
        if (USE_UNICODE) {
            char[] cArray = new char[n / 2];
            int n2 = 0;
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = (char)(byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8);
            }
            string = new String(cArray);
        } else {
            try {
                string = new String(byArray, CHARSET_NAME);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.catching(unsupportedEncodingException);
            }
        }
        return string;
    }
}

