/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine.loader;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.loader.Loader;
import com.edb.gridsql.exception.XDBDataReaderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataReaderAndProcessorBuffer<T> {
    private static final XLogger logger = XLogger.getLogger(DataReaderAndProcessorBuffer.class);
    private long waitForFullBuffer = 0L;
    private long waitForEmptyBuffer = 0L;
    private T[] rowsBuffer;
    private String[] groupByHashBuffer;
    private String currentGroupByHashString;
    private int in;
    private int out;
    private int bufferLimit;
    private int currentSize;
    private boolean hasFinished;

    public DataReaderAndProcessorBuffer(int n, Loader.DATA_SOURCE dATA_SOURCE) {
        this.initialize(n, dATA_SOURCE);
    }

    public void initialize(int n, Loader.DATA_SOURCE dATA_SOURCE) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.bufferLimit = n;
        this.rowsBuffer = new Object[n];
        this.groupByHashBuffer = new String[n];
        this.in = 0;
        this.out = 0;
        this.hasFinished = false;
    }

    public synchronized void markFinished() {
        this.hasFinished = true;
        this.notify();
        if (this.waitForFullBuffer > 0L) {
            logger.debug("Wait for full buffer: " + this.waitForFullBuffer);
        }
        if (this.waitForEmptyBuffer > 0L) {
            logger.debug("Wait for empty buffer: " + this.waitForEmptyBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void putRowValue(T t, String string) throws XDBDataReaderException {
        try {
            while (!this.hasFinished && this.currentSize == this.bufferLimit) {
                try {
                    long l = System.currentTimeMillis();
                    this.wait();
                    this.waitForFullBuffer += System.currentTimeMillis() - l;
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.hasFinished) {
                throw new XDBDataReaderException("Cancelled by user");
            }
            if (this.in == this.bufferLimit) {
                this.in = 0;
            }
            ++this.currentSize;
            this.groupByHashBuffer[this.in] = string;
            this.rowsBuffer[this.in++] = t;
            Object var6_5 = null;
            this.notify();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.notify();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void putRowValue(T t) throws XDBDataReaderException {
        try {
            this.putRowValue(t, null);
            Object var3_2 = null;
            this.notify();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.notify();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized T getNextRowValue() {
        T t;
        try {
            while (this.currentSize == 0) {
                if (this.hasFinished) {
                    T t2 = null;
                    Object var4_5 = null;
                    this.notify();
                    return t2;
                }
                try {
                    long l = System.currentTimeMillis();
                    this.wait();
                    this.waitForEmptyBuffer += System.currentTimeMillis() - l;
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.out == this.bufferLimit) {
                this.out = 0;
            }
            --this.currentSize;
            this.currentGroupByHashString = this.groupByHashBuffer[this.out];
            t = this.rowsBuffer[this.out++];
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.notify();
            throw throwable;
        }
        Object var4_6 = null;
        this.notify();
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getNextGroupByHashString() {
        try {
            String string = this.currentGroupByHashString;
            Object var3_2 = null;
            this.notify();
            return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.notify();
            throw throwable;
        }
    }
}

