/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine.loader;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.engine.JDBCPool;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.NodeDBConnectionInfo;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class LoaderConnectionPool {
    private static LoaderConnectionPool instance = null;
    private Map<String, JDBCPool> loaderConnections = null;

    public static final LoaderConnectionPool getConnectionPool() {
        if (instance == null) {
            instance = new LoaderConnectionPool();
        }
        return instance;
    }

    public synchronized Connection getConnection(NodeDBConnectionInfo nodeDBConnectionInfo) {
        JDBCPool jDBCPool;
        if (this.loaderConnections == null) {
            this.loaderConnections = new HashMap<String, JDBCPool>();
        }
        if ((jDBCPool = this.loaderConnections.get(nodeDBConnectionInfo.getDbName())) == null) {
            String string = "xdb.node." + nodeDBConnectionInfo.getNodeID() + ".";
            String string2 = Property.get(string + "jdbcstring", Props.XDB_DEFAULT_JDBCSTRING);
            String string3 = Property.get(string + "jdbcdriver", Props.XDB_DEFAULT_JDBCDRIVER);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("dbhost", nodeDBConnectionInfo.getDbHost());
            if (nodeDBConnectionInfo.getDbPort() > 0) {
                hashMap.put("dbport", "" + nodeDBConnectionInfo.getDbPort());
            }
            hashMap.put("database", nodeDBConnectionInfo.getDbName());
            hashMap.put("dbusername", nodeDBConnectionInfo.getDbUser());
            hashMap.put("dbpassword", nodeDBConnectionInfo.getDbPassword());
            jDBCPool = new JDBCPool(string3, ParseCmdLine.substitute(string2, hashMap), (String)hashMap.get("dbusername"), (String)hashMap.get("dbpassword"), 1, Integer.MAX_VALUE);
            jDBCPool.setGetTimeout(Property.getInt("xdb.jdbc.pool.timeout", Props.XDB_DEFAULT_THREADS_POOL_TIMEOUT));
            jDBCPool.setReleaseTimeout(Property.getInt("xdb.jdbc.pool.idle", Props.XDB_DEFAULT_THREADS_POOL_IDLE));
            this.loaderConnections.put(nodeDBConnectionInfo.getDbName(), jDBCPool);
        }
        return jDBCPool.getConnection();
    }

    public synchronized void releaseConnection(NodeDBConnectionInfo nodeDBConnectionInfo, Connection connection) throws XDBServerException {
        JDBCPool jDBCPool = this.loaderConnections.get(nodeDBConnectionInfo.getDbName());
        jDBCPool.releaseConnection(connection);
    }

    public synchronized void removeDatabase(String string) {
        if (this.loaderConnections == null) {
            return;
        }
        Iterator<Map.Entry<String, JDBCPool>> iterator = this.loaderConnections.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, JDBCPool> entry = iterator.next();
            if (!entry.getKey().startsWith(string) || entry.getKey().lastIndexOf("N") != string.length()) continue;
            entry.getValue().destroy();
            iterator.remove();
        }
    }
}

