/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine.loader;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.engine.loader.DataProcessorThread;
import com.edb.gridsql.engine.loader.DataReaderAndProcessorBuffer;
import com.edb.gridsql.engine.loader.ILoaderConfigInformation;
import com.edb.gridsql.engine.loader.INodeWriter;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetProcessorThread
extends DataProcessorThread<String[]> {
    private String[] colsValue;
    private final StringBuilder rowValueBuffer = new StringBuilder(8192);
    private byte[] outputRow;

    public ResultSetProcessorThread(ILoaderConfigInformation iLoaderConfigInformation, int n, DataReaderAndProcessorBuffer<String[]> dataReaderAndProcessorBuffer) throws Exception {
        super(iLoaderConfigInformation, n, dataReaderAndProcessorBuffer);
    }

    @Override
    protected boolean parseRow() {
        this.outputRow = null;
        this.colsValue = (String[])this.getNextRowValue();
        return this.colsValue != null;
    }

    @Override
    protected void insertGeneratedValues(Map<Integer, String> map) {
        if (map.size() > 0) {
            int n = 0;
            String[] stringArray = new String[this.colsValue.length + map.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = map.containsKey(i) ? map.get(i) : this.colsValue[n++];
            }
            this.colsValue = stringArray;
        }
    }

    @Override
    protected String getValue(int n) {
        return this.colsValue[n - 1];
    }

    @Override
    protected void outputRow(INodeWriter iNodeWriter) throws IOException {
        if (this.outputRow == null) {
            this.outputRow = this.buildValueList(this.colsValue, Props.XDB_LOADER_ROW_VALUE_ESCAPE_BACKSLASHES).getBytes();
        }
        iNodeWriter.writeRow(this.outputRow);
    }

    private String buildValueList(String[] stringArray, boolean bl) {
        this.rowValueBuffer.setLength(0);
        int n = this.suppresSendingNodeId ? stringArray.length - 1 : stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.rowValueBuffer.append(Props.XDB_LOADER_NODEWRITER_DEFAULT_DELIMITER);
            }
            if (stringArray[i] == null) {
                this.rowValueBuffer.append(Props.XDB_LOADER_NODEWRITER_DEFAULT_NULL);
                continue;
            }
            if (bl) {
                stringArray[i] = ParseCmdLine.escape(stringArray[i], -1, false);
            }
            this.rowValueBuffer.append(stringArray[i]);
        }
        return this.rowValueBuffer.toString();
    }

    @Override
    protected int getColumnCount() {
        return this.colsValue.length;
    }
}

