/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine.loader;

import com.edb.gridsql.engine.loader.DataReaderAndProcessorBuffer;
import com.edb.gridsql.exception.XDBDataReaderException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetReaderThread
implements Callable<Boolean> {
    private DataReaderAndProcessorBuffer<String[]> loadBuffer;
    private int columns;
    private ResultSet dataSourceRS;
    private int[] groupHashList;

    public ResultSetReaderThread(ResultSet resultSet, DataReaderAndProcessorBuffer<String[]> dataReaderAndProcessorBuffer, int[] nArray) throws XDBDataReaderException {
        try {
            this.dataSourceRS = resultSet;
            this.columns = this.dataSourceRS.getMetaData().getColumnCount();
            this.loadBuffer = dataReaderAndProcessorBuffer;
            this.groupHashList = nArray;
        }
        catch (Exception exception) {
            throw new XDBDataReaderException(exception);
        }
    }

    public void close() {
        try {
            if (this.dataSourceRS != null) {
                this.dataSourceRS.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String[] readLineFromResultSet() throws XDBDataReaderException {
        try {
            if (!this.dataSourceRS.next()) {
                return null;
            }
            String[] stringArray = new String[this.columns];
            for (int i = 0; i < this.columns; ++i) {
                stringArray[i] = this.dataSourceRS.getString(i + 1);
            }
            return stringArray;
        }
        catch (Exception exception) {
            throw new XDBDataReaderException(exception);
        }
    }

    @Override
    public Boolean call() throws XDBDataReaderException {
        try {
            String[] stringArray;
            while ((stringArray = this.readLineFromResultSet()) != null) {
                this.loadBuffer.putRowValue(stringArray, this.getGroupByHashString());
            }
            Boolean bl = true;
            Object var4_4 = null;
            this.close();
            if (this.loadBuffer != null) {
                this.loadBuffer.markFinished();
            }
            return bl;
        }
        catch (Exception exception) {
            try {
                throw new XDBDataReaderException(exception);
            }
            catch (Throwable throwable) {
                block6: {
                    Object var4_5 = null;
                    this.close();
                    if (this.loadBuffer == null) break block6;
                    this.loadBuffer.markFinished();
                }
                throw throwable;
            }
        }
    }

    private String getGroupByHashString() throws SQLException {
        if (this.groupHashList == null || this.dataSourceRS.isAfterLast()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int n : this.groupHashList) {
            stringBuffer.append(this.dataSourceRS.getString(n));
        }
        return stringBuffer.toString();
    }
}

