/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.Node;
import com.edb.gridsql.metadata.NodeDBConnectionInfo;
import com.edb.gridsql.metadata.SysDatabase;
import java.util.Enumeration;
import java.util.Properties;

public class DBNode {
    private static final int POOL_SIZE = 5;
    private static final long POOL_TIMEOUT = 60000L;
    private Node aNode;
    private SysDatabase aDatabase;
    private boolean online = false;
    private int poolSize = 5;
    private long poolTimeout = 60000L;
    private NodeDBConnectionInfo connectionInfo;

    DBNode(Node node, SysDatabase sysDatabase) {
        this.aNode = node;
        this.aDatabase = sysDatabase;
        node.addDbNode(this);
        sysDatabase.addDbNode(this);
    }

    void remove() {
        this.aNode.removeDBNode(this.aDatabase.getDbname());
        this.aDatabase.removeDBNode(this.aNode.getNodeid());
    }

    public SysDatabase getDatabase() {
        return this.aDatabase;
    }

    public Node getNode() {
        return this.aNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOnline() {
        Object object = MetaData.getMetaData().getStartupLock();
        synchronized (object) {
            return this.online;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnline() {
        Object object;
        Object object2 = object = MetaData.getMetaData().getStartupLock();
        synchronized (object2) {
            this.online = true;
            object.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffline() {
        Object object;
        Object object2 = object = MetaData.getMetaData().getStartupLock();
        synchronized (object2) {
            this.online = false;
            object.notifyAll();
        }
    }

    public String getJdbcString() {
        return this.aNode.getJdbcString(this.aDatabase.getDbname());
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public long getPoolTimeout() {
        return this.poolTimeout;
    }

    public int getNodeId() {
        return this.aNode.getNodeid();
    }

    public String toString() {
        return "{" + this.aDatabase + "," + this.aNode + "}";
    }

    public NodeDBConnectionInfo getNodeDBConnectionInfo() {
        if (this.connectionInfo == null) {
            Properties properties = new Properties();
            String string = "xdb.default.custom.";
            String string2 = "xdb.node." + this.aNode.getNodeid() + ".custom.";
            Enumeration<?> enumeration = Property.getProperties().propertyNames();
            while (enumeration.hasMoreElements()) {
                String string3;
                String string4;
                String string5 = (String)enumeration.nextElement();
                if (string5.startsWith(string2)) {
                    string4 = string5.substring(string2.length());
                    string3 = Property.get(string5);
                    properties.setProperty(string4, string3);
                    continue;
                }
                if (!string5.startsWith(string)) continue;
                string4 = string5.substring(string2.length());
                string3 = Property.get(string5);
                if (properties.containsKey(string4)) continue;
                properties.setProperty(string4, string3);
            }
            this.connectionInfo = new NodeDBConnectionInfo(this.aNode.getNodeid(), this.aNode.getSHost(), this.aNode.getPort(), this.aNode.getNodeDatabaseString(this.aDatabase.getDbname()), this.aNode.getJdbcUser(), this.aNode.getJdbcPassword(), properties);
        }
        return this.connectionInfo;
    }
}

