/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysLogin;
import com.edb.gridsql.metadata.SysUser;
import com.edb.gridsql.parser.SqlAlterUser;
import java.sql.PreparedStatement;

public class SyncAlterUser
implements IMetaDataUpdate {
    private static final XLogger logger = XLogger.getLogger(SyncAlterUser.class);
    private SqlAlterUser parent;
    private String password;
    private String userClass;

    public SyncAlterUser(SqlAlterUser sqlAlterUser) {
        this.parent = sqlAlterUser;
        this.password = sqlAlterUser.getPassword();
        this.userClass = sqlAlterUser.getUserClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(XDBSessionContext xDBSessionContext) throws Exception {
        try {
            StringBuffer stringBuffer = new StringBuffer("update xsysusers set ");
            if (this.password != null) {
                stringBuffer.append("userpwd = ?");
                if (this.userClass != null) {
                    stringBuffer.append(", usertype = ?");
                }
            } else {
                stringBuffer.append("usertype = ?");
            }
            stringBuffer.append(" where userid = ").append(this.parent.getUser().getUserID());
            PreparedStatement preparedStatement = MetaData.getMetaData().prepareStatement(stringBuffer.toString());
            int n = 1;
            if (this.password != null) {
                preparedStatement.setString(n++, SysLogin.encryptPassword(this.password));
            }
            if (this.userClass != null) {
                preparedStatement.setString(n++, this.userClass);
            }
            if (preparedStatement.executeUpdate() != 1) {
                throw new XDBServerException("Failed to update row in \"xsysusers\"");
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        try {
            SysUser sysUser = this.parent.getUser();
            if (this.password != null) {
                sysUser.getLogin().setPassword(this.password, true);
            }
            if (this.userClass != null) {
                sysUser.getLogin().setUserClass(this.userClass);
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }
}

