/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.MetaUtils;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.parser.SqlCreateIndex;
import com.edb.gridsql.parser.SqlCreateIndexKey;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SyncCreateIndex
implements IMetaDataUpdate {
    public static final String SYSTEM_CREATED = "XSYSINDEX_SYSTEM_CREATED";
    private SqlCreateIndex aSqlCreateIndex;
    private SysTable aSysTable;
    private Map<String, Integer> colMap;

    public SyncCreateIndex(SqlCreateIndex sqlCreateIndex, SysDatabase sysDatabase) {
        this.aSqlCreateIndex = sqlCreateIndex;
        this.aSysTable = sysDatabase.getSysTable(sqlCreateIndex.getIndexTableName());
        if (this.aSysTable == null) {
            throw new XDBServerException("The table specified does not exist in the database");
        }
        this.colMap = new HashMap<String, Integer>();
        List<SysColumn> list = this.aSysTable.getColumns();
        for (SysColumn sysColumn : list) {
            this.colMap.put(sysColumn.getColName(), sysColumn.getColID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(XDBSessionContext xDBSessionContext) throws Exception {
        int n = this.aSysTable.getTableId();
        LinkedList<SqlCreateIndexKey> linkedList = new LinkedList<SqlCreateIndexKey>();
        for (SqlCreateIndexKey sqlCreateIndexKey : this.aSqlCreateIndex.getIndexKeyDefinitions()) {
            if (sqlCreateIndexKey.getKeyColumnId() == -1) {
                for (String object : sqlCreateIndexKey.getKeyColumnNames()) {
                    linkedList.add(new SqlCreateIndexKey(this.colMap.get(object), object, sqlCreateIndexKey.isAscending() ? "ASC" : "DESC", sqlCreateIndexKey.getColOperator()));
                }
                continue;
            }
            linkedList.add(sqlCreateIndexKey);
        }
        int n2 = MetaUtils.createIndex(-1, this.aSqlCreateIndex.getIndexName(), n, false, linkedList.toArray(new SqlCreateIndexKey[linkedList.size()]), this.aSqlCreateIndex.getTablespace() == null ? -1 : this.aSqlCreateIndex.getTablespace().getTablespaceID(), this.aSqlCreateIndex.getUsingType(), this.aSqlCreateIndex.getWherePred());
        if (this.aSqlCreateIndex.isUnique()) {
            int n3;
            String string = "SELECT max(constid) FROM xsysconstraints";
            ResultSet resultSet = MetaData.getMetaData().executeQuery(string);
            try {
                resultSet.next();
                n3 = resultSet.getInt(1) + 1;
                Object var9_11 = null;
            }
            catch (Throwable string2) {
                Object var9_12 = null;
                resultSet.close();
                throw string2;
            }
            resultSet.close();
            String string2 = "INSERT INTO xsysconstraints (constid, tableid, consttype, Idxid, issoft) VALUES (" + n3 + "," + n + "," + "'U'" + "," + n2 + "," + "0)";
            MetaData.getMetaData().executeUpdate(string2);
        }
    }

    public void refresh() throws Exception {
        this.aSysTable.readTableInfo();
    }
}

