/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysPermission;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.SysUser;
import com.edb.gridsql.parser.SqlGrant;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SyncGrant
implements IMetaDataUpdate {
    private static final XLogger logger = XLogger.getLogger(SyncGrant.class);
    private SqlGrant parent;
    private int tabprivid = -1;
    private PreparedStatement stmtCreate;
    private PreparedStatement stmtUpdate;

    public SyncGrant(SqlGrant sqlGrant) {
        this.parent = sqlGrant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDefaultPermissions(int n, int n2) throws SQLException {
        Object object;
        if (this.tabprivid == -1) {
            object = MetaData.getMetaData().executeQuery("SELECT max(privid) FROM xsystabprivs");
            try {
                object.next();
                this.tabprivid = object.getInt(1) + 1;
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                object.close();
                throw throwable;
            }
            object.close();
            {
            }
        }
        object = "insert into xsystabprivs (privid, userid, tableid, selectpriv, insertpriv, updatepriv, deletepriv, referencespriv, indexpriv, alterpriv) values (" + this.tabprivid++ + ", " + n2 + ", " + n + ", 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y')";
        if (MetaData.getMetaData().executeUpdate((String)object) != 1) {
            XDBServerException xDBServerException = new XDBServerException("Failed to insert row into \"xsystabprivs\"");
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFor(int n, SysUser sysUser) throws SQLException {
        Object object;
        if (this.tabprivid == -1) {
            object = MetaData.getMetaData().executeQuery("SELECT max(privid) FROM xsystabprivs");
            try {
                object.next();
                this.tabprivid = object.getInt(1) + 1;
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                object.close();
                throw throwable;
            }
            object.close();
            {
            }
        }
        if (this.stmtCreate == null) {
            object = new StringBuffer("insert into xsystabprivs (privid, userid, tableid, selectpriv, insertpriv, updatepriv, deletepriv, referencespriv, indexpriv, alterpriv) values (?, ?, ?, ");
            ((StringBuffer)object).append(this.parent.hasSelect() ? "'Y', " : "'N', ");
            ((StringBuffer)object).append(this.parent.hasInsert() ? "'Y', " : "'N', ");
            ((StringBuffer)object).append(this.parent.hasUpdate() ? "'Y', " : "'N', ");
            ((StringBuffer)object).append(this.parent.hasDelete() ? "'Y', " : "'N', ");
            ((StringBuffer)object).append(this.parent.hasReferences() ? "'Y', " : "'N', ");
            ((StringBuffer)object).append(this.parent.hasIndex() ? "'Y', " : "'N', ");
            ((StringBuffer)object).append(this.parent.hasAlter() ? "'Y')" : "'N')");
            this.stmtCreate = MetaData.getMetaData().prepareStatement(((StringBuffer)object).toString());
        }
        this.stmtCreate.setInt(1, this.tabprivid++);
        if (sysUser == null) {
            this.stmtCreate.setNull(2, 4);
        } else {
            this.stmtCreate.setInt(2, sysUser.getUserID());
        }
        this.stmtCreate.setInt(3, n);
        if (this.stmtCreate.executeUpdate() != 1) {
            object = new XDBServerException("Failed to insert row into \"xsystabprivs\"");
            logger.throwing((Throwable)object);
            throw object;
        }
    }

    private void updateFor(int n) throws SQLException {
        Serializable serializable;
        if (this.stmtUpdate == null) {
            serializable = new StringBuffer("update xsystabprivs set ");
            if (this.parent.hasSelect()) {
                ((StringBuffer)serializable).append("selectpriv = 'Y', ");
            }
            if (this.parent.hasInsert()) {
                ((StringBuffer)serializable).append("insertpriv = 'Y', ");
            }
            if (this.parent.hasUpdate()) {
                ((StringBuffer)serializable).append("updatepriv = 'Y', ");
            }
            if (this.parent.hasDelete()) {
                ((StringBuffer)serializable).append("deletepriv = 'Y', ");
            }
            if (this.parent.hasReferences()) {
                ((StringBuffer)serializable).append("referencespriv = 'Y', ");
            }
            if (this.parent.hasIndex()) {
                ((StringBuffer)serializable).append("indexpriv = 'Y', ");
            }
            if (this.parent.hasAlter()) {
                ((StringBuffer)serializable).append("alterpriv = 'Y', ");
            }
            ((StringBuffer)serializable).setLength(((StringBuffer)serializable).length() - 2);
            ((StringBuffer)serializable).append(" where privid = ?");
            this.stmtUpdate = MetaData.getMetaData().prepareStatement(((StringBuffer)serializable).toString());
        }
        this.stmtUpdate.setInt(1, n);
        if (this.stmtUpdate.executeUpdate() != 1) {
            serializable = new XDBServerException("Failed to update row in \"xsystabprivs\"");
            logger.throwing((Throwable)serializable);
            throw serializable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(XDBSessionContext xDBSessionContext) throws Exception {
        try {
            for (SysTable sysTable : this.parent.getTableList()) {
                if (sysTable.getSysPermissions().isEmpty()) {
                    this.createDefaultPermissions(sysTable.getTableId(), sysTable.getOwner().getUserID());
                    this.parent.getGranteeList().remove(sysTable.getOwner());
                }
                for (SysUser sysUser : this.parent.getGranteeList()) {
                    SysPermission sysPermission = sysTable.getSysPermission(sysUser);
                    if (sysPermission == null) {
                        this.createFor(sysTable.getTableId(), sysUser);
                        continue;
                    }
                    this.updateFor(sysPermission.getPermissionId());
                }
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        try {
            for (SysTable sysTable : this.parent.getTableList()) {
                sysTable.readPermissionsInfo();
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            throw throwable;
        }
    }
}

